/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina
  
  This file is part of OMPi.
  
  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef __MODMAIN_H__
#define __MODMAIN_H__

#include <stdint.h>
#include "../../../rt_common.h"
#include "../../../../common/stddefs.h"

extern char *modulename;
extern char *__currfunc__; /* dummy */

extern int   hm_get_num_devices(void);
extern void  hm_print_information(int device_offset);
extern void *hm_initialize(int dev_num, ort_icvs_t *ort_env, int *argc, char ***argv);
extern void  hm_finalize(void *device_info);
extern void  hm_offload(void *device_info, void *(*host_func)(void *), void *dev_data,
                        void *decl_data, char *kernel_filename_prefix, int num_teams,
                        int num_threads, int thread_limit, 
                        unsigned long long teamdims, unsigned long long thrdims, 
                        int *num_args, void **args);
extern void *hm_dev_alloc(void *device_info, size_t size, int map_memory, void *hostaddr);
extern void  hm_dev_free(void *device_info, void *iaddr, int unmap_memory);

extern void  hm_todev(void *devinfo, void *hostaddr,size_t hostoffset,
                      void *imedaddr, size_t devoffset, size_t size);
extern void  hm_fromdev(void *devinfo, void *hostaddr,size_t hostoffset,
                        void *imedaddr, size_t devoffset, size_t size);
extern void *hm_imed2umed_addr(void *device_info, void *imedaddr);
extern void *hm_umed2imed_addr(void *device_info, void *umedaddr);

#endif /* __MODMAIN_H__ */
