/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sections.c
 * This file implements sections
 */

#include <stdio.h>
#include "locks.h"
#include "worksharing.h"
#include "barrier.h"
#include "parallel.h"


__DEVQLFR 
void ort_entering_sections(int nowait, int numberofsections)
{
	enter_ws_region(_OMP_SECTIONS, nowait, 0, numberofsections);
}

__DEVQLFR 
void ort_leaving_sections()
{
	leave_ws_region(_OMP_SECTIONS);
}

__DEVQLFR 
int ort_get_section()
{
	ort_workshare_t *r;
	int        s = -1;
	int id = omp_get_thread_num(), nthrtosync;
	
	r = &(workshare);
	if (r->sectionsleft < 0 || (id % warpSize) != 0) return (-1);
	
	nthrtosync = ceilf(get_parallel_active_threads() / warpSize);
	
	CUDA_SET_LOCK_PARTSYNC(r->wslock.mutex, 1, nthrtosync);
	if (r->sectionsleft > 0)
	{
		s = --(r->sectionsleft);
	}
	CUDA_UNSET_LOCK_PARTSYNC(r->wslock.mutex);
	
	return (s);
}
