/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdio.h>
#include <stdbool.h>
#include "locks.h"
#include "globals.h"
#include "parallel.h"
#include "worksharing.h"
#include "barrier.h"

/* critical.c
 * This file implements critical sections
 */

__SHAREDQLFR cudalock_t critical_lock;

__DEVQLFR 
void ort_critical_begin(void **cl)
{
	if (omp_get_thread_num() == 0)
	{
		critical_lock.in_area = true;
		critical_lock.mutex_init = true;
		critical_lock.mutex = 0;
	}
	cudadev_namedbar_sync(1, get_parallel_active_threads());
}

__DEVQLFR 
void ort_critical_end(void **cl)
{
	if (omp_get_thread_num() == 0)
	{
		critical_lock.in_area = false;
		critical_lock.mutex_init = false;
		critical_lock.mutex = -1;
	}
	cudadev_namedbar_sync(1, get_parallel_active_threads());
}

__DEVQLFR 
int *cudadev_get_criticallock(void)
{
	return &(critical_lock.mutex);
}
