/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_kernels.h -- kernel production-related code */

#ifndef __X_KERNELS_H__
#define __X_KERNELS_H__

#include "ast.h"
#include "stddefs.h"
#include "callgraph.h"
#include "builder.h"
#include "x_cars.h"

/* For GPU kernels */
#define DEVQUAL "__DEVQLFR"
#define DEVSPEC "__DEVSPEC"
#define DEVSPECQUAL "__DEVQLFR __DEVSPEC"
#define SHAREDQUAL "__SHAREDQLFR"
#define DEVSPECit(stmt,str) ast_declordef_addspec(stmt, Usertype(Symbol(str)))

#define CUDA_KERNEL_SUFFIX "-" FIRST_CUDA_MODULE ".c"

typedef struct mod_kern_
{
	char *modulename;
  void (*producefunc)();
} mod_kern_t;

typedef struct target_list_
{
	char                *kernelfile;
	char                *kernelfile_opencl;
	char                *functionName;
	aststmt              tree, newglobals, rep_struct;
	bool                 emptyde;              /* true if empty data env */
	astexpr              decl_struct;
	set(cgfun)           calledfuncs;          /* all called funcs */
	aststmt              gpu_wrapper_body;     /* for OpenCL/CUDA */
	astdecl              gpu_wrapper_params;   /* for OpenCL/CUDA */
	targstats_t         *ts;                   /* For CARS */
	struct target_list_ *next;
} *target_list_t;

extern void xkn_produce_decl_var_code();
extern void xkn_produce_targfiles();
extern void xkn_kernel_add(target_list_t *target, char *modulename);

#endif
