/*
	OMPi OpenMP Compiler
	== Copyright since 2001 the OMPi Team
	== Dept. of Computer Science & Engineering, University of Ioannina

	This file is part of OMPi.

	OMPi is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	OMPi is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with OMPi; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* autoscope.h */

#ifndef __AUTOSCOPE_H__
#define __AUTOSCOPE_H__

#include "ast.h"
#include "set.h"

/* Set type for autoscoping (key: symbol, value: dontcare) */
SET_TYPE_DEFINE(autoset, symbol, char, 389)

#define AUTOSC_CRITICAL 0
#define AUTOSC_MASTER 2
#define AUTOSC_SINGLE 4
#define AUTOSC_ATOMIC 6
#define AUTOSC_FREE 8
#define AUTOSC_PFCI 10

#define AUTOSC_PRIVATE 0
#define AUTOSC_FIRSTPRIVATE 1
#define AUTOSC_SHARED 2
#define AUTOSC_REDUCTION 3
#define AUTOSC_LASTPRIVATE 4
#define AUTOSC_DEFAUTO 5

#define NCASES 12

typedef struct
{
	set(autoset) autoShared;
	set(autoset) autoPrivate;
	set(autoset) autoFirstPrivate;
	set(autoset) autoUnk;
	set(autoset) autoReduction;
	set(autoset) autoAllVars;
	set(autoset) autoAuto;
	int line;
} autoshattr_t;

extern void autoscope_userfunc_add(symbol f, aststmt fBody);
extern autoshattr_t autoscope(aststmt tree);
extern autoshattr_t *autoscope_parreg_get_results(int line);
extern void autoscope_parreg_remove(int line);

#endif /* __AUTOSCOPE_H__ */
