/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* This file provides an API for easy identification of supported devices
 * of the mpinode module based on a configuration file. It also provides a
 * way to start such devices.
 */

#ifndef _DEV_MANAGER_H
#define _DEV_MANAGER_H

#include <mpi.h>

#define MPINODE_CONFIG "/.ompi_mpi_nodes"    /* will be appended to $HOME */

void     devman_init();
MPI_Comm devman_create_devices(int *argc, char ***argv);
int      devman_get_num_devices();
char    *devman_get_devicename(int devid);
void     devman_finalize();

#endif /* _DEV_MANAGER_H */
