/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* ast_xformrules.h  */

#include "ast.h"
#include "set.h"
#include "x_kernels.h"

#ifndef __AST_XFORMRULES_H__
#define __AST_XFORMRULES_H__

#define XFR_NONE 0
#define XFR_SPLITONLY 1
#define XFR_COMBINEONLY 2
#define XFR_BOTH 3

typedef struct xfr_vars_
{
	aststmt *tree, targtree;
	aststmt newglobals;
	target_list_t Targets;
	int targetnum;
} *xfr_vars_t;

typedef struct 
{
	struct {
    	bool initialized;
		void (*xform_func)(aststmt *t);
    	int combsplittype;
	} rules[DCLASTDIR];
	xfr_vars_t vars;
	int origindex;
} xfr_modrules_t;

SET_TYPE_DEFINE(xformrules, char *, xfr_modrules_t *, 389)
extern set(xformrules) ast_xfrules;
#define DEFAULTDEVICE           "_"

extern void ast_xfr_initrules();
extern void ast_xfr_call_xformfunc(char *modulename, aststmt *t);
extern void ast_xfr_gen_tree_copies(aststmt *t);
extern void ast_xfr_free_tree_copies();
extern setelem(xformrules) ast_xfr_get_defaultrules();
extern bool ast_xfr_type_issupported(ompdirt_e type);
#endif
