/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "parser.y" /* yacc.c:339  */

/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* parser.y */

/*
 * 2010/11/10:
 *   dropped OpenMP-specific for parsing; fewer rules, less code
 * 2009/05/11:
 *   added AUTO schedule type
 * 2009/05/03:
 *   added ATNODE ompix clause
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <stdarg.h>
#include <ctype.h>
#include <assert.h>
#include "scanner.h"
#include "ompi.h"
#include "ast.h"
#include "symtab.h"
#include "ast_free.h"
#include "ast_copy.h"
#include "ast_vars.h"
#include "ast_print.h"
#include "ast_arith.h"
#include "x_clauses.h"
#include "str.h"

void    check_uknown_var(char *name);
void    parse_error(int exitvalue, char *format, ...);
void    parse_warning(char *format, ...);
void    yyerror(const char *s);
void    check_for_main_and_declare(astspec s, astdecl d);
void    add_declaration_links(astspec s, astdecl d);
astdecl fix_known_typename(astspec s);
void    check_schedule(ompclsubt_e sched, ompclmod_e mod);
char    *strdupcat(char *first, char *second, int freethem);


aststmt pastree = NULL;       /* The generated AST */
aststmt pastree_stmt = NULL;  /* For when parsing statment strings */
astexpr pastree_expr = NULL;  /* For when parsing expression strings */
int     checkDecls = 1;       /* 0 when scanning strings (no context check) */
int     tempsave;
int     isTypedef  = 0;       /* To keep track of typedefs */

char    *parsingstring;       /* For error reporting when parsing string */

int     __has_target = 0;

//TODO this is not 100% correct (e.g. if returns lies in a dead code area).
/* Return and goto statements that lead outside the outlined region constitute
 * programmer errors and so we should stop the compilation. When simply 
 * analyzing vars (and not outlining) we ignore this rule.
 */
int     errorOnReturn = 0;

#line 150 "parser.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    NOELSE = 258,
    ELSE = 259,
    START_SYMBOL_EXPRESSION = 260,
    START_SYMBOL_BLOCKLIST = 261,
    START_SYMBOL_TRANSUNIT = 262,
    IDENTIFIER = 263,
    TYPE_NAME = 264,
    CONSTANT = 265,
    STRING_LITERAL = 266,
    PTR_OP = 267,
    INC_OP = 268,
    DEC_OP = 269,
    LEFT_OP = 270,
    RIGHT_OP = 271,
    LE_OP = 272,
    GE_OP = 273,
    EQ_OP = 274,
    NE_OP = 275,
    AND_OP = 276,
    OR_OP = 277,
    MUL_ASSIGN = 278,
    DIV_ASSIGN = 279,
    MOD_ASSIGN = 280,
    ADD_ASSIGN = 281,
    SUB_ASSIGN = 282,
    LEFT_ASSIGN = 283,
    RIGHT_ASSIGN = 284,
    AND_ASSIGN = 285,
    XOR_ASSIGN = 286,
    OR_ASSIGN = 287,
    SIZEOF = 288,
    TYPEDEF = 289,
    EXTERN = 290,
    STATIC = 291,
    AUTO = 292,
    REGISTER = 293,
    RESTRICT = 294,
    CHAR = 295,
    SHORT = 296,
    INT = 297,
    LONG = 298,
    SIGNED = 299,
    UNSIGNED = 300,
    FLOAT = 301,
    DOUBLE = 302,
    CONST = 303,
    VOLATILE = 304,
    VOID = 305,
    INLINE = 306,
    UBOOL = 307,
    UCOMPLEX = 308,
    UIMAGINARY = 309,
    STRUCT = 310,
    UNION = 311,
    ENUM = 312,
    ELLIPSIS = 313,
    CASE = 314,
    DEFAULT = 315,
    IF = 316,
    SWITCH = 317,
    WHILE = 318,
    DO = 319,
    FOR = 320,
    GOTO = 321,
    CONTINUE = 322,
    BREAK = 323,
    RETURN = 324,
    __BUILTIN_VA_ARG = 325,
    __BUILTIN_OFFSETOF = 326,
    __BUILTIN_TYPES_COMPATIBLE_P = 327,
    __ATTRIBUTE__ = 328,
    __ASM__ = 329,
    PRAGMA_OTHER = 330,
    PRAGMA_OMP = 331,
    PRAGMA_OMP_THREADPRIVATE = 332,
    OMP_PARALLEL = 333,
    OMP_SECTIONS = 334,
    OMP_NOWAIT = 335,
    OMP_ORDERED = 336,
    OMP_SCHEDULE = 337,
    OMP_STATIC = 338,
    OMP_DYNAMIC = 339,
    OMP_GUIDED = 340,
    OMP_RUNTIME = 341,
    OMP_AUTO = 342,
    OMP_SECTION = 343,
    OMP_AFFINITY = 344,
    OMP_SINGLE = 345,
    OMP_MASTER = 346,
    OMP_CRITICAL = 347,
    OMP_BARRIER = 348,
    OMP_ATOMIC = 349,
    OMP_FLUSH = 350,
    OMP_PRIVATE = 351,
    OMP_FIRSTPRIVATE = 352,
    OMP_LASTPRIVATE = 353,
    OMP_SHARED = 354,
    OMP_DEFAULT = 355,
    OMP_NONE = 356,
    OMP_REDUCTION = 357,
    OMP_COPYIN = 358,
    OMP_NUMTHREADS = 359,
    OMP_COPYPRIVATE = 360,
    OMP_FOR = 361,
    OMP_IF = 362,
    OMP_TASK = 363,
    OMP_UNTIED = 364,
    OMP_TASKWAIT = 365,
    OMP_COLLAPSE = 366,
    OMP_FINAL = 367,
    OMP_MERGEABLE = 368,
    OMP_TASKYIELD = 369,
    OMP_READ = 370,
    OMP_WRITE = 371,
    OMP_CAPTURE = 372,
    OMP_UPDATE = 373,
    OMP_MIN = 374,
    OMP_MAX = 375,
    OMP_PROCBIND = 376,
    OMP_CLOSE = 377,
    OMP_SPREAD = 378,
    OMP_SIMD = 379,
    OMP_INBRANCH = 380,
    OMP_NOTINBRANCH = 381,
    OMP_UNIFORM = 382,
    OMP_LINEAR = 383,
    OMP_ALIGNED = 384,
    OMP_SIMDLEN = 385,
    OMP_SAFELEN = 386,
    OMP_DECLARE = 387,
    OMP_TARGET = 388,
    OMP_DATA = 389,
    OMP_DEVICE = 390,
    OMP_MAP = 391,
    OMP_ALLOC = 392,
    OMP_TO = 393,
    OMP_FROM = 394,
    OMP_TOFROM = 395,
    OMP_END = 396,
    OMP_TEAMS = 397,
    OMP_DISTRIBUTE = 398,
    OMP_NUMTEAMS = 399,
    OMP_THREADLIMIT = 400,
    OMP_DISTSCHEDULE = 401,
    OMP_DEPEND = 402,
    OMP_IN = 403,
    OMP_OUT = 404,
    OMP_INOUT = 405,
    OMP_TASKGROUP = 406,
    OMP_SEQ_CST = 407,
    OMP_CANCEL = 408,
    OMP_INITIALIZER = 409,
    PRAGMA_OMP_CANCELLATIONPOINT = 410,
    PRAGMA_OMP_DECLARETARGET = 411,
    PRAGMA_OMP_ENDDECLARETARGET = 412,
    OMP_HINT = 413,
    OMP_SOURCE = 414,
    OMP_SINK = 415,
    OMP_RELEASE = 416,
    OMP_DELETE = 417,
    OMP_ALWAYS = 418,
    OMP_ENTER = 419,
    OMP_EXIT = 420,
    OMP_IS_DEVICE_PTR = 421,
    OMP_USE_DEVICE_PTR = 422,
    OMP_PRIORITY = 423,
    OMP_TASKLOOP = 424,
    OMP_THREADS = 425,
    OMP_LINK = 426,
    OMP_DEFAULTMAP = 427,
    OMP_SCALAR = 428,
    OMP_MONOTONIC = 429,
    OMP_NONMONOTONIC = 430,
    OMP_PRIMARY = 431,
    PRAGMA_OMPIX = 432,
    OMPIX_TASKDEF = 433,
    OMPIX_TASKSYNC = 434,
    OMPIX_UPONRETURN = 435,
    OMPIX_ATNODE = 436,
    OMPIX_DETACHED = 437,
    OMPIX_ATWORKER = 438,
    OMPIX_TASKSCHEDULE = 439,
    OMPIX_STRIDE = 440,
    OMPIX_START = 441,
    OMPIX_SCOPE = 442,
    OMPIX_NODES = 443,
    OMPIX_WORKERS = 444,
    OMPIX_LOCAL = 445,
    OMPIX_GLOBAL = 446,
    OMPIX_HERE = 447,
    OMPIX_REMOTE = 448,
    OMPIX_HINTS = 449,
    OMPIX_TIED = 450,
    OMPIX_PROCEXTERN = 451,
    OMPIX_TAG = 452
  };
#endif
/* Tokens.  */
#define NOELSE 258
#define ELSE 259
#define START_SYMBOL_EXPRESSION 260
#define START_SYMBOL_BLOCKLIST 261
#define START_SYMBOL_TRANSUNIT 262
#define IDENTIFIER 263
#define TYPE_NAME 264
#define CONSTANT 265
#define STRING_LITERAL 266
#define PTR_OP 267
#define INC_OP 268
#define DEC_OP 269
#define LEFT_OP 270
#define RIGHT_OP 271
#define LE_OP 272
#define GE_OP 273
#define EQ_OP 274
#define NE_OP 275
#define AND_OP 276
#define OR_OP 277
#define MUL_ASSIGN 278
#define DIV_ASSIGN 279
#define MOD_ASSIGN 280
#define ADD_ASSIGN 281
#define SUB_ASSIGN 282
#define LEFT_ASSIGN 283
#define RIGHT_ASSIGN 284
#define AND_ASSIGN 285
#define XOR_ASSIGN 286
#define OR_ASSIGN 287
#define SIZEOF 288
#define TYPEDEF 289
#define EXTERN 290
#define STATIC 291
#define AUTO 292
#define REGISTER 293
#define RESTRICT 294
#define CHAR 295
#define SHORT 296
#define INT 297
#define LONG 298
#define SIGNED 299
#define UNSIGNED 300
#define FLOAT 301
#define DOUBLE 302
#define CONST 303
#define VOLATILE 304
#define VOID 305
#define INLINE 306
#define UBOOL 307
#define UCOMPLEX 308
#define UIMAGINARY 309
#define STRUCT 310
#define UNION 311
#define ENUM 312
#define ELLIPSIS 313
#define CASE 314
#define DEFAULT 315
#define IF 316
#define SWITCH 317
#define WHILE 318
#define DO 319
#define FOR 320
#define GOTO 321
#define CONTINUE 322
#define BREAK 323
#define RETURN 324
#define __BUILTIN_VA_ARG 325
#define __BUILTIN_OFFSETOF 326
#define __BUILTIN_TYPES_COMPATIBLE_P 327
#define __ATTRIBUTE__ 328
#define __ASM__ 329
#define PRAGMA_OTHER 330
#define PRAGMA_OMP 331
#define PRAGMA_OMP_THREADPRIVATE 332
#define OMP_PARALLEL 333
#define OMP_SECTIONS 334
#define OMP_NOWAIT 335
#define OMP_ORDERED 336
#define OMP_SCHEDULE 337
#define OMP_STATIC 338
#define OMP_DYNAMIC 339
#define OMP_GUIDED 340
#define OMP_RUNTIME 341
#define OMP_AUTO 342
#define OMP_SECTION 343
#define OMP_AFFINITY 344
#define OMP_SINGLE 345
#define OMP_MASTER 346
#define OMP_CRITICAL 347
#define OMP_BARRIER 348
#define OMP_ATOMIC 349
#define OMP_FLUSH 350
#define OMP_PRIVATE 351
#define OMP_FIRSTPRIVATE 352
#define OMP_LASTPRIVATE 353
#define OMP_SHARED 354
#define OMP_DEFAULT 355
#define OMP_NONE 356
#define OMP_REDUCTION 357
#define OMP_COPYIN 358
#define OMP_NUMTHREADS 359
#define OMP_COPYPRIVATE 360
#define OMP_FOR 361
#define OMP_IF 362
#define OMP_TASK 363
#define OMP_UNTIED 364
#define OMP_TASKWAIT 365
#define OMP_COLLAPSE 366
#define OMP_FINAL 367
#define OMP_MERGEABLE 368
#define OMP_TASKYIELD 369
#define OMP_READ 370
#define OMP_WRITE 371
#define OMP_CAPTURE 372
#define OMP_UPDATE 373
#define OMP_MIN 374
#define OMP_MAX 375
#define OMP_PROCBIND 376
#define OMP_CLOSE 377
#define OMP_SPREAD 378
#define OMP_SIMD 379
#define OMP_INBRANCH 380
#define OMP_NOTINBRANCH 381
#define OMP_UNIFORM 382
#define OMP_LINEAR 383
#define OMP_ALIGNED 384
#define OMP_SIMDLEN 385
#define OMP_SAFELEN 386
#define OMP_DECLARE 387
#define OMP_TARGET 388
#define OMP_DATA 389
#define OMP_DEVICE 390
#define OMP_MAP 391
#define OMP_ALLOC 392
#define OMP_TO 393
#define OMP_FROM 394
#define OMP_TOFROM 395
#define OMP_END 396
#define OMP_TEAMS 397
#define OMP_DISTRIBUTE 398
#define OMP_NUMTEAMS 399
#define OMP_THREADLIMIT 400
#define OMP_DISTSCHEDULE 401
#define OMP_DEPEND 402
#define OMP_IN 403
#define OMP_OUT 404
#define OMP_INOUT 405
#define OMP_TASKGROUP 406
#define OMP_SEQ_CST 407
#define OMP_CANCEL 408
#define OMP_INITIALIZER 409
#define PRAGMA_OMP_CANCELLATIONPOINT 410
#define PRAGMA_OMP_DECLARETARGET 411
#define PRAGMA_OMP_ENDDECLARETARGET 412
#define OMP_HINT 413
#define OMP_SOURCE 414
#define OMP_SINK 415
#define OMP_RELEASE 416
#define OMP_DELETE 417
#define OMP_ALWAYS 418
#define OMP_ENTER 419
#define OMP_EXIT 420
#define OMP_IS_DEVICE_PTR 421
#define OMP_USE_DEVICE_PTR 422
#define OMP_PRIORITY 423
#define OMP_TASKLOOP 424
#define OMP_THREADS 425
#define OMP_LINK 426
#define OMP_DEFAULTMAP 427
#define OMP_SCALAR 428
#define OMP_MONOTONIC 429
#define OMP_NONMONOTONIC 430
#define OMP_PRIMARY 431
#define PRAGMA_OMPIX 432
#define OMPIX_TASKDEF 433
#define OMPIX_TASKSYNC 434
#define OMPIX_UPONRETURN 435
#define OMPIX_ATNODE 436
#define OMPIX_DETACHED 437
#define OMPIX_ATWORKER 438
#define OMPIX_TASKSCHEDULE 439
#define OMPIX_STRIDE 440
#define OMPIX_START 441
#define OMPIX_SCOPE 442
#define OMPIX_NODES 443
#define OMPIX_WORKERS 444
#define OMPIX_LOCAL 445
#define OMPIX_GLOBAL 446
#define OMPIX_HERE 447
#define OMPIX_REMOTE 448
#define OMPIX_HINTS 449
#define OMPIX_TIED 450
#define OMPIX_PROCEXTERN 451
#define OMPIX_TAG 452

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 85 "parser.y" /* yacc.c:355  */

  char      name[2048];  /* A general string */
  int       type;        /* A general integer */
  char     *string;      /* A dynamically allocated string (only for 2 rules) */
  symbol    symb;        /* A symbol */
  astexpr   expr;        /* An expression node in the AST */
  astspec   spec;        /* A declaration specifier node in the AST */
  astdecl   decl;        /* A declarator node in the AST */
  aststmt   stmt;        /* A statement node in the AST */
  asmop     asmo;        /* An asm operand */
  ompcon    ocon;        /* An OpenMP construct */
  ompdir    odir;        /* An OpenMP directive */
  ompclause ocla;        /* An OpenMP clause */
  omparrdim oasd;        /* An array section dimension/slice */
  ompxli    oxli;        /* OpenMP extended list items (ids/array secitons) */

  oxcon     xcon;        /* OMPi extensions */
  oxdir     xdir;
  oxclause  xcla;

#line 605 "parser.c" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 622 "parser.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  245
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   5308

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  223
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  387
/* YYNRULES -- Number of rules.  */
#define YYNRULES  994
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1670

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   452

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     222,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   211,     2,     2,     2,   213,   206,     2,
     198,   199,   207,   208,   205,   209,   202,   212,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   219,   221,
     214,   220,   215,   218,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   200,     2,   201,   216,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   203,   217,   204,   210,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   550,   550,   551,   552,   553,   570,   591,   595,   618,
     640,   644,   648,   659,   663,   673,   680,   684,   688,   697,
     701,   705,   709,   713,   717,   726,   729,   733,   741,   745,
     749,   753,   760,   764,   773,   778,   783,   792,   796,   800,
     804,   808,   812,   820,   824,   832,   836,   840,   844,   852,
     856,   860,   868,   872,   876,   884,   888,   892,   896,   900,
     908,   912,   916,   924,   928,   936,   940,   948,   952,   960,
     964,   972,   976,   984,   988,   996,  1000,  1008,  1012,  1016,
    1020,  1024,  1028,  1032,  1036,  1040,  1044,  1048,  1056,  1060,
    1068,  1082,  1097,  1104,  1109,  1113,  1117,  1125,  1129,  1133,
    1137,  1141,  1145,  1149,  1153,  1161,  1165,  1179,  1196,  1195,
    1218,  1223,  1227,  1231,  1235,  1243,  1247,  1251,  1255,  1259,
    1263,  1267,  1271,  1275,  1279,  1283,  1287,  1291,  1295,  1299,
    1308,  1312,  1316,  1331,  1338,  1345,  1356,  1360,  1368,  1372,
    1380,  1384,  1392,  1396,  1400,  1404,  1412,  1416,  1424,  1428,
    1432,  1440,  1444,  1457,  1469,  1473,  1485,  1497,  1505,  1517,
    1521,  1529,  1533,  1541,  1545,  1549,  1553,  1561,  1569,  1573,
    1586,  1590,  1598,  1602,  1606,  1610,  1614,  1618,  1622,  1626,
    1630,  1634,  1638,  1642,  1650,  1654,  1658,  1662,  1670,  1674,
    1682,  1686,  1694,  1698,  1706,  1710,  1714,  1722,  1726,  1734,
    1738,  1746,  1750,  1754,  1762,  1766,  1770,  1774,  1778,  1782,
    1786,  1790,  1794,  1798,  1802,  1810,  1818,  1822,  1826,  1834,
    1838,  1842,  1846,  1854,  1862,  1866,  1874,  1878,  1882,  1896,
    1900,  1904,  1908,  1912,  1916,  1920,  1924,  1929,  1945,  1953,
    1957,  1967,  1971,  1975,  1983,  1987,  1987,  1998,  2002,  2011,
    2015,  2019,  2024,  2033,  2037,  2046,  2050,  2054,  2063,  2067,
    2071,  2075,  2079,  2083,  2087,  2091,  2095,  2099,  2103,  2107,
    2111,  2115,  2119,  2127,  2132,  2136,  2140,  2147,  2164,  2168,
    2176,  2180,  2187,  2191,  2195,  2207,  2208,  2213,  2212,  2239,
    2238,  2274,  2273,  2302,  2301,  2339,  2343,  2363,  2367,  2374,
    2378,  2382,  2386,  2390,  2397,  2401,  2408,  2409,  2413,  2416,
    2420,  2427,  2431,  2438,  2441,  2445,  2452,  2456,  2463,  2467,
    2474,  2478,  2491,  2494,  2501,  2505,  2512,  2519,  2523,  2540,
    2543,  2547,  2563,  2564,  2565,  2584,  2588,  2596,  2605,  2609,
    2616,  2620,  2624,  2628,  2632,  2636,  2640,  2644,  2648,  2652,
    2657,  2662,  2666,  2670,  2674,  2678,  2682,  2686,  2690,  2694,
    2698,  2702,  2706,  2710,  2714,  2718,  2722,  2726,  2730,  2734,
    2738,  2742,  2747,  2763,  2767,  2772,  2777,  2782,  2787,  2792,
    2797,  2802,  2809,  2816,  2824,  2832,  2835,  2839,  2846,  2850,
    2854,  2858,  2862,  2866,  2870,  2877,  2877,  2882,  2882,  2888,
    2893,  2893,  2901,  2908,  2916,  2919,  2932,  2948,  2952,  2956,
    2960,  2964,  2968,  2975,  2979,  2991,  2997,  2996,  3006,  3005,
    3017,  3021,  3028,  3032,  3036,  3040,  3044,  3048,  3053,  3056,
    3060,  3067,  3074,  3082,  3085,  3089,  3096,  3100,  3104,  3108,
    3112,  3119,  3126,  3131,  3135,  3142,  3149,  3156,  3164,  3167,
    3171,  3178,  3182,  3186,  3190,  3197,  3197,  3206,  3214,  3222,
    3225,  3229,  3237,  3241,  3245,  3249,  3253,  3257,  3265,  3277,
    3281,  3289,  3293,  3301,  3301,  3310,  3310,  3319,  3319,  3328,
    3331,  3339,  3347,  3351,  3359,  3367,  3370,  3374,  3383,  3395,
    3399,  3403,  3407,  3415,  3423,  3431,  3434,  3438,  3445,  3449,
    3457,  3465,  3473,  3476,  3480,  3487,  3491,  3499,  3508,  3516,
    3519,  3523,  3530,  3534,  3542,  3546,  3554,  3554,  3564,  3564,
    3569,  3569,  3579,  3582,  3586,  3594,  3598,  3602,  3606,  3610,
    3614,  3622,  3622,  3631,  3640,  3640,  3649,  3649,  3660,  3668,
    3671,  3675,  3682,  3686,  3690,  3694,  3698,  3702,  3709,  3713,
    3721,  3725,  3733,  3744,  3748,  3752,  3759,  3766,  3770,  3774,
    3778,  3785,  3796,  3800,  3804,  3811,  3819,  3823,  3827,  3831,
    3839,  3847,  3851,  3855,  3862,  3866,  3870,  3874,  3878,  3885,
    3885,  3890,  3890,  3900,  3905,  3912,  3919,  3927,  3932,  3940,
    3944,  3948,  3956,  3956,  3962,  3961,  3979,  3989,  3997,  4000,
    4004,  4011,  4015,  4019,  4023,  4027,  4031,  4041,  4041,  4047,
    4047,  4058,  4059,  4065,  4073,  4081,  4084,  4088,  4095,  4099,
    4103,  4107,  4111,  4118,  4122,  4122,  4131,  4140,  4148,  4151,
    4155,  4162,  4166,  4170,  4178,  4187,  4195,  4198,  4211,  4227,
    4231,  4239,  4248,  4256,  4259,  4263,  4270,  4274,  4282,  4291,
    4299,  4302,  4306,  4313,  4317,  4321,  4325,  4329,  4337,  4346,
    4354,  4357,  4361,  4368,  4372,  4376,  4380,  4384,  4388,  4392,
    4396,  4400,  4404,  4412,  4420,  4428,  4431,  4435,  4442,  4446,
    4450,  4454,  4462,  4470,  4478,  4481,  4485,  4492,  4496,  4500,
    4504,  4512,  4521,  4529,  4532,  4536,  4543,  4547,  4551,  4555,
    4559,  4567,  4576,  4585,  4588,  4593,  4601,  4605,  4609,  4613,
    4621,  4630,  4639,  4642,  4656,  4673,  4677,  4685,  4695,  4703,
    4706,  4719,  4735,  4739,  4743,  4747,  4755,  4764,  4772,  4775,
    4779,  4786,  4790,  4798,  4808,  4816,  4819,  4823,  4830,  4834,
    4838,  4842,  4850,  4859,  4867,  4870,  4883,  4899,  4903,  4907,
    4911,  4919,  4928,  4937,  4940,  4944,  4952,  4956,  4960,  4964,
    4968,  4972,  4976,  4984,  4984,  4989,  4993,  4998,  5006,  5006,
    5015,  5019,  5023,  5030,  5038,  5046,  5049,  5062,  5078,  5082,
    5086,  5090,  5094,  5098,  5102,  5106,  5110,  5117,  5125,  5133,
    5136,  5140,  5147,  5151,  5155,  5159,  5163,  5167,  5171,  5175,
    5182,  5189,  5196,  5203,  5207,  5212,  5219,  5227,  5234,  5242,
    5250,  5258,  5266,  5273,  5284,  5292,  5295,  5299,  5303,  5307,
    5316,  5319,  5326,  5330,  5337,  5337,  5345,  5349,  5356,  5363,
    5367,  5376,  5379,  5383,  5391,  5395,  5403,  5407,  5411,  5419,
    5427,  5431,  5438,  5444,  5450,  5460,  5464,  5468,  5475,  5479,
    5483,  5487,  5495,  5502,  5502,  5502,  5510,  5510,  5510,  5517,
    5524,  5528,  5532,  5536,  5540,  5544,  5548,  5552,  5556,  5560,
    5567,  5571,  5579,  5582,  5587,  5598,  5602,  5607,  5614,  5614,
    5622,  5622,  5630,  5630,  5638,  5638,  5646,  5646,  5655,  5655,
    5661,  5661,  5669,  5670,  5671,  5672,  5673,  5674,  5675,  5676,
    5677,  5681,  5696,  5703,  5713,  5717,  5728,  5735,  5749,  5753,
    5764,  5769,  5777,  5777,  5786,  5786,  5794,  5798,  5802,  5806,
    5810,  5818,  5822,  5826,  5830,  5842,  5860,  5893,  5897,  5904,
    5912,  5911,  5924,  5927,  5931,  5938,  5942,  5946,  5950,  5954,
    5961,  5965,  5969,  5973,  5980,  5984,  5988,  5992,  6001,  6000,
    6017,  6026,  6025,  6038,  6041,  6045,  6052,  6056,  6060,  6064,
    6071,  6075,  6082,  6087,  6095,  6103,  6112,  6120,  6123,  6127,
    6134,  6138,  6142,  6146,  6150,  6154,  6158,  6162,  6166,  6170,
    6178,  6186,  6186,  6185,  6194,  6207,  6223,  6227,  6234,  6241,
    6245,  6245,  6256,  6260,  6260
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NOELSE", "ELSE",
  "START_SYMBOL_EXPRESSION", "START_SYMBOL_BLOCKLIST",
  "START_SYMBOL_TRANSUNIT", "IDENTIFIER", "TYPE_NAME", "CONSTANT",
  "STRING_LITERAL", "PTR_OP", "INC_OP", "DEC_OP", "LEFT_OP", "RIGHT_OP",
  "LE_OP", "GE_OP", "EQ_OP", "NE_OP", "AND_OP", "OR_OP", "MUL_ASSIGN",
  "DIV_ASSIGN", "MOD_ASSIGN", "ADD_ASSIGN", "SUB_ASSIGN", "LEFT_ASSIGN",
  "RIGHT_ASSIGN", "AND_ASSIGN", "XOR_ASSIGN", "OR_ASSIGN", "SIZEOF",
  "TYPEDEF", "EXTERN", "STATIC", "AUTO", "REGISTER", "RESTRICT", "CHAR",
  "SHORT", "INT", "LONG", "SIGNED", "UNSIGNED", "FLOAT", "DOUBLE", "CONST",
  "VOLATILE", "VOID", "INLINE", "UBOOL", "UCOMPLEX", "UIMAGINARY",
  "STRUCT", "UNION", "ENUM", "ELLIPSIS", "CASE", "DEFAULT", "IF", "SWITCH",
  "WHILE", "DO", "FOR", "GOTO", "CONTINUE", "BREAK", "RETURN",
  "__BUILTIN_VA_ARG", "__BUILTIN_OFFSETOF", "__BUILTIN_TYPES_COMPATIBLE_P",
  "__ATTRIBUTE__", "__ASM__", "PRAGMA_OTHER", "PRAGMA_OMP",
  "PRAGMA_OMP_THREADPRIVATE", "OMP_PARALLEL", "OMP_SECTIONS", "OMP_NOWAIT",
  "OMP_ORDERED", "OMP_SCHEDULE", "OMP_STATIC", "OMP_DYNAMIC", "OMP_GUIDED",
  "OMP_RUNTIME", "OMP_AUTO", "OMP_SECTION", "OMP_AFFINITY", "OMP_SINGLE",
  "OMP_MASTER", "OMP_CRITICAL", "OMP_BARRIER", "OMP_ATOMIC", "OMP_FLUSH",
  "OMP_PRIVATE", "OMP_FIRSTPRIVATE", "OMP_LASTPRIVATE", "OMP_SHARED",
  "OMP_DEFAULT", "OMP_NONE", "OMP_REDUCTION", "OMP_COPYIN",
  "OMP_NUMTHREADS", "OMP_COPYPRIVATE", "OMP_FOR", "OMP_IF", "OMP_TASK",
  "OMP_UNTIED", "OMP_TASKWAIT", "OMP_COLLAPSE", "OMP_FINAL",
  "OMP_MERGEABLE", "OMP_TASKYIELD", "OMP_READ", "OMP_WRITE", "OMP_CAPTURE",
  "OMP_UPDATE", "OMP_MIN", "OMP_MAX", "OMP_PROCBIND", "OMP_CLOSE",
  "OMP_SPREAD", "OMP_SIMD", "OMP_INBRANCH", "OMP_NOTINBRANCH",
  "OMP_UNIFORM", "OMP_LINEAR", "OMP_ALIGNED", "OMP_SIMDLEN", "OMP_SAFELEN",
  "OMP_DECLARE", "OMP_TARGET", "OMP_DATA", "OMP_DEVICE", "OMP_MAP",
  "OMP_ALLOC", "OMP_TO", "OMP_FROM", "OMP_TOFROM", "OMP_END", "OMP_TEAMS",
  "OMP_DISTRIBUTE", "OMP_NUMTEAMS", "OMP_THREADLIMIT", "OMP_DISTSCHEDULE",
  "OMP_DEPEND", "OMP_IN", "OMP_OUT", "OMP_INOUT", "OMP_TASKGROUP",
  "OMP_SEQ_CST", "OMP_CANCEL", "OMP_INITIALIZER",
  "PRAGMA_OMP_CANCELLATIONPOINT", "PRAGMA_OMP_DECLARETARGET",
  "PRAGMA_OMP_ENDDECLARETARGET", "OMP_HINT", "OMP_SOURCE", "OMP_SINK",
  "OMP_RELEASE", "OMP_DELETE", "OMP_ALWAYS", "OMP_ENTER", "OMP_EXIT",
  "OMP_IS_DEVICE_PTR", "OMP_USE_DEVICE_PTR", "OMP_PRIORITY",
  "OMP_TASKLOOP", "OMP_THREADS", "OMP_LINK", "OMP_DEFAULTMAP",
  "OMP_SCALAR", "OMP_MONOTONIC", "OMP_NONMONOTONIC", "OMP_PRIMARY",
  "PRAGMA_OMPIX", "OMPIX_TASKDEF", "OMPIX_TASKSYNC", "OMPIX_UPONRETURN",
  "OMPIX_ATNODE", "OMPIX_DETACHED", "OMPIX_ATWORKER", "OMPIX_TASKSCHEDULE",
  "OMPIX_STRIDE", "OMPIX_START", "OMPIX_SCOPE", "OMPIX_NODES",
  "OMPIX_WORKERS", "OMPIX_LOCAL", "OMPIX_GLOBAL", "OMPIX_HERE",
  "OMPIX_REMOTE", "OMPIX_HINTS", "OMPIX_TIED", "OMPIX_PROCEXTERN",
  "OMPIX_TAG", "'('", "')'", "'['", "']'", "'.'", "'{'", "'}'", "','",
  "'&'", "'*'", "'+'", "'-'", "'~'", "'!'", "'/'", "'%'", "'<'", "'>'",
  "'^'", "'|'", "'?'", "':'", "'='", "';'", "'\\n'", "$accept",
  "start_trick", "enumeration_constant", "string_literal",
  "primary_expression", "postfix_expression", "argument_expression_list",
  "unary_expression", "unary_operator", "cast_expression",
  "multiplicative_expression", "additive_expression", "shift_expression",
  "relational_expression", "equality_expression", "AND_expression",
  "exclusive_OR_expression", "inclusive_OR_expression",
  "logical_AND_expression", "logical_OR_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "$@1", "storage_class_specifier", "type_specifier",
  "struct_or_union_specifier", "struct_or_union",
  "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enumerator_list", "enumerator",
  "type_qualifier", "function_specifier", "declarator",
  "direct_declarator", "pointer", "type_qualifier_list",
  "parameter_type_list", "parameter_list", "parameter_declaration",
  "identifier_list", "type_name", "abstract_declarator",
  "direct_abstract_declarator", "typedef_name", "initializer",
  "initializer_list", "designation", "designator_list", "designator",
  "statement", "statement_for_labeled", "labeled_statement",
  "compound_statement", "@2", "block_item_list", "block_item",
  "expression_statement", "selection_statement", "iteration_statement",
  "iteration_statement_for", "jump_statement", "translation_unit",
  "external_declaration", "function_definition",
  "normal_function_definition", "$@3", "$@4",
  "oldstyle_function_definition", "$@5", "$@6", "declaration_list",
  "asm_statement", "asm_stmtrest", "asm_qualifiers", "asm_qualifier",
  "asm_output", "asm_outoperand", "asm_input", "asm_inoperand",
  "asm_clobbers", "labellist", "attribute_optseq", "attribute_seq",
  "attribute", "attribute_name_list", "attribute_name", "attr_name",
  "declaration_definition", "function_statement",
  "declarations_definitions_seq", "openmp_construct", "openmp_directive",
  "structured_block", "parallel_construct", "parallel_directive",
  "parallel_clause_optseq", "parallel_clause", "unique_parallel_clause",
  "$@7", "$@8", "$@9", "for_construct", "for_directive",
  "for_clause_optseq", "for_clause", "unique_for_clause", "$@10", "$@11",
  "schedule_kind", "schedule_mod", "sections_construct",
  "sections_directive", "sections_clause_optseq", "sections_clause",
  "section_scope", "section_sequence", "section_directive",
  "single_construct", "single_directive", "single_clause_optseq",
  "single_clause", "unique_single_clause", "$@12", "simd_construct",
  "simd_directive", "simd_clause_optseq", "simd_clause",
  "unique_simd_clause", "inbranch_clause", "uniform_clause", "$@13",
  "linear_clause", "$@14", "aligned_clause", "$@15", "optional_expression",
  "declare_simd_construct", "declare_simd_directive_seq",
  "declare_simd_directive", "declare_simd_clause_optseq",
  "declare_simd_clause", "for_simd_construct", "for_simd_directive",
  "for_simd_clause_optseq", "for_simd_clause",
  "parallel_for_simd_construct", "parallel_for_simd_directive",
  "parallel_for_simd_clause_optseq", "parallel_for_simd_clause",
  "target_data_construct", "target_data_directive",
  "target_data_clause_optseq", "target_data_clause", "device_clause",
  "$@16", "map_clause", "$@17", "$@18", "map_modifier", "map_type",
  "use_device_ptr_clause", "$@19", "defaultmap_clause",
  "is_device_ptr_clause", "$@20", "target_construct", "@21",
  "target_directive", "target_clause_optseq", "target_clause",
  "unique_target_clause", "target_enter_data_directive",
  "target_enter_data_clause_seq", "target_enter_data_clause",
  "target_exit_data_directive", "target_exit_data_clause_seq",
  "target_exit_data_clause", "target_update_directive",
  "target_update_clause_seq", "target_update_clause", "motion_clause",
  "$@22", "$@23", "declare_target_construct", "declare_target_directive",
  "end_declare_target_directive", "declare_target_directive_v45",
  "declare_target_clause_optseq", "unique_declare_target_clause", "$@24",
  "$@25", "teams_construct", "teams_directive", "teams_clause_optseq",
  "teams_clause", "unique_teams_clause", "$@26", "$@27", "numteamsopt",
  "distribute_construct", "distribute_directive",
  "distribute_clause_optseq", "distribute_clause",
  "unique_distribute_clause", "$@28", "distribute_simd_construct",
  "distribute_simd_directive", "distribute_simd_clause_optseq",
  "distribute_simd_clause", "distribute_parallel_for_construct",
  "distribute_parallel_for_directive",
  "distribute_parallel_for_clause_optseq",
  "distribute_parallel_for_clause",
  "distribute_parallel_for_simd_construct",
  "distribute_parallel_for_simd_directive",
  "distribute_parallel_for_simd_clause_optseq",
  "distribute_parallel_for_simd_clause", "target_teams_construct",
  "target_teams_directive", "target_teams_clause_optseq",
  "target_teams_clause", "target_parallel_construct",
  "target_parallel_directive", "target_parallel_clause_optseq",
  "target_parallel_clause", "teams_distribute_construct",
  "teams_distribute_directive", "teams_distribute_clause_optseq",
  "teams_distribute_clause", "teams_distribute_simd_construct",
  "teams_distribute_simd_directive", "teams_distribute_simd_clause_optseq",
  "teams_distribute_simd_clause", "target_teams_distribute_construct",
  "target_teams_distribute_directive",
  "target_teams_distribute_clause_optseq",
  "target_teams_distribute_clause",
  "target_teams_distribute_simd_construct",
  "target_teams_distribute_simd_directive",
  "target_teams_distribute_simd_clause_optseq",
  "target_teams_distribute_simd_clause",
  "teams_distribute_parallel_for_construct",
  "teams_distribute_parallel_for_directive",
  "teams_distribute_parallel_for_clause_optseq",
  "teams_distribute_parallel_for_clause",
  "target_teams_distribute_parallel_for_construct",
  "target_teams_distribute_parallel_for_directive",
  "target_teams_distribute_parallel_for_clause_optseq",
  "target_teams_distribute_parallel_for_clause",
  "teams_distribute_parallel_for_simd_construct",
  "teams_distribute_parallel_for_simd_directive",
  "teams_distribute_parallel_for_simd_clause_optseq",
  "teams_distribute_parallel_for_simd_clause",
  "target_teams_distribute_parallel_for_simd_construct",
  "target_teams_distribute_parallel_for_simd_directive",
  "target_teams_distribute_parallel_for_simd_clause_optseq",
  "target_teams_distribute_parallel_for_simd_clause",
  "target_parallel_for_construct", "target_parallel_for_directive",
  "target_parallel_for_clause_optseq", "target_parallel_for_clause",
  "task_construct", "task_directive", "task_clause_optseq", "task_clause",
  "unique_task_clause", "$@29", "depend_clause", "$@30", "dependence_type",
  "parallel_for_construct", "parallel_for_directive",
  "parallel_for_clause_optseq", "parallel_for_clause",
  "parallel_sections_construct", "parallel_sections_directive",
  "parallel_sections_clause_optseq", "parallel_sections_clause",
  "master_construct", "master_directive", "critical_construct",
  "critical_directive", "region_phrase", "hint_clause",
  "barrier_directive", "taskwait_directive", "taskgroup_construct",
  "taskgroup_directive", "taskyield_directive", "atomic_construct",
  "atomic_directive", "atomic_clause_opt", "seq_cst_clause_opt",
  "flush_directive", "flush_vars", "$@31", "ordered_construct",
  "ordered_directive_full", "ordered_directive_standalone",
  "ordered_clause_optseq_full", "ordered_clause_type_full",
  "ordered_clause_optseq_standalone", "ordered_clause_depend_sink",
  "sink_vec", "sink_vec_elem", "cancel_directive", "construct_type_clause",
  "cancellation_point_directive", "threadprivate_directive", "$@32",
  "$@33", "declare_reduction_directive", "$@34", "$@35",
  "reduction_identifier", "reduction_type_list", "initializer_clause_opt",
  "data_default_clause", "data_privatization_clause", "$@36",
  "data_privatization_in_clause", "$@37", "data_privatization_out_clause",
  "$@38", "data_sharing_clause", "$@39", "data_reduction_clause", "$@40",
  "if_clause", "$@41", "$@42", "if_related_construct", "collapse_clause",
  "variable_list", "variable_array_section_list", "varid_or_array_section",
  "funcname_variable_array_section_list", "funcvarid_or_array_section",
  "array_section_slice_list", "$@43", "$@44", "array_section_slice",
  "procbind_clause", "thrprv_variable_list", "ompix_directive",
  "ox_tasksync_directive", "ox_taskschedule_directive", "$@45",
  "ox_taskschedule_clause_optseq", "ox_taskschedule_clause",
  "ox_scope_spec", "ompix_construct", "ox_taskdef_construct", "$@46",
  "ox_taskdef_directive", "$@47", "ox_taskdef_clause_optseq",
  "ox_taskdef_clause", "ox_variable_size_list", "ox_variable_size_elem",
  "ox_task_construct", "ox_task_directive", "ox_task_clause_optseq",
  "ox_task_clause", "ox_procextern_construct", "ox_procextern_directive",
  "$@48", "$@49", "extern_variable_list", "ox_tag_construct",
  "ox_tag_directive", "ox_tag_clause", "$@50", "tag_clause", "$@51", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,    40,    41,
      91,    93,    46,   123,   125,    44,    38,    42,    43,    45,
     126,    33,    47,    37,    60,    62,    94,   124,    63,    58,
      61,    59,    10
};
# endif

#define YYPACT_NINF -1361

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-1361)))

#define YYTABLE_NINF -949

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    3003,  2911,  1639,  3177, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,    11,
    -107, -1361,   -16, -1361,   324,   255,   138,    23,   136, -1361,
      85,  5146,  5146, -1361,    11, -1361,  5146,  5146,    -4,   528,
     146, -1361,  3177, -1361, -1361, -1361, -1361, -1361, -1361,  3476,
   -1361, -1361,  3353, -1361, -1361, -1361, -1361,  3527, -1361, -1361,
     173, -1361, -1361,  2918,  2918,  2932,   203,   222,   245,  2202,
   -1361, -1361, -1361, -1361, -1361, -1361,   454, -1361,   469,   482,
    2911, -1361,   347,   687,   825,   210,  1007,   280,   282,   302,
     518,    63, -1361, -1361,   337,   -78,  2911,   366,   416,   437,
     467,  1830,   495,   689,   479,   508,  1108,   404, -1361,  3055,
     737,   726,   541, -1361,   209, -1361,    85, -1361, -1361, -1361,
    1639, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361,  1830, -1361,   721, -1361,   600, -1361,  1830, -1361,   721,
   -1361,   721, -1361,   721, -1361,  1830, -1361, -1361, -1361, -1361,
   -1361, -1361,  1830, -1361,   721, -1361,   721, -1361,   721, -1361,
    1830, -1361,  1830, -1361,  1830, -1361,   721, -1361,   721, -1361,
     721, -1361,   721, -1361,   721, -1361,   721, -1361,   721, -1361,
     721, -1361,   721, -1361,  1830, -1361,   721, -1361,   600, -1361,
    1830, -1361,  1830, -1361, -1361, -1361,  1830, -1361, -1361,  1591,
   -1361, -1361,  1830, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361,   799, -1361, -1361,    13,  3177,   151,    11, -1361,
     613,     2,   616, -1361, -1361,   810, -1361,   326, -1361, -1361,
   -1361,   634, -1361, -1361,    23, -1361, -1361,   253, -1361,   417,
   -1361, -1361,   162, -1361, -1361,   642,  3822,  3701,  2252,   528,
   -1361,   724,   138, -1361, -1361, -1361, -1361, -1361, -1361,  3229,
     138, -1361,   650,  2911,  2202, -1361, -1361,  2202, -1361,  2911,
    3425,  3425,   387,  3425,   492,  3425,   664, -1361,  1128, -1361,
   -1361,  2911,  2911,  1212, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361,  2911, -1361, -1361,  2911,  2911,
    2911,  2911,  2911,  2911,  2911,  2911,  2911,  2911,  2911,  2911,
    2911,  2911,  2911,  2911,  2911,  2911,  2911,  2911,    11, -1361,
     646,  1759,  2911,  2911,  2911,  4970,   297,   805,  1709,   649,
   -1361, -1361, -1361,   258, -1361, -1361,   682,   861, -1361,   404,
   -1361,    33, -1361,   735, -1361,   665,   -97,   698,  1410,   224,
     806, -1361,   712,   740, -1361,   938,   800,    49,   768,   737,
   -1361, -1361, -1361, -1361,   776, -1361,   785, -1361,   759,   793,
   -1361,  1639, -1361,   823, -1361, -1361, -1361, -1361,  1927, -1361,
   -1361, -1361, -1361, -1361, -1361,  1830, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
     857, -1361, -1361,   854,  1052,   862, -1361,   766,   871, -1361,
    1081,   893,   898,   905,   411, -1361,    53, -1361, -1361, -1361,
     900, -1361, -1361, -1361,   138, -1361, -1361,   642,  3822,   929,
    1318,   939, -1361, -1361,  3650, -1361, -1361,   221,   909,   935,
   -1361,   451,  2296, -1361,   951,   954,  2269,  1038,   963,   979,
   -1361, -1361, -1361,   642,   563, -1361,  1000,  1014,   971,  1023,
    1027, -1361, -1361,  3577,  2438,   625, -1361,   632, -1361,  2524,
   -1361, -1361,   623,   406, -1361, -1361, -1361, -1361, -1361, -1361,
     347,   347,   687,   687,   825,   825,   825,   825,   210,   210,
    1007,   280,   282,   302,   518,   -62, -1361,  1830,  1759,  4976,
   -1361, -1361, -1361,   659,   674,   684,    24,  1037,  1945,   264,
    1998, -1361, -1361,   861,    75, -1361, -1361, -1361,  1121,  1188,
     997,  1050,   393,   429, -1361,   351, -1361,  1251, -1361,   -77,
   -1361, -1361, -1361, -1361, -1361,  1111, -1361, -1361,  1088, -1361,
    1032,  2121, -1361, -1361,  1224,  1183,  1058, -1361,  1157,  1169,
    1191,  2764,    51,   815,  1215, -1361,   895, -1361,   -27, -1361,
     679, -1361, -1361,   861, -1361,  1430,  4099, -1361,    22,  1830,
   -1361,  2911,  1052, -1361,  1103,  1076, -1361,  1052, -1361, -1361,
   -1361,   742, -1361,  1130,  1062,  1424, -1361,   749,   810,  1328,
   -1361,  1149,  1147,   810, -1361,   644,  1379, -1361,  2597, -1361,
    3650,  3425, -1361,  3058, -1361,   175,  3425, -1361, -1361,  3403,
   -1361,   177, -1361, -1361,  5096, -1361,  1394,  1208,  2296, -1361,
   -1361,  2911, -1361,  1210,  1252, -1361, -1361, -1361,  2911,  1211,
    1211,  3425,  1423,  3425, -1361,  1257,  1289, -1361,  1307,  1311,
     632,  3773,  2618,  2362, -1361, -1361, -1361,  2911, -1361, -1361,
    1830,  1830,  1830,  2911,  2642,   267,  2016,  2666,   311,    47,
   -1361,    35,  2479, -1361,  4330, -1361, -1361, -1361, -1361,  1249,
    1316, -1361,  1320,  1331,  1338,  2077, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1129, -1361,
   -1361, -1361, -1361, -1361, -1361,  1173, -1361, -1361,    18, -1361,
   -1361,  1342,  1400, -1361, -1361, -1361, -1361,   330, -1361, -1361,
   -1361, -1361, -1361,  1362,  1366, -1361,  1341, -1361,  1343,  1562,
   -1361,  1326, -1361,  1374,  1383,  1389,  1390,    26, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1391, -1361,
    1392,  1393,  1775, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361,  1396,  2061, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361,  4050, -1361,  1397,
   -1361, -1361, -1361,   604, -1361, -1361, -1361, -1361,   408,   321,
    4118,   875,   917, -1361,  1398,  1405,  1412,  2300, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1507,
   -1361,  1956,  1418,  1421,  1197, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361,  1496,  1413,  1427,   566, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361,  1514, -1361,  1401,  1428, -1361,  1429,
    1432, -1361,  1444, -1361,   977, -1361, -1361,  1230,   186, -1361,
    1433,  1534, -1361,  1830, -1361,   751,  1143,  2911, -1361,   105,
    1192,  1446,   766,  2911, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361,  1435, -1361, -1361, -1361,  1445,
    1449, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1648,   767,
     905,   772, -1361,  1598, -1361, -1361, -1361,  1459,  1460,  1461,
    1462,   476, -1361, -1361, -1361,   781,  2362, -1361, -1361, -1361,
    3282, -1361, -1361,  2911, -1361,   329, -1361,  1447,  3599, -1361,
   -1361, -1361, -1361,  1463,  1464, -1361, -1361, -1361,  1468,  1472,
    1498, -1361, -1361, -1361, -1361, -1361,  1522, -1361,  1523,  1524,
    2911,  1425, -1361,  1245,  2597,   364, -1361, -1361,  1726, -1361,
   -1361,   782,  1830,   795,  2683,  2707,   367,  1830,   796,  2750,
    1512,  1725,   163,   455, -1361,  2689, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361,  1978,  4788, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1536,
    1537,  1538,  1539,   607,  1062,  1540, -1361,   562,   630, -1361,
    1541, -1361,  1569,  1521, -1361,  1611, -1361,  1579, -1361, -1361,
    2911, -1361, -1361, -1361,   804,  2670, -1361, -1361, -1361, -1361,
    2911,   317,  2911,   861, -1361, -1361,  1310,  2911, -1361,  1580,
    1585,  2911, -1361,  3938, -1361,  4861, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1586,  1589,
    1058, -1361, -1361,  1590,    27, -1361, -1361, -1361, -1361, -1361,
   -1361,  1684, -1361,  4065, -1361,  4870, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361,   331, -1361, -1361, -1361, -1361,
   -1361, -1361,   578, -1361, -1361, -1361,   211, -1361,  1651, -1361,
    1669,  4366,  1630, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361,  4302,  1486, -1361, -1361, -1361, -1361, -1361,
    1720, -1361,  1588, -1361,  2911,  2911,  2411,  2911, -1361, -1361,
    1613,  1615,  1616, -1361,   -55, -1361, -1361, -1361,  1610, -1361,
   -1361,  1618, -1361,   142, -1361, -1361, -1361, -1361,   144, -1361,
   -1361,   809,  3795,  1634,  2911, -1361,  1614, -1361, -1361,  1149,
   -1361,  1328,  2911,   285,  1650,  1598,  1062,  1844,  1844,  1844,
   -1361, -1361,  1845,  1312, -1361, -1361,    82, -1361,  2911, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1653, -1361,
   -1361, -1361,  2320, -1361, -1361, -1361,  1830,  1635, -1361,  1830,
    1830,   813,  1830,   829,  2825, -1361,  1830,  1830,   840,   140,
    1654,  2918, -1361,    35,   140, -1361,  4685, -1361, -1361, -1361,
   -1361, -1361,  1562,  1562,  1562,  1562,  1658,  1659,  1660, -1361,
    1562,  2911, -1361, -1361, -1361,   569, -1361,  2911,  1642,  1663,
    1665,  1667,  1668,  1562,  1646,  1861,  1562,   869, -1361,  1862,
   -1361,   874,  1671,  1661,  1662,   841,   902,   187,  2911, -1361,
   -1361, -1361, -1361,   921,  1562,  1562,   926, -1361,  4557, -1361,
   -1361, -1361, -1361, -1361, -1361,  2911,  1328,  1328, -1361, -1361,
   -1361,  1749,  3970, -1361,  4893, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361,   875, -1361, -1361,   917, -1361, -1361,  1672,  1328,
    1009,  1562,  1664, -1361,  4270,  5162, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361,  2911,  2911,  4234,  4752, -1361, -1361, -1361,
   -1361, -1361,   928, -1361,   945,   952,  1679,  1680,  1686,  1687,
    1704,  2911,  2911,  1350, -1361,  1900, -1361, -1361, -1361, -1361,
   -1361,   377,  1562,   970, -1361, -1361,   337,  2911, -1361,  1708,
    1691,  1711,   978, -1361,   985,   986,  1690, -1361, -1361,  2344,
   -1361, -1361, -1361, -1361, -1361,  2597, -1361, -1361, -1361, -1361,
    1830, -1361,  1830,  1830,   990, -1361, -1361,  1830,  1905,   171,
     400, -1361,   861,  1729, -1361,   734, -1361,  1017,  1018,  1019,
    1041, -1361, -1361, -1361,  1706,  1048,  1056, -1361, -1361,  1795,
    1797,  1059, -1361, -1361, -1361, -1361, -1361,  1067, -1361,  1337,
    1733,  1728,  1068, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361,  1077, -1361, -1361,  1734,  1078,
    1715, -1361,   424,   424, -1361, -1361,  1099,  1102,  1106,  1562,
   -1361,  3886, -1361,  4809, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361,  1125, -1361, -1361, -1361, -1361, -1361, -1361,
    1723,  1135,  1771,  4198,  4721, -1361, -1361, -1361, -1361, -1361,
     519,  1138,  4649, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361,  1746,  1748, -1361,
    1743,  1750,  1751,  3795, -1361,  1145, -1361,   337, -1361,  1844,
    1913, -1361,  1844, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361,  1830, -1361,  1753,  2911,   140,   861,   182, -1361, -1361,
     861, -1361, -1361, -1361, -1361,  1328, -1361, -1361, -1361, -1361,
   -1361,  2911, -1361,  2911,  2911, -1361,  1861, -1361,  2911, -1361,
   -1361,  1943, -1361,  1328,  2911,  1762,  1764, -1361, -1361, -1361,
    1146,  3805, -1361,  4505, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361,  1765,  4613, -1361, -1361, -1361, -1361, -1361,
    2911,  1772, -1361, -1361,  2911, -1361, -1361,  1365, -1361, -1361,
   -1361,  2911, -1361,  1177,  1944,  1773, -1361, -1361,   861,  1184,
   -1361,   454,   522,  2918,  1185,  1187,  1189,   347,   347, -1361,
    1196,  2911,  1774,  1199,   337, -1361, -1361, -1361, -1361,  4434,
   -1361, -1361, -1361, -1361, -1361, -1361,  1328, -1361, -1361,   337,
   -1361,  1200, -1361, -1361,  1213, -1361,  1776, -1361,   199, -1361,
     861,  1964,  1777, -1361, -1361, -1361, -1361,  1222, -1361, -1361,
   -1361,  1227, -1361, -1361, -1361,  2911,   454, -1361,  1231, -1361,
   -1361, -1361,  1821,  1243, -1361,  1971,  1783,  1760, -1361, -1361,
    1992, -1361,   -34,  2911,  2911,  1246,  1805,  1806, -1361, -1361
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,     0,     0,   170,   215,   110,   111,   112,   113,
     114,   164,   116,   117,   118,   119,   122,   123,   120,   121,
     163,   165,   115,   167,   124,   125,   126,   136,   137,   322,
       0,   284,     0,   853,     0,     0,     0,   184,     0,   281,
       0,    97,    99,   127,   322,   128,   101,   103,   293,   168,
       0,   129,     2,   278,   280,   285,   286,   166,    94,     0,
     482,    95,     0,   584,    93,    96,   282,     0,   283,   980,
       9,    10,     7,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    11,    13,    28,    43,
       0,    45,    49,    52,    55,    60,    63,    65,    67,    69,
      71,    73,    75,    88,     3,     9,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   238,     0,
       0,     0,   245,   253,     0,   249,     0,   250,   229,   230,
       4,   247,   231,   232,   233,   260,   234,   235,   236,   251,
     340,     0,   341,     0,   342,     0,   343,     0,   351,     0,
     352,     0,   353,     0,   354,     0,   355,   536,   380,   381,
     379,   356,     0,   357,     0,   358,     0,   359,     0,   360,
       0,   361,     0,   362,     0,   364,     0,   365,     0,   366,
       0,   367,     0,   368,     0,   369,     0,   370,     0,   371,
       0,   363,     0,   350,     0,   344,     0,   345,     0,   346,
       0,   347,     0,   373,   375,   372,     0,   376,   348,     0,
     374,   349,     0,   827,   377,   378,   252,   927,   928,   237,
     944,   945,     0,   946,   947,     0,     5,     0,   323,   324,
       0,     0,     0,   592,   594,     0,   585,     0,   589,   951,
     981,     0,   188,   186,   185,     1,    91,     0,   105,   291,
      98,   100,     0,   102,   104,     0,     0,     0,     0,   169,
     279,     0,     0,   337,   481,   483,   336,   335,   338,     0,
       0,   289,   950,    25,     0,    29,    30,     0,    32,     0,
       0,     0,     0,   142,   199,   144,     0,     8,     0,    21,
      22,    25,     0,     0,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    77,     0,    43,    31,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   322,    90,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   276,     0,   306,   307,     0,     0,   297,     0,
     304,   385,   433,   831,   448,     0,     0,     0,   815,     0,
     404,   753,     0,     0,   459,   539,   598,   615,     0,     0,
     848,   849,   850,   851,     0,   967,     0,   930,     0,     0,
     244,     0,   254,   107,   248,   382,   383,   402,     0,   431,
     446,   457,   493,   500,   507,     0,   596,   613,   626,   634,
     641,   648,   658,   673,   682,   691,   701,   710,   717,   726,
     733,   742,   751,   773,   787,   800,   802,   810,   813,   826,
       0,   986,   987,   157,     0,   158,   325,   329,     0,   485,
       0,     0,     0,   910,     0,   908,     0,   588,   590,   953,
       0,   171,   189,   187,     0,    92,   108,     0,     0,   134,
       0,   135,   290,   295,     0,   197,   182,   195,     0,   190,
     192,     0,     0,   172,    38,     0,     0,     0,   291,     0,
     339,   583,   287,     0,     0,    26,     0,     0,     0,     0,
       0,    12,   143,     0,     0,   201,   200,   202,   145,     0,
      18,    20,     0,     0,    17,    19,    76,    46,    47,    48,
      50,    51,    53,    54,    58,    59,    56,    57,    61,    62,
      64,    66,    68,    70,    72,     0,    89,     0,     0,     0,
     239,   243,   240,     0,     0,     0,   539,     0,     0,     0,
       0,   273,   277,     0,     0,   298,   305,   789,   775,     0,
       0,     0,     0,     0,   836,     0,   801,     0,   803,     0,
     808,   816,   817,   819,   818,   820,   824,   822,     0,   495,
       0,     0,   809,   812,     0,   660,     0,   509,   650,     0,
       0,     0,   675,     0,     0,   628,     0,   811,     0,   852,
       0,   929,   932,     0,   988,     0,     0,   442,     0,     0,
     537,    25,     0,     6,   161,     0,   159,     0,   332,   333,
     334,     0,   327,   330,     0,     0,   925,     0,     0,     0,
     914,   911,     0,     0,   591,     0,     0,   106,     0,   288,
       0,     0,   131,     0,   138,     0,     0,   296,   294,     0,
     194,   201,   196,   181,     0,   183,     0,     0,     0,   179,
     174,     0,   173,    38,     0,   586,   949,    15,     0,     0,
      33,     0,     0,     0,   211,     0,     0,   205,    38,     0,
     203,     0,     0,     0,    44,    16,    14,     0,   241,   242,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     299,   308,     0,   502,     0,   400,   878,   880,   884,     0,
       0,   397,     0,     0,     0,     0,   384,   386,   388,   390,
     391,   392,   393,   394,   389,   399,   440,   882,     0,   432,
     434,   436,   437,   438,   439,     0,   835,   834,     0,   828,
     832,     0,     0,   830,   837,   454,   455,     0,   447,   449,
     451,   452,   453,     0,     0,   804,     0,   821,     0,     0,
     823,     0,   412,   413,     0,     0,     0,     0,   403,   405,
     407,   408,   409,   410,   411,   420,   421,   765,     0,   766,
       0,     0,     0,   752,   754,   756,   762,   758,   759,   760,
     761,   757,   475,   477,     0,     0,   458,   460,   462,   469,
     470,   464,   465,   466,   463,   467,   744,     0,   578,     0,
     579,   581,   575,     0,   571,   574,   577,   576,     0,   693,
       0,     0,     0,   545,     0,     0,     0,     0,   538,   548,
     549,   550,   551,   540,   542,   544,   546,   547,   543,     0,
     684,     0,     0,     0,     0,   597,   599,   601,   602,   603,
     604,   605,   606,   636,     0,     0,     0,   614,   616,   622,
     618,   619,   620,   621,     0,   845,     0,     0,   976,     0,
       0,   977,     0,   975,     0,   966,   968,     0,   990,   246,
       0,     0,   441,     0,   443,     0,     0,     0,   151,     0,
       0,     0,   329,    25,   859,   866,   867,   868,   869,   863,
     861,   860,   862,   864,   865,     0,   471,   472,   473,     0,
       0,   484,   492,   491,   489,   490,   486,   854,     0,     0,
     906,     0,   904,     0,   912,   587,   909,     0,     0,     0,
       0,     0,   952,   954,   984,     0,     0,   216,   109,   292,
       0,   130,   139,     0,   141,     0,   146,   148,     0,   191,
     193,   198,   176,     0,     0,   180,   175,    27,     0,     0,
       0,   213,   204,   209,   207,   212,     0,   206,    38,     0,
       0,     0,   219,     0,     0,     0,   224,    74,   255,   257,
     258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   309,     0,   788,   792,   790,   794,
     795,   796,   797,   798,   799,   793,     0,     0,   774,   778,
     779,   776,   781,   782,   783,   784,   785,   786,   780,     0,
       0,     0,     0,     0,     0,     0,   395,   888,     0,   387,
       0,   435,     0,     0,   833,     0,   838,     0,   450,   806,
       0,   805,   814,   902,     0,     0,   494,   498,   499,   496,
       0,   428,     0,     0,   406,   763,     0,     0,   755,     0,
       0,     0,   461,     0,   672,     0,   659,   663,   664,   661,
     671,   666,   667,   668,   669,   670,   665,   516,     0,     0,
       0,   570,   572,     0,     0,   508,   510,   512,   513,   515,
     514,     0,   703,     0,   657,     0,   649,   654,   653,   651,
     656,   655,   560,   557,   556,     0,   553,   559,   558,   569,
     566,   565,     0,   562,   568,   567,   522,   534,     0,   541,
     712,     0,     0,   674,   678,   681,   676,   679,   680,   607,
     609,   600,   643,     0,     0,   627,   632,   631,   629,   633,
       0,   617,     0,   846,     0,     0,     0,     0,   969,   939,
       0,     0,     0,   938,     0,   931,   933,   989,     0,   445,
     444,     0,   152,     0,   162,   154,   160,   153,     0,   326,
     328,     0,     0,     0,     0,   487,     0,   926,   593,   907,
     595,     0,   920,   918,     0,     0,     0,     0,     0,     0,
     955,   982,     0,     0,   132,   150,     0,   140,     0,   133,
     177,   178,    34,    35,    36,   214,   210,   208,     0,   227,
     228,    23,     0,   220,   223,   225,     0,     0,   261,     0,
       0,     0,     0,     0,     0,   269,     0,     0,     0,   313,
       0,     0,   300,     0,   313,   791,     0,   501,   506,   503,
     505,   777,     0,     0,     0,     0,     0,     0,     0,   886,
       0,     0,   892,   893,   900,   894,   899,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   825,     0,
     497,     0,     0,     0,     0,     0,     0,   993,     0,   770,
     771,   772,   768,     0,     0,     0,     0,   750,     0,   743,
     747,   745,   749,   748,   662,     0,     0,     0,   573,   531,
     511,   719,     0,   700,     0,   692,   697,   696,   694,   699,
     698,   652,     0,   552,   554,     0,   561,   563,   523,     0,
       0,     0,     0,   728,     0,     0,   683,   687,   690,   685,
     688,   689,   677,     0,     0,     0,     0,   635,   639,   637,
     640,   630,     0,   847,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,   934,     0,   965,   155,   156,   331,
     870,     0,     0,     0,   855,   905,   919,   917,   915,     0,
       0,   962,     0,   960,     0,     0,     0,   985,   217,     0,
     147,   149,   226,    24,   221,     0,   256,   259,   264,   263,
       0,   262,     0,     0,     0,   271,   270,     0,     0,     0,
       0,   314,     0,     0,   310,     0,   504,     0,     0,     0,
       0,   877,   875,   876,     0,     0,     0,   898,   895,     0,
       0,     0,   890,   921,   923,   924,   922,     0,   829,   842,
       0,   840,     0,   807,   903,   414,   418,   429,   430,   427,
     422,   423,   424,   425,   426,     0,   901,   992,     0,     0,
       0,   767,   479,   479,   468,   746,     0,     0,     0,     0,
     735,     0,   709,     0,   702,   707,   706,   704,   708,   695,
     555,   564,   524,     0,   525,   526,   527,   528,   529,   530,
       0,     0,     0,     0,     0,   711,   715,   716,   713,   686,
     611,     0,     0,   642,   647,   646,   644,   638,   623,   624,
     979,   978,   972,   973,   970,   971,   974,     0,     0,   940,
     941,     0,     0,     0,   856,     0,   488,   916,   913,     0,
       0,   956,     0,   957,   958,   983,   218,   222,   267,   266,
     265,     0,   272,     0,     0,     0,     0,     0,   312,   301,
       0,   401,   879,   881,   885,     0,   398,   396,   896,   897,
     889,     0,   883,     0,     0,   839,     0,   456,     0,   415,
     416,     0,   764,     0,     0,     0,     0,   517,   580,   582,
       0,     0,   725,     0,   718,   722,   723,   720,   724,   705,
     521,   518,   535,     0,     0,   727,   731,   732,   729,   714,
       0,     0,   610,   645,     0,   935,   936,     0,   937,   991,
     871,     0,   474,     0,     0,     0,   961,   268,     0,     0,
     315,   318,     0,     0,     0,     0,     0,   843,   844,   841,
       0,     0,     0,     0,   480,   476,   478,   532,   741,     0,
     734,   738,   739,   736,   740,   721,     0,   533,   730,   612,
     608,     0,   943,   942,     0,   959,     0,   964,     0,   317,
       0,     0,     0,   302,   887,   891,   419,     0,   994,   769,
     737,     0,   625,   857,   963,     0,   319,   320,     0,   311,
     417,   519,   872,     0,   303,     0,     0,     0,   316,   321,
       0,   858,     0,    25,     0,     0,     0,     0,   873,   874
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1361, -1361, -1361,  -328, -1361, -1361,  -284,   -72, -1361,   -50,
    -300,  1244,  1217,  1248,  1689,  1692,  1695,  1696,  1688, -1361,
    -102,  -250, -1361,    -1,  -840,   103,   937, -1361,  1575, -1361,
   -1361,   -74, -1361, -1361,   110,  -606,  -150, -1361,   845, -1361,
     174,  -781,   323, -1361,    -8,   -41,    20,  -197,  -243, -1361,
    1388, -1361,  -244,   -64,  -409,  -214,  -598,  1107, -1075, -1361,
    1070,     8,  1516, -1361,  -186, -1361,  1666,  -124,  1823, -1361,
   -1361,  5061, -1361,  2032,   166,    52,  1975, -1361, -1361, -1361,
   -1361, -1361,  1595, -1361,  1697, -1361,  1699, -1361,   831,   836,
     530,   536, -1361,   -18, -1361,   -13, -1361,  1190, -1361,  1788,
   -1361, -1361,  1836,  -118,   697, -1361, -1361, -1361,  1368,  -515,
   -1361, -1361, -1361, -1361, -1361, -1361,  -343,  -545, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361,  1356,  1868, -1361,  1483, -1361,
   -1361, -1361,  1345, -1361, -1361, -1361, -1361, -1361,  1298,  -470,
   -1361, -1361, -1361,  -563, -1361,  -561, -1361,   651, -1361, -1361,
    2020, -1361,  1193, -1361, -1361, -1361,  1065, -1361, -1361, -1361,
    -939, -1361, -1361, -1361,  1028,  -523, -1361,  -734, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361,  1284,  -586, -1361, -1361, -1036, -1361, -1361, -1032, -1361,
   -1361,  -748, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
    -167, -1361, -1361, -1361, -1361, -1361,  -538,  -353, -1361, -1361,
   -1361, -1361, -1361, -1361,  -528,  -397, -1361, -1361, -1361, -1361,
    -795, -1361, -1361, -1361, -1031, -1361, -1361, -1361, -1240, -1361,
   -1361, -1361,  1020, -1361, -1361, -1361,  1049, -1361, -1361, -1361,
    -768, -1361, -1361, -1361, -1038, -1361, -1361, -1361,   812, -1361,
   -1361, -1361,   654, -1361, -1361, -1361,  -962, -1361, -1361, -1361,
     540, -1361, -1361, -1361, -1360, -1361, -1361, -1361,   489, -1361,
   -1361, -1361,   835, -1361, -1361, -1361,  1346, -1361, -1361,  -505,
   -1361, -1361, -1361, -1361, -1361,  -659, -1361, -1361, -1361,  1137,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361, -1361,  1387, -1361,  -491,   574, -1361, -1361,  1744, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361,  -779, -1361, -1361,   263,
    -392, -1361,  -384, -1361,    72, -1361,  -474, -1361,   -40, -1361,
     -43, -1361, -1361, -1361,  -455,  -426, -1226,   953,  1508,  1502,
    1218, -1361, -1361,   961, -1361, -1361, -1361, -1361, -1361, -1361,
   -1361,   983, -1361,  1902,    92, -1361, -1361, -1361, -1361,  1221,
   -1147,   626, -1361, -1361, -1361,  1275,    97, -1361, -1361, -1361,
   -1361, -1361, -1361, -1361, -1361, -1361, -1361
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    38,   594,    86,    87,    88,   474,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   305,   124,   330,    39,   126,   247,   248,   618,
      41,    42,    43,    44,   623,   624,   284,   925,   926,    45,
     595,   596,    46,    47,    48,    49,    50,   244,   655,   459,
     460,   461,   286,   656,   487,    51,   952,   953,   954,   955,
     956,   385,   521,   128,   129,   381,   130,   131,   132,   133,
     134,   135,   136,    52,    53,    54,    55,   447,   255,    56,
     448,   256,   454,   137,   348,   349,   350,   973,   974,  1380,
    1381,  1592,  1648,   227,   228,    57,   601,   602,   603,   268,
     264,   269,   138,   139,   386,   140,   141,   539,   697,   989,
    1231,  1005,   999,   142,   143,   560,  1027,   990,  1601,  1538,
    1425,  1255,   144,   145,   540,   710,   389,   588,   589,   146,
     147,   545,   729,   730,  1017,   148,   149,   564,   777,  1218,
     892,   893,  1153,   779,  1039,   780,  1040,  1545,    58,    59,
      60,   605,   896,   150,   151,   741,  1029,   152,   153,   986,
    1474,   154,   155,   798,  1066,   809,  1275,   810,  1616,  1299,
    1300,  1460,  1069,  1439,   811,   812,  1301,   156,   395,   157,
     571,   813,   814,   158,  1085,  1086,   159,  1092,  1093,   160,
     793,   794,   795,  1058,  1059,    61,    62,   471,    63,   237,
     238,   431,   432,   161,   162,   573,  1078,   827,  1313,  1314,
    1571,   163,   164,   576,  1117,   839,  1574,   165,   166,   834,
    1308,   167,   168,  1113,  1467,   169,   170,  1315,  1567,   171,
     172,   800,  1079,   173,   174,   787,  1049,   175,   176,   821,
    1287,   177,   178,  1101,  1446,   179,   180,  1073,  1288,   181,
     182,  1282,  1447,   183,   184,  1304,  1556,   185,   186,  1441,
    1557,   187,   188,  1463,  1612,   189,   190,  1551,  1613,   191,
     192,  1043,  1271,   193,   194,   561,   764,   765,  1258,   796,
    1430,  1262,   195,   196,   684,  1220,   197,   198,   682,   978,
     199,   200,   201,   202,   549,   736,   203,   204,   205,   206,
     207,   208,   209,   555,   738,   210,   558,   739,   211,   212,
     213,   542,   720,   543,   544,  1410,  1411,   214,   374,   215,
      64,   232,  1156,    65,  1581,  1652,   885,  1341,  1657,   992,
     993,  1000,   994,  1001,   995,  1010,   996,  1002,   997,  1394,
     998,  1237,  1531,  1238,   755,  1024,   901,   902,   434,   435,
     611,  1165,   903,  1164,   705,   607,   216,   217,   218,   582,
     857,  1136,  1491,   219,   220,   473,    67,   439,   615,   913,
    1352,  1353,   221,   222,   580,   856,   223,    69,   440,  1356,
     915,   224,   225,   379,  1138,   756,  1428
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     104,   275,   276,   278,   329,   283,   384,   492,   465,   259,
     127,   500,   501,   425,   458,   750,   229,   922,   306,   534,
     918,  1354,  1355,   475,   698,   991,   252,  1144,   241,   478,
     476,   229,   249,   477,   306,   826,   479,   480,   451,  1118,
     307,   475,   894,   792,   895,  1062,    72,  1219,   838,  1294,
    1437,  1438,   724,  1106,  1129,   496,   766,   243,   287,   271,
    1297,   466,    11,  1309,  1068,   702,   815,  1084,  1091,   452,
     438,    20,    21,  1453,   491,  1476,   660,   516,   282,   495,
     693,   734,  1319,  1175,    30,   325,   287,   770,  1146,   335,
       4,   230,    66,     4,   778,    66,    30,    68,   861,   831,
      68,   547,   565,  1568,   428,   125,   742,   743,   744,   785,
    1188,   263,   537,   593,   267,   343,   231,  1365,   383,   337,
     273,   843,   686,   687,   707,   548,   429,   574,   690,   819,
    1130,  1131,  1132,   482,   693,   488,   245,   745,   127,   538,
    1133,   328,   716,   327,    66,   735,     4,   700,   711,    68,
     593,    72,   593,   731,     4,   701,   712,   667,   567,   423,
       5,   732,   789,   804,  1663,   266,   568,   977,   751,   768,
     449,     5,   781,   575,   287,   820,   752,   769,   844,   816,
     698,   829,   287,     4,   840,     4,  1664,   817,   717,   830,
     336,   233,   841,   287,  1063,   845,   750,   287,   287,  -289,
     283,  1048,   750,   283,  1618,   679,   283,   283,   983,   283,
     287,   283,   637,   522,  1077,   426,   644,   749,   260,  -520,
     486,   702,   660,   746,   234,  1229,   862,   315,   316,     4,
      37,  1016,  1573,   125,   659,   971,   306,   306,   306,   306,
     306,   306,   306,   306,   306,   306,   306,   306,   306,   306,
     306,   306,   306,   306,   468,   858,  1450,   766,   497,   498,
     499,   619,   472,  1451,   443,   638,   970,  1469,   628,   614,
     792,  1028,  1047,   282,   680,  1067,   282,  1386,  1083,  1090,
      36,   326,  1050,    36,  1365,  1477,  1111,   646,   770,    37,
     980,   493,    37,  1105,   681,  1080,  1087,  1094,   981,  1595,
     625,   923,   815,   700,   485,   778,   246,   865,  1121,  1145,
     517,   701,  1278,  1054,   922,   229,   711,  1603,    66,  1321,
     785,   267,   922,    68,   712,   515,   831,   894,  1221,   895,
    1068,   523,   524,   525,  1312,   731,    36,   529,  1361,   520,
    1378,   475,  1468,   732,    36,    37,  1337,  1107,  1338,   751,
     831,  1084,  1583,   972,   424,   751,  1193,   752,  1091,   453,
     242,  1211,  1146,   752,  1116,   450,   843,  1146,   917,  1514,
     768,   273,   266,    36,  1298,   629,   283,   484,   769,   843,
    1593,   843,    37,   781,  1273,  1137,  1427,  1350,   933,   127,
    1641,   934,   260,   632,   923,  1052,   924,  1645,   937,  1071,
     522,   279,   285,  1053,  1034,   375,  1252,   938,   829,   940,
     725,  1082,   949,   917,   327,   816,   830,   306,   946,   629,
     280,   484,   556,   817,   317,   318,   686,   687,    37,   840,
     382,   725,   829,   239,   919,   726,   383,   841,   693,   664,
     830,   530,   840,   281,   840,  1072,   557,   686,   687,   630,
     841,   240,   841,   344,  1320,   345,   726,  1270,   444,  1048,
     977,   384,   233,   327,   233,   287,   789,   804,  1104,   327,
     346,   625,   327,   625,   445,   239,   625,   631,   760,   532,
     750,   288,   289,   290,   125,   676,   321,  1286,   964,  1077,
     327,  1253,  1254,   240,   378,   234,   704,   234,   322,   703,
     714,   983,  1569,   485,  1347,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   693,   327,   716,   771,   323,
     754,   784,   235,   797,   783,   668,   520,   675,   818,   678,
    1047,   436,   969,   832,  1176,   846,  1292,   792,  1272,   324,
    1050,  1067,   327,   789,   804,  1105,   236,   283,   437,   283,
    1177,   453,   283,  1293,   308,  1028,   727,   627,  1084,   309,
     310,  1091,  1083,   717,   950,   957,   951,   442,  1289,  1090,
    1080,  1054,   327,   728,  1105,  1063,   721,   283,   907,   283,
    1087,   242,  1493,   980,  1194,   331,   481,  1094,  1204,  1151,
     259,   981,   327,   127,  1364,   306,  1494,   285,   718,  1107,
     285,   831,   347,   285,   285,  1515,   285,   666,   285,  1273,
     612,   327,   713,  1064,   332,   719,   613,   927,   843,  1516,
    -287,   241,  -107,   475,   908,   909,   910,  1310,  1107,  1249,
    1065,  1116,   753,   751,   722,   333,   782,   446,  -107,   985,
    1232,   752,   984,  1544,  1116,  1320,   843,   843,   842,   631,
     635,   723,   704,  1052,  1212,   703,   636,  1320,  1089,   843,
    1213,  1053,   686,   687,   707,   334,   917,   291,   714,   292,
    1233,   293,   961,   963,  1214,   966,   968,   745,   958,   959,
     960,   840,  1270,   829,   788,   693,  1234,  1397,   125,   841,
     483,   830,   484,   338,  1226,  1235,  1445,   339,  1286,    37,
     340,   754,   304,  1398,   917,  1257,  1227,   754,  1228,   840,
     840,   693,   835,   789,   804,  1236,  1318,   841,   841,   771,
    1104,  1239,   840,   627,   327,   760,   257,  1630,   258,   341,
     841,   920,   784,  1399,  1400,   783,   928,  1190,  1570,   789,
     847,  1631,   790,   791,  1056,   380,   907,  1055,  1307,  1104,
     797,   760,  1240,  1241,   982,  1070,  1105,  1081,  1088,  1095,
     832,  1364,   647,  1272,   818,   329,   866,  1507,   648,  1083,
     625,   870,  1090,   285,   598,   599,   600,  1448,   625,  1289,
     713,  1108,  1320,  1295,   832,   242,   112,  1087,   848,   442,
    1094,  1119,   908,   909,   910,   306,  1387,  1388,  1389,  1390,
    1296,  1122,   699,   388,  1395,  1320,  1242,   420,  1310,  1060,
    1107,   427,  1116,   753,   430,   370,   371,  1407,   433,   753,
    1412,   329,   665,   483,   767,   484,  1061,   843,   648,   843,
     661,  1310,   662,   441,   375,  1116,   828,   849,  1432,  1433,
     313,   314,  1419,   372,   390,   122,   283,   782,   329,   911,
     843,   306,   394,  -948,   283,  1555,   467,  1445,   670,   396,
     850,   851,   852,   489,   327,   518,   912,   400,   527,   401,
     531,   402,    72,   671,   853,  1461,  1329,  1330,   306,   327,
     533,  1379,   541,   672,   854,   972,  1379,   546,   373,   327,
     840,   412,   840,   842,  1320,   311,   312,   415,   841,   416,
     841,   855,  1163,   417,   239,   376,   842,  1318,   842,   419,
     377,   686,   687,   840,   688,   689,  1495,   690,  1475,  1318,
     550,   841,   240,   378,  1420,  1421,  1422,  1423,  1424,  1307,
     559,  1104,   985,  1519,   562,   984,  1558,    40,  1448,  1515,
      40,   871,   917,   572,   285,   979,   285,   872,   897,   285,
    1141,  1466,  1307,  1520,   898,  1082,   648,   583,   699,   822,
     823,   442,   563,  1201,  1203,  1611,  1158,  1555,  1208,  1310,
    1198,  1160,   613,  1116,   285,  1205,   285,  1161,   250,   251,
    1171,  1197,   693,   253,   254,   754,  1172,   327,   843,    40,
     577,   686,   687,   707,  1199,  1206,   262,  1089,   579,    40,
     327,   327,  1056,  1248,   270,  1055,   745,   581,  1339,  1249,
     789,   804,  1370,  1550,   648,   584,   565,   797,   327,  1247,
     824,  1070,   760,  1611,   693,   767,   319,   320,  1372,  1251,
    1290,  1256,  1081,  1108,   327,   832,  1263,   825,   847,  1377,
    1266,   835,  1088,   446,  1318,   327,  1614,   982,  1558,  1095,
    1051,   840,   789,   804,  1517,   591,   566,   592,  1119,   841,
     593,  1311,  1108,   828,   760,   597,  1475,  1318,  1413,   604,
     874,  1119,   567,  1415,   327,  1475,   329,   706,  1340,   327,
     568,  1487,  1488,   875,   876,   587,   848,   828,  1466,   606,
    1307,   608,   590,   686,   687,   707,   609,   753,   616,   690,
     836,  1426,   569,   570,  1614,   610,   306,   327,   633,   917,
    1566,  1466,   742,   743,   744,   917,    70,   837,    71,    72,
    1431,    73,    74,  1324,  1325,  1434,   327,  1478,   686,   687,
     707,   327,   621,  1479,   690,   849,   490,     5,   788,  1383,
     634,    75,   626,   745,  1480,   842,  1454,  1455,  1456,  1457,
     327,  1481,   639,  1343,  1475,   640,  1318,   327,   850,   851,
     852,  1346,   429,    40,  1163,   693,  -287,  1475,   927,  1496,
    1458,  1459,   853,   842,   842,   327,   651,  1501,    76,    77,
      78,   877,   878,  1502,  1503,  1504,   842,  1379,  1591,  1511,
    1502,  1502,  1591,   789,   457,   327,   790,   791,  1566,   649,
    1466,   645,   708,  1374,  1366,   760,    40,  1368,  1369,   706,
    1371,  1566,  1475,   650,  1375,  1376,  1521,  1522,  1523,   709,
     494,     5,  1249,  1249,  1249,   686,   687,   707,   652,   746,
    1396,   690,   653,  1597,  1598,   673,  1401,   747,   979,  1119,
    1524,  1290,  1311,   285,  1108,   683,  1249,  1526,   715,  1088,
    1585,   285,  1095,  1249,   748,  1527,  1566,  1429,  1530,   733,
    1628,   327,  1119,   737,   327,  1311,  1532,  1537,   879,   880,
     881,   882,  1249,  1249,  1436,   685,  1539,  1542,   883,   884,
     868,   869,  1540,   327,   686,   687,   864,   688,   689,   786,
     690,   691,   692,   686,   687,   693,   688,   689,  1547,   690,
     799,  1548,  1646,   801,   327,  1549,    79,  1161,  1051,   694,
     740,  1161,  1470,  1471,    80,    81,    82,    83,    84,    85,
     686,   833,   707,   867,  1560,   802,   690,     5,   873,   342,
    1161,   693,  1012,  1013,  1562,   745,   900,  1572,   828,  1129,
    1249,   822,   823,   327,  1582,  1607,  1497,  1142,  1143,   904,
    1249,  1249,   772,   773,   842,   774,   842,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,   905,
      24,    25,    26,    27,    28,    29,  1625,   842,  1508,  1665,
    1509,  1510,  1502,  1629,  1633,  1512,  1634,   914,  1635,   327,
    1630,    30,  1161,   695,   327,  1636,  1147,  1148,  1639,  1642,
    1119,   327,   931,  1311,  1161,   327,   742,   743,   744,   932,
     696,   935,  1643,   475,   663,  1130,  1131,  1132,   327,  1580,
     457,  1650,   686,   687,   707,  1133,  1651,   327,   690,   775,
    1654,   939,  1161,  1189,     5,  1134,  1655,   745,   105,     5,
      71,    72,  1658,    73,    74,  1667,   776,  1003,   327,  1191,
    1192,   648,  1135,   936,   772,   773,   941,   774,  1259,  1260,
    1261,   306,   306,    75,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,   942,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
      76,    77,    78,    30,   117,   118,   119,    33,   943,   686,
     687,   707,   944,  1589,  1004,   842,  1358,  1359,  1006,  1587,
     693,  1632,   622,   746,   745,   551,   552,   553,   554,  1007,
    1596,  1025,   504,   505,   506,   507,  1008,  1600,  1489,  1490,
    1015,   772,   773,  1604,   774,  1533,  1534,   721,  1026,   886,
     887,   888,   772,   773,   889,  1622,  1623,   502,   503,   835,
    1140,  1019,  1666,  1021,  1020,  1022,   457,   508,   509,  1619,
    1023,   457,  1030,  1621,   886,   887,   888,   772,   773,   889,
    1624,  1031,   686,   687,   707,   120,    34,  1032,  1033,  1035,
    1036,  1037,   306,   693,  1041,  1057,  1096,   745,   457,    70,
    1637,    71,    72,  1097,    73,    74,    70,   121,    71,    72,
    1098,    73,    74,  1100,   772,   773,  1109,   774,  1114,  1110,
    1112,   693,   860,  1123,    75,  1120,  1124,  1125,    79,   890,
    1126,    75,   835,   122,   859,  1115,    80,    81,    82,    83,
      84,    85,  1127,  1154,  1653,  1149,   891,   105,     5,    71,
      72,   123,    73,    74,  1152,  1139,  1157,  1166,  1167,  1168,
    1169,    76,    77,    78,  1180,  1181,  1178,  1182,    76,    77,
      78,  1183,    75,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,  1184,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,    76,
      77,    78,    30,   117,   118,   119,    33,    70,     5,    71,
      72,  1185,    73,    74,  1186,  1187,   686,   687,   707,   688,
    1196,  1209,   690,  1210,  1222,  1223,  1224,  1225,  1230,  1243,
    1245,   745,    75,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,   105,  1244,    71,
      72,  1013,    73,    74,   822,   823,   835,  1246,  1264,    76,
      77,    78,    30,  1265,  1276,    32,    33,  1277,  1279,    79,
    1281,  1302,    75,  1303,   120,    34,    79,    80,    81,    82,
      83,    84,    85,  1322,    80,    81,    82,    83,    84,    85,
    1323,  1331,   123,  1332,  1333,  1335,   121,  1162,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,    76,
      77,    78,  1342,   117,   118,   519,  1344,    79,   105,  1336,
      71,    72,   122,    73,    74,    80,    81,    82,    83,    84,
      85,  1348,  1351,  1357,  1362,  1382,  1367,  1391,  1392,  1393,
     123,  1402,  1403,    75,  1404,    34,  1405,  1406,  1408,  1409,
    1414,   686,   687,  1440,   688,   689,  1416,  1452,  1482,  1483,
    1417,  1418,   693,  1462,   757,  1484,  1485,   758,   759,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
      76,    77,    78,  1486,   117,   118,   335,    79,  1492,  1498,
    1499,  1500,  1505,  1513,   120,    80,    81,    82,    83,    84,
      85,    70,   760,    71,    72,  1525,    73,    74,  1518,  1528,
     528,  1529,  1535,  1536,  1543,   105,   336,    71,    72,  1541,
      73,    74,  1561,   761,  1563,  1575,    75,  1576,  1577,  1578,
    1579,  1602,  1626,    70,  1588,    71,    72,    79,    73,    74,
      75,  1605,   122,  1606,  1617,    80,    81,    82,    83,    84,
      85,  1620,  1647,  1638,  1627,  1656,  1649,  1644,    75,  1659,
     123,  1660,  1661,    76,    77,    78,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,    76,    77,    78,
    1662,   117,   118,   586,  1668,  1669,    70,   336,    71,    72,
     510,    73,    74,   514,   511,    76,    77,    78,   512,   617,
     513,  1360,   930,  1173,    70,  1195,    71,    72,    79,    73,
      74,    75,   418,   122,   669,   226,    80,    81,    82,    83,
      84,    85,   272,   620,  1384,  1590,   535,   585,   536,    75,
    1385,   123,   686,   687,   707,   688,  1594,   470,   690,   743,
     744,   421,  1150,  1009,  1011,   685,   414,   745,    76,    77,
      78,   863,  1018,  1042,   686,   687,   707,   688,   689,   265,
     690,   691,   692,  1155,  1546,   693,    76,    77,    78,   745,
    1250,  1099,  1280,  1615,  1274,  1291,  1449,  1559,  1640,   694,
     822,   823,   835,  1435,   336,  1014,   772,   773,  1038,   774,
    1599,    79,  1215,   578,  1345,   906,   899,  1334,  1159,    80,
      81,    82,    83,    84,    85,    79,  1349,   422,  1586,  1128,
     122,  1584,  1170,    80,    81,    82,    83,    84,    85,     0,
       0,     0,     0,    79,     0,     0,     0,     0,   123,     0,
       0,    80,    81,    82,    83,    84,    85,   686,     0,   707,
       0,  1102,     0,   690,   685,     0,   674,     0,   693,     0,
       0,     0,   745,   686,   687,   746,   688,   689,  1103,   690,
     691,   692,     0,  1216,   693,     0,     0,     0,     0,   772,
     773,     0,   774,     0,     0,     0,    79,     0,   694,     0,
    1217,     0,     0,     0,    80,    81,    82,    83,    84,    85,
      70,     5,    71,    72,    79,    73,    74,   686,   687,   677,
     688,   689,    80,    81,    82,    83,    84,    85,   693,     0,
     757,     0,     0,   758,   759,    75,     0,   965,     0,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,     0,    24,    25,    26,    27,    28,    29,
      70,     0,    71,    72,     0,    73,    74,     0,   760,     0,
       0,     0,    76,    77,    78,    30,     0,    70,     0,    71,
      72,     0,    73,    74,     0,    75,     0,     0,   462,   761,
       0,    11,     0,     0,     0,     0,     0,     0,     0,     0,
      20,    21,    75,     0,    70,   641,    71,    72,    11,    73,
      74,     0,     0,     0,     0,     0,     0,    20,    21,     0,
       0,     0,    76,    77,    78,    30,   762,     0,    70,    75,
      71,    72,     0,    73,    74,    11,     0,     0,     0,    76,
      77,    78,    30,   763,    20,    21,     0,     0,     0,     0,
       0,     0,    70,    75,    71,    72,     0,    73,    74,     0,
       0,     0,     0,     0,     0,     0,    76,    77,    78,    30,
      70,     0,    71,    72,     0,    73,    74,    75,     0,     0,
     803,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,    78,     0,     0,    75,   686,   687,     0,     0,
      79,     0,     0,     0,     0,     0,     0,   693,    80,    81,
      82,    83,    84,    85,    76,    77,    78,     0,     0,    70,
       0,    71,    72,     0,    73,    74,     0,     0,     0,     0,
       0,     0,    76,    77,    78,   789,   804,     0,     0,     0,
       0,     0,     0,     0,    75,     0,    70,   760,    71,    72,
      79,    73,    74,   463,     0,     0,     0,     0,    80,   464,
      82,    83,    84,    85,     0,     0,   805,    79,     0,     0,
     642,    75,   806,     0,     0,    80,   643,    82,    83,    84,
      85,    76,    77,    78,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,    80,    81,    82,    83,    84,    85,    76,    77,
      78,     0,     0,     0,     0,     0,     0,     0,    79,     0,
     950,     0,   951,   916,  1363,     0,    80,    81,    82,    83,
      84,    85,    70,     0,    71,    72,     0,    73,    74,     0,
       0,     0,    79,     0,   950,     0,   951,   916,  1506,     0,
      80,    81,    82,    83,    84,    85,     0,    75,     0,     0,
      79,     0,   950,     0,   951,   916,   685,     0,    80,    81,
      82,    83,    84,    85,     0,   686,   687,   707,   688,   689,
       0,   690,   691,   692,     0,     0,   693,     0,     0,     0,
       0,     0,     0,     0,    76,    77,    78,     0,     0,     0,
     694,     0,     0,  1326,  1327,    70,     0,    71,    72,    79,
      73,    74,     0,     0,     0,     0,     0,    80,  1328,    82,
      83,    84,    85,     0,     0,     0,    70,     0,    71,    72,
      75,    73,    74,     0,     0,     0,    79,     0,     0,   657,
       0,     0,     0,     0,    80,   658,    82,    83,    84,    85,
      70,    75,    71,    72,     0,    73,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,    78,
       0,     0,     0,     0,    70,    75,    71,    72,     0,    73,
      74,     0,     0,     0,   975,     0,     0,     0,    76,    77,
      78,    70,     0,    71,    72,     0,    73,    74,     0,    75,
       0,   976,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,    78,    70,    75,    71,    72,     0,
      73,    74,    79,     0,     0,     0,     0,   663,     0,     0,
      80,    81,    82,    83,    84,    85,    76,    77,    78,     0,
      75,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     742,   743,   744,    76,    77,    78,     0,     0,    70,     0,
      71,    72,     0,    73,    74,     0,   686,   687,   707,     0,
       0,     0,   690,     0,     0,     0,   685,    76,    77,    78,
       0,   745,     0,    75,     0,   686,   687,   707,   688,   689,
       0,   690,   691,   692,     0,    79,   693,     0,   772,   773,
     916,   774,     0,    80,    81,    82,    83,    84,    85,     0,
     694,     0,     0,     0,     0,     0,    79,     0,     0,   947,
      76,    77,    78,     0,    80,   948,    82,    83,    84,    85,
       0,     0,     0,    70,     0,    71,    72,     0,    73,    74,
      79,   962,     0,     0,   803,     0,     0,     0,    80,    81,
      82,    83,    84,    85,     0,     0,     0,     0,    75,     0,
     686,   687,     0,     0,    79,   967,     0,   746,     0,     0,
       0,   693,    80,    81,    82,    83,    84,    85,     0,     0,
       0,    79,  1200,     0,     0,     0,     0,     0,     0,    80,
      81,    82,    83,    84,    85,    76,    77,    78,     0,   789,
     804,     0,     0,     0,     0,    79,  1202,     0,     0,     0,
       0,   760,     0,    80,    81,    82,    83,    84,    85,    70,
       0,    71,    72,     0,    73,    74,    70,     0,    71,    72,
     805,    73,    74,     0,     0,     0,   806,     0,     0,     0,
      70,     0,    71,    72,    75,    73,    74,     0,    79,  1207,
       0,    75,     0,     0,     0,     0,    80,    81,    82,    83,
      84,    85,     0,     0,     0,    75,     0,     0,     0,   807,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,    78,     0,     0,   808,     0,    76,    77,
      78,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,    78,     0,     0,     0,     1,     2,
       3,     4,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    79,  1373,     0,     0,     0,     0,     0,
       0,    80,    81,    82,    83,    84,    85,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,    31,    32,
      33,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    79,
      24,    25,    26,    27,    28,    29,   274,    80,    81,    82,
      83,    84,    85,     0,    80,    81,    82,    83,    84,    85,
     277,    30,     0,   351,   352,     0,   353,     0,    80,    81,
      82,    83,    84,    85,     0,   354,   355,   356,   357,   358,
     359,     0,     0,     0,     0,     0,     0,     0,     0,    34,
       0,   360,     0,   361,     0,   362,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   364,
      35,     0,     0,     0,     0,     4,     5,   231,   365,     0,
       0,     0,     0,     0,     0,     0,     0,   366,   367,     0,
       0,    36,     0,     0,     0,     0,   368,     0,   369,     0,
      37,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,     0,     0,     4,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,     0,    31,    32,    33,     0,     0,     0,     0,     0,
       0,     0,   921,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,    32,    33,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    34,    24,    25,    26,    27,    28,    29,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    30,     0,     0,     0,     0,
       0,     4,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    34,   469,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,     4,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,    36,     0,    32,
      33,     0,     0,     0,     5,     0,    37,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,     0,     0,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    30,    24,    25,    26,
      27,    28,    29,     0,     4,     5,  1174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    34,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,     0,     4,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
       0,    36,   261,     0,     0,     0,     0,     0,     0,     0,
      37,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,   629,   654,   484,     0,     0,     0,     0,     5,     0,
      37,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,     0,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      30,    24,    25,    26,    27,    28,    29,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,     0,   455,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,    36,    32,    33,     0,     0,
       0,     0,     0,     0,    37,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,   483,   654,   484,     0,     0,
       0,     0,     5,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1179,     5,     0,    34,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,     5,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,     0,     0,    22,    30,    24,    25,    26,
      27,    28,    29,   122,     0,     0,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
       0,     0,     0,     0,     0,  1608,   743,   744,     0,     0,
       0,     0,   685,     0,     0,    30,     0,     0,    32,    33,
     456,   686,   687,   707,   688,   689,     0,   690,   691,   692,
       0,     0,   693,     0,     0,     0,   745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   694,     0,     0,     0,
       0,     0,     0,   772,   773,     0,   774,     0,     0,     0,
     789,   804,     0,     0,     0,     0,     0,     0,     0,   822,
     823,   835,   760,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1552,   743,   744,     0,
       0,   805,   945,   685,     0,     0,     0,   806,    34,     0,
       0,     0,   686,   687,   707,   688,   689,     0,   690,   691,
     692,     0,     0,   693,     0,     0,     0,   745,     0,     0,
       0,     0,   746,     0,     0,     0,     0,   694,     0,     0,
    1609,     0,     0,     0,     0,     0,     0,     0,  1267,   743,
     744,   789,   804,     0,     0,   685,     0,  1610,     0,     0,
     822,   823,   835,   760,   686,   687,   707,   688,   689,     0,
     690,   691,   692,     0,     0,   693,     0,     0,     0,   745,
    1442,     0,   805,     0,     0,     0,     0,     0,   806,   694,
       0,     0,     0,     0,     0,     0,   686,   687,   707,   688,
       0,     0,   690,   789,   804,     0,     0,   693,     0,     0,
       0,   745,     0,   746,     0,   760,     0,     0,     0,     0,
       0,  1553,     0,     0,     0,     0,     0,     0,   772,   773,
       0,   774,     0,     0,   805,   789,   804,     0,  1554,     0,
     806,     0,     0,     0,   822,   823,   835,   760,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1044,     0,     0,     0,     0,   746,   805,   685,     0,     0,
       0,     0,   806,  1268,     0,  1283,   686,   687,     0,   688,
     689,     0,   690,   691,   692,     0,     0,   693,     0,     0,
    1269,   686,   687,   707,   688,     0,     0,   690,     0,     0,
       0,   694,   693,     0,     0,  1443,   745,   351,   352,     0,
     353,     0,     0,     0,     0,   789,   804,   860,     0,   354,
     355,   356,  1444,   358,     0,     0,     0,   760,  1074,     0,
     789,   804,     0,     0,     0,   360,     0,   361,     0,   822,
     823,   835,   760,     0,   686,   687,   805,   688,   689,     0,
     690,     0,   806,   364,     0,   693,     0,     0,     0,     0,
       0,   805,   526,     0,     0,     0,     0,   806,     0,     0,
       0,   366,   367,     0,     0,     0,     0,     0,     0,     0,
     368,     0,     0,   789,   804,  1045,     0,     0,     0,     0,
       0,     0,   822,   823,     0,   760,     0,     0,     0,     0,
    1284,     0,  1046,     0,     0,     0,     0,     0,     0,   743,
     744,     0,     0,     0,   805,   685,     0,  1285,     0,     0,
     806,     0,     0,     0,   686,   687,   707,   688,   689,     0,
     690,   691,   692,     0,     0,   693,     0,     0,     0,   745,
       0,     0,     0,     0,     0,   743,   744,     0,     0,   694,
       0,   685,     0,  1075,     0,     0,   772,   773,     0,   774,
     686,   687,   707,   688,   689,     0,   690,   691,   692,     0,
    1076,   693,   822,   823,   835,   745,     0,     0,     0,     0,
       0,   743,   744,     0,     0,   694,     0,   685,     0,     0,
       0,     0,   772,   773,     0,   774,   686,   687,   707,   688,
     689,     0,   690,   691,   692,     0,     0,   693,     0,     0,
     835,   745,     0,   743,   744,     0,     0,     0,     0,   685,
       0,   694,     0,     0,     0,   746,     0,     0,   686,   687,
     707,   688,   689,  1564,   690,   691,   692,     0,     0,   693,
       0,   743,   744,   745,   822,   823,   835,   685,     0,     0,
    1565,     0,     0,   694,     0,     0,   686,   687,   707,   688,
     689,   746,   690,   691,   692,     0,     0,   693,     0,  1472,
       0,   745,     0,     0,     0,     0,     0,     0,   835,     0,
       0,   694,     0,     0,     0,     0,  1473,     0,     0,     0,
       0,     0,   686,   687,   707,   688,     0,   746,   690,     0,
       0,     0,     0,   693,     0,  1464,     0,   745,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1465,     0,   772,   773,     0,   774,     0,   746,
       0,     0,     0,     0,     0,     0,     0,  1316,     0,     0,
     822,   823,   835,     0,  1608,   743,   744,     0,     0,     0,
       0,   685,     0,     0,  1317,     0,     0,   746,     0,     0,
     686,   687,   707,   688,   689,   987,   690,   691,   692,     0,
       0,   693,     0,     0,     0,   745,     0,     0,     0,     0,
       0,     0,   988,     0,     0,   694,     0,     0,     0,     0,
       0,     0,   772,   773,     0,   774,     0,     0,     0,   789,
     804,  1305,     0,     0,     0,     0,     0,     0,   822,   823,
     835,   760,     0,     0,     0,  1552,   743,   744,  1306,     0,
       0,     0,   685,     0,     0,     0,     0,     0,     0,     0,
     805,   686,   687,   707,   688,   689,   806,   690,   691,   692,
       0,     0,   693,     0,     0,     0,   745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   694,     0,     0,     0,
       0,   746,     0,     0,     0,     0,     0,  1267,   743,   744,
     789,   804,     0,     0,   685,     0,     0,     0,     0,   822,
     823,   835,   760,   686,   687,   707,   688,   689,     0,   690,
     691,   692,     0,     0,   693,     0,     0,     0,   745,     0,
       0,   805,     0,     0,     0,     0,     0,   806,   694,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   789,   804,   743,   744,     0,     0,     0,     0,
     685,     0,   746,     0,   760,     0,     0,     0,     0,   686,
     687,   707,   688,   689,     0,   690,   691,   692,     0,     0,
     693,     0,     0,   805,   745,     0,     0,     0,     0,   806,
     743,   744,     0,     0,   694,     0,   685,     0,     0,     0,
       0,   772,   773,     0,   774,   686,   687,   707,   688,   689,
       0,   690,   691,   692,   746,     0,   693,   822,   823,   835,
     745,     0,     0,     0,     0,     0,   743,   744,     0,     0,
     694,     0,   685,     0,     0,     0,     0,   772,   773,     0,
     774,   686,   687,   707,   688,   689,     0,   690,   691,   692,
       0,     0,   693,     0,     0,   835,   745,     0,     0,     0,
       0,     0,   743,   744,     0,     0,   694,     0,   685,     0,
     746,     0,     0,   772,   773,     0,   774,   686,   687,   707,
     688,   689,     0,   690,   691,   692,     0,     0,   693,     0,
       0,     0,   745,   743,   744,     0,     0,     0,     0,   685,
       0,     0,   694,     0,     0,     0,   746,     0,   686,   687,
     707,   688,   689,     0,   690,   691,   692,     0,     0,   693,
       0,     0,     0,   745,     0,   822,   823,   835,     0,   743,
     744,     0,     0,   694,     0,   685,     0,     0,     0,     0,
       0,     0,   746,     0,   686,   687,   707,   688,   689,  1442,
     690,   691,   692,     0,     0,   693,     0,     0,   835,   745,
       0,     0,     0,     0,     0,   686,   687,   707,   688,   694,
       0,   690,     0,     0,     0,     0,   693,     0,   746,     0,
     745,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   772,   773,     0,
     774,  1044,     0,     0,   789,   804,     0,     0,   685,   746,
    1074,     0,     0,   822,   823,   835,   760,   686,   687,     0,
     688,   689,     0,   690,   691,   692,   686,   687,   693,   688,
     689,     0,   690,  1283,     0,   805,     0,   693,     0,     0,
       0,   806,   694,     0,     0,   746,     0,     0,     0,   686,
     687,   707,   688,     0,     0,   690,   789,   804,     0,     0,
     693,     0,     0,     0,   745,   789,   804,     0,   760,     0,
       0,     0,     0,     0,   822,   823,     0,   760,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   805,   789,   804,
       0,     0,     0,   806,     0,     0,   805,   822,   823,   835,
     760,     0,   806,     0,     0,     0,     0,     0,   351,   352,
       0,   353,     0,     0,   351,   352,     0,   353,     0,   805,
     354,   355,   356,     0,   358,   806,   354,   355,   356,   357,
     358,   359,     0,     0,     0,     0,   360,     0,   361,     0,
       0,     0,   360,     0,   361,     0,   362,     0,     0,     0,
     363,     0,     0,     0,   364,     0,     0,     0,     0,     0,
     364,     0,     0,   526,     0,     5,     0,     0,     0,   365,
       0,     0,   366,   367,     0,     0,     0,     0,   366,   367,
       0,   368,     0,     0,     0,     0,     0,   368,     0,   369,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,   929,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,   387,     0,     0,     0,     0,     0,
     391,     0,   392,     0,   393,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,   397,     0,   398,     0,   399,
       0,     0,     0,     0,     0,     0,     0,   403,     0,   404,
       0,   405,     0,   406,     0,   407,     0,   408,     0,   409,
       0,   410,     0,   411,     0,     0,     0,   413,   686,   687,
     707,   688,     0,     0,   690,     0,     0,     0,     0,   693,
       0,     0,     0,   745,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     772,   773,     0,   774,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   822,   823,   835
};

static const yytype_int16 yycheck[] =
{
       1,    73,    74,    75,   106,    79,   130,   291,   258,    50,
       2,   311,   312,   227,   257,   560,    29,   623,    90,   347,
     618,  1168,  1169,   273,   539,   684,    44,   867,    36,   279,
     274,    44,    40,   277,   106,   573,   280,   281,   252,   834,
      90,   291,   605,   566,   605,   793,    11,   986,   576,  1085,
    1276,  1277,   543,   821,   109,   305,   561,    37,    11,    67,
    1092,   258,    39,  1101,   798,   539,   571,   801,   802,   255,
     237,    48,    49,  1299,   288,  1315,   485,   327,    79,   293,
     107,   158,  1113,   923,    73,    22,    11,   561,   869,    76,
       8,   198,     0,     8,   564,     3,    73,     0,    76,   573,
       3,   198,    78,  1463,   102,     2,    80,    81,    82,   564,
     950,    59,    79,     8,    62,   116,   132,  1192,   126,   111,
     198,   576,    96,    97,    98,   222,   124,    78,   102,    78,
     185,   186,   187,   283,   107,   285,     0,   111,   130,   106,
     195,   219,   124,   205,    52,   222,     8,   539,   540,    52,
       8,    11,     8,   545,     8,   539,   540,   219,   134,     8,
       9,   545,   135,   136,   198,    62,   142,   682,   560,   561,
       8,     9,   564,   124,    11,   124,   560,   561,   205,   571,
     695,   573,    11,     8,   576,     8,   220,   571,   170,   573,
     177,   138,   576,    11,   167,   222,   741,    11,    11,   203,
     274,   787,   747,   277,  1564,   533,   280,   281,   682,   283,
      11,   285,   462,   331,   800,   228,   466,   560,    52,     8,
     284,   695,   631,   197,   171,  1004,   204,    17,    18,     8,
     207,   722,  1472,   130,   484,   200,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   262,   583,  1292,   762,   308,   309,
     310,   447,   270,  1295,   244,   462,   219,  1305,   454,   436,
     793,   741,   787,   274,   199,   798,   277,  1216,   801,   802,
     198,   218,   787,   198,  1359,  1316,   824,   473,   762,   207,
     682,   292,   207,   821,   219,   800,   801,   802,   682,  1525,
     450,   219,   807,   695,   284,   775,   221,   591,   836,   204,
     328,   695,  1060,   787,   920,   328,   708,  1543,   226,  1114,
     775,   269,   928,   226,   708,   326,   800,   890,   987,   890,
    1064,   332,   333,   334,  1102,   727,   198,   338,  1178,   331,
     200,   591,  1304,   727,   198,   207,   204,   821,   204,   741,
     824,  1085,  1499,   681,   203,   747,   954,   741,  1092,   256,
      37,   198,  1143,   747,   834,   203,   821,  1148,   618,   198,
     762,   198,   269,   198,   163,   198,   450,   200,   762,   834,
     198,   836,   207,   775,  1043,   199,   199,  1166,   638,   381,
    1616,   641,   226,   457,   219,   787,   221,   198,   648,    78,
     518,   198,    79,   787,   747,   108,    89,   651,   800,   653,
      80,    80,   662,   663,   205,   807,   800,   489,   661,   198,
     198,   200,   198,   807,   214,   215,    96,    97,   207,   821,
     221,    80,   824,   178,   620,   105,   444,   821,   107,   489,
     824,   338,   834,   198,   836,   124,   222,    96,    97,   457,
     834,   196,   836,    49,  1113,    51,   105,  1043,   205,  1045,
     975,   585,   138,   205,   138,    11,   135,   136,   821,   205,
      66,   621,   205,   623,   221,   178,   626,   457,   147,   221,
    1025,    12,    13,    14,   381,   221,   206,  1073,   221,  1075,
     205,   174,   175,   196,   197,   171,   539,   171,   216,   539,
     540,   975,  1464,   483,   219,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,   107,   205,   124,   561,   217,
     560,   564,   198,   566,   564,   517,   518,   528,   571,   530,
    1045,   205,   221,   573,   205,   578,   205,  1060,  1043,    21,
    1045,  1064,   205,   135,   136,  1073,   222,   621,   222,   623,
     221,   448,   626,   222,   207,  1025,   205,   454,  1292,   212,
     213,  1295,  1085,   170,   200,   667,   202,   244,  1073,  1092,
    1075,  1045,   205,   222,  1102,   167,   147,   651,   102,   653,
    1085,   258,   205,   975,   220,   219,   199,  1092,   221,   873,
     631,   975,   205,   585,  1192,   667,   219,   274,   205,  1073,
     277,  1075,   198,   280,   281,   205,   283,   201,   285,  1268,
     199,   205,   540,   205,   198,   222,   205,   625,  1073,   219,
     203,   629,   205,   873,   148,   149,   150,  1101,  1102,   205,
     222,  1101,   560,  1025,   205,   198,   564,   220,   221,   682,
      78,  1025,   682,   219,  1114,  1304,  1101,  1102,   576,   629,
     199,   222,   695,  1045,   199,   695,   205,  1316,    80,  1114,
     205,  1045,    96,    97,    98,   198,   916,   198,   708,   200,
     108,   202,   673,   674,   219,   676,   677,   111,   670,   671,
     672,  1073,  1268,  1075,    80,   107,   124,   118,   585,  1073,
     198,  1075,   200,   198,    87,   133,  1282,     8,  1284,   207,
     221,   741,   220,   134,   954,  1033,    99,   747,   101,  1101,
    1102,   107,   146,   135,   136,   153,  1113,  1101,  1102,   762,
    1073,    91,  1114,   620,   205,   147,   198,   205,   200,   221,
    1114,   621,   775,   164,   165,   775,   626,   951,   219,   135,
      61,   219,   138,   139,   787,   204,   102,   787,  1101,  1102,
     793,   147,   122,   123,   682,   798,  1284,   800,   801,   802,
     800,  1359,   199,  1268,   807,   867,   592,  1365,   205,  1292,
     920,   597,  1295,   450,     8,     9,    10,  1282,   928,  1284,
     708,   821,  1441,   205,   824,   462,    65,  1292,   109,   466,
    1295,   834,   148,   149,   150,   867,  1222,  1223,  1224,  1225,
     222,   844,   539,   203,  1230,  1464,   176,     8,  1282,   205,
    1284,   198,  1282,   741,   198,    78,    79,  1243,     8,   747,
    1246,   923,   199,   198,   561,   200,   222,  1282,   205,  1284,
     198,  1305,   200,   199,   108,  1305,   573,   158,  1264,  1265,
      15,    16,     1,   106,   147,   203,   920,   775,   950,   205,
    1305,   923,   155,   203,   928,  1441,   132,  1443,   199,   162,
     181,   182,   183,   199,   205,   219,   222,   170,    63,   172,
     221,   174,    11,   199,   195,  1301,  1126,  1127,   950,   205,
     198,  1209,   147,   199,   205,  1213,  1214,   222,   151,   205,
    1282,   194,  1284,   821,  1553,   208,   209,   200,  1282,   202,
    1284,   222,   903,   206,   178,   179,   834,  1304,   836,   212,
     184,    96,    97,  1305,    99,   100,  1342,   102,  1315,  1316,
     222,  1305,   196,   197,    83,    84,    85,    86,    87,  1282,
     124,  1284,   975,   199,   222,   975,  1441,     0,  1443,   205,
       3,   199,  1192,   143,   621,   682,   623,   205,   199,   626,
     199,  1304,  1305,   219,   205,    80,   205,   198,   695,   144,
     145,   638,   222,   964,   965,  1551,   199,  1553,   969,  1443,
     962,   199,   205,  1443,   651,   967,   653,   205,    41,    42,
     199,   199,   107,    46,    47,  1025,   205,   205,  1443,    52,
     222,    96,    97,    98,   199,   199,    59,    80,   222,    62,
     205,   205,  1045,   199,    67,  1045,   111,   222,   199,   205,
     135,   136,   199,  1439,   205,   222,    78,  1060,   205,  1020,
     205,  1064,   147,  1609,   107,   762,    19,    20,   199,  1030,
    1073,  1032,  1075,  1073,   205,  1075,  1037,   222,    61,   199,
    1041,   146,  1085,   220,  1441,   205,  1551,   975,  1553,  1092,
     787,  1443,   135,   136,  1382,   198,   118,   203,  1101,  1443,
       8,  1101,  1102,   800,   147,   203,  1463,  1464,   199,   198,
       8,  1114,   134,   199,   205,  1472,  1178,    80,  1152,   205,
     142,  1331,  1332,    21,    22,   388,   109,   824,  1441,     8,
    1443,   198,   395,    96,    97,    98,   198,  1025,   198,   102,
     205,   199,   164,   165,  1609,   200,  1178,   205,   199,  1359,
    1463,  1464,    80,    81,    82,  1365,     8,   222,    10,    11,
     199,    13,    14,  1124,  1125,   199,   205,   199,    96,    97,
      98,   205,   203,   205,   102,   158,     8,     9,    80,  1211,
     205,    33,   203,   111,   199,  1073,   137,   138,   139,   140,
     205,   199,   201,  1154,  1551,   201,  1553,   205,   181,   182,
     183,  1162,   124,   226,  1165,   107,   203,  1564,  1176,   199,
     161,   162,   195,  1101,  1102,   205,   205,   199,    70,    71,
      72,   119,   120,   205,   199,   199,  1114,  1515,  1516,   199,
     205,   205,  1520,   135,   257,   205,   138,   139,  1551,   199,
    1553,   222,   205,  1204,  1196,   147,   269,  1199,  1200,    80,
    1202,  1564,  1609,   199,  1206,  1207,   199,   199,   199,   222,
       8,     9,   205,   205,   205,    96,    97,    98,   205,   197,
    1231,   102,   205,  1533,  1534,   198,  1237,   205,   975,  1282,
     199,  1284,  1282,   920,  1284,   124,   205,   199,   198,  1292,
    1500,   928,  1295,   205,   222,   199,  1609,  1258,   199,     8,
    1588,   205,  1305,   152,   205,  1305,   199,   199,   206,   207,
     208,   209,   205,   205,  1275,    87,   199,   199,   216,   217,
     204,   205,   205,   205,    96,    97,   589,    99,   100,   106,
     102,   103,   104,    96,    97,   107,    99,   100,   199,   102,
     143,   199,  1630,   134,   205,   199,   198,   205,  1045,   121,
     222,   205,  1313,  1314,   206,   207,   208,   209,   210,   211,
      96,   106,    98,   220,   199,   134,   102,     9,   198,   221,
     205,   107,   159,   160,   199,   111,     8,   199,  1075,   109,
     205,   144,   145,   205,   199,   199,  1347,   204,   205,   200,
     205,   205,   128,   129,  1282,   131,  1284,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,   222,
      52,    53,    54,    55,    56,    57,   199,  1305,  1370,  1663,
    1372,  1373,   205,   199,   199,  1377,   199,     8,   199,   205,
     205,    73,   205,   205,   205,   199,   204,   205,   199,   199,
    1443,   205,     8,  1443,   205,   205,    80,    81,    82,   201,
     222,   201,   199,  1663,   203,   185,   186,   187,   205,  1493,
     483,   199,    96,    97,    98,   195,   199,   205,   102,   205,
     199,     8,   205,     8,     9,   205,   205,   111,     8,     9,
      10,    11,   199,    13,    14,   199,   222,   198,   205,   204,
     205,   205,   222,   201,   128,   129,   199,   131,   148,   149,
     150,  1533,  1534,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,   199,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,   201,    96,
      97,    98,   201,  1514,   198,  1443,   204,   205,   198,  1511,
     107,  1593,   204,   197,   111,   115,   116,   117,   118,   198,
    1531,   205,   315,   316,   317,   318,   198,  1538,   188,   189,
     198,   128,   129,  1544,   131,   208,   209,   147,   222,   125,
     126,   127,   128,   129,   130,   190,   191,   313,   314,   146,
     863,   199,  1664,   222,   198,   222,   629,   319,   320,  1570,
       8,   634,   198,  1574,   125,   126,   127,   128,   129,   130,
    1581,   198,    96,    97,    98,   155,   156,   198,   198,   198,
     198,   198,  1664,   107,   198,   198,   198,   111,   661,     8,
    1601,    10,    11,   198,    13,    14,     8,   177,    10,    11,
     198,    13,    14,   106,   128,   129,   198,   131,   205,   198,
     124,   107,    88,   222,    33,   198,   198,   198,   198,   205,
     198,    33,   146,   203,   204,   222,   206,   207,   208,   209,
     210,   211,   198,   198,  1645,   199,   222,     8,     9,    10,
      11,   221,    13,    14,   219,   222,     8,   198,   198,   198,
     198,    70,    71,    72,   201,   201,   219,   199,    70,    71,
      72,   199,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,   199,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,     8,     9,    10,
      11,   199,    13,    14,   201,   201,    96,    97,    98,    99,
       4,   219,   102,     8,   198,   198,   198,   198,   198,   198,
     219,   111,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     8,   199,    10,
      11,   160,    13,    14,   144,   145,   146,   198,   198,    70,
      71,    72,    73,   198,   198,    76,    77,   198,   198,   198,
     106,   140,    33,   124,   155,   156,   198,   206,   207,   208,
     209,   210,   211,    83,   206,   207,   208,   209,   210,   211,
     222,   198,   221,   198,   198,   205,   177,   219,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,   198,    74,    75,    76,   222,   198,     8,   221,
      10,    11,   203,    13,    14,   206,   207,   208,   209,   210,
     211,   201,     8,     8,   201,   201,   221,   199,   199,   199,
     221,   219,   199,    33,   199,   156,   199,   199,   222,     8,
       8,    96,    97,   124,    99,   100,   205,   205,   199,   199,
     219,   219,   107,   219,   109,   199,   199,   112,   113,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,   199,    74,    75,    76,   198,     8,   201,
     219,   200,   222,     8,   155,   206,   207,   208,   209,   210,
     211,     8,   147,    10,    11,   219,    13,    14,   199,   134,
     221,   134,   199,   205,   219,     8,   177,    10,    11,   205,
      13,    14,   219,   168,   173,   199,    33,   199,   205,   199,
     199,     8,     8,     8,   201,    10,    11,   198,    13,    14,
      33,   199,   203,   199,   199,   206,   207,   208,   209,   210,
     211,   199,     8,   199,   201,   154,   199,   201,    33,     8,
     221,   198,   222,    70,    71,    72,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
       8,    74,    75,    76,   199,   199,     8,   177,    10,    11,
     321,    13,    14,   325,   322,    70,    71,    72,   323,   444,
     324,  1176,   634,   916,     8,   955,    10,    11,   198,    13,
      14,    33,   209,   203,   518,     3,   206,   207,   208,   209,
     210,   211,    67,   448,  1213,  1515,   349,   381,   349,    33,
    1214,   221,    96,    97,    98,    99,  1520,   269,   102,    81,
      82,   225,   872,   695,   708,    87,   198,   111,    70,    71,
      72,   588,   727,   775,    96,    97,    98,    99,   100,    59,
     102,   103,   104,   890,  1433,   107,    70,    71,    72,   111,
    1025,   807,  1064,  1553,  1045,  1075,  1284,  1443,  1609,   121,
     144,   145,   146,  1268,   177,   718,   128,   129,   762,   131,
    1536,   198,   975,   369,  1161,   613,   608,  1134,   900,   206,
     207,   208,   209,   210,   211,   198,  1165,   225,  1502,   854,
     203,   218,   911,   206,   207,   208,   209,   210,   211,    -1,
      -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,   221,    -1,
      -1,   206,   207,   208,   209,   210,   211,    96,    -1,    98,
      -1,   205,    -1,   102,    87,    -1,   221,    -1,   107,    -1,
      -1,    -1,   111,    96,    97,   197,    99,   100,   222,   102,
     103,   104,    -1,   205,   107,    -1,    -1,    -1,    -1,   128,
     129,    -1,   131,    -1,    -1,    -1,   198,    -1,   121,    -1,
     222,    -1,    -1,    -1,   206,   207,   208,   209,   210,   211,
       8,     9,    10,    11,   198,    13,    14,    96,    97,   221,
      99,   100,   206,   207,   208,   209,   210,   211,   107,    -1,
     109,    -1,    -1,   112,   113,    33,    -1,   221,    -1,    -1,
      -1,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    -1,    52,    53,    54,    55,    56,    57,
       8,    -1,    10,    11,    -1,    13,    14,    -1,   147,    -1,
      -1,    -1,    70,    71,    72,    73,    -1,     8,    -1,    10,
      11,    -1,    13,    14,    -1,    33,    -1,    -1,    36,   168,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    33,    -1,     8,    36,    10,    11,    39,    13,
      14,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,
      -1,    -1,    70,    71,    72,    73,   205,    -1,     8,    33,
      10,    11,    -1,    13,    14,    39,    -1,    -1,    -1,    70,
      71,    72,    73,   222,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,     8,    33,    10,    11,    -1,    13,    14,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
       8,    -1,    10,    11,    -1,    13,    14,    33,    -1,    -1,
      80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    -1,    -1,    33,    96,    97,    -1,    -1,
     198,    -1,    -1,    -1,    -1,    -1,    -1,   107,   206,   207,
     208,   209,   210,   211,    70,    71,    72,    -1,    -1,     8,
      -1,    10,    11,    -1,    13,    14,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,   135,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    33,    -1,     8,   147,    10,    11,
     198,    13,    14,   201,    -1,    -1,    -1,    -1,   206,   207,
     208,   209,   210,   211,    -1,    -1,   166,   198,    -1,    -1,
     201,    33,   172,    -1,    -1,   206,   207,   208,   209,   210,
     211,    70,    71,    72,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   206,   207,   208,   209,   210,   211,    70,    71,
      72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,   204,    -1,   206,   207,   208,   209,
     210,   211,     8,    -1,    10,    11,    -1,    13,    14,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,   204,    -1,
     206,   207,   208,   209,   210,   211,    -1,    33,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    87,    -1,   206,   207,
     208,   209,   210,   211,    -1,    96,    97,    98,    99,   100,
      -1,   102,   103,   104,    -1,    -1,   107,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    -1,    -1,    -1,
     121,    -1,    -1,   192,   193,     8,    -1,    10,    11,   198,
      13,    14,    -1,    -1,    -1,    -1,    -1,   206,   207,   208,
     209,   210,   211,    -1,    -1,    -1,     8,    -1,    10,    11,
      33,    13,    14,    -1,    -1,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,    -1,   206,   207,   208,   209,   210,   211,
       8,    33,    10,    11,    -1,    13,    14,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      -1,    -1,    -1,    -1,     8,    33,    10,    11,    -1,    13,
      14,    -1,    -1,    -1,   205,    -1,    -1,    -1,    70,    71,
      72,     8,    -1,    10,    11,    -1,    13,    14,    -1,    33,
      -1,   222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,     8,    33,    10,    11,    -1,
      13,    14,   198,    -1,    -1,    -1,    -1,   203,    -1,    -1,
     206,   207,   208,   209,   210,   211,    70,    71,    72,    -1,
      33,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    81,    82,    70,    71,    72,    -1,    -1,     8,    -1,
      10,    11,    -1,    13,    14,    -1,    96,    97,    98,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    87,    70,    71,    72,
      -1,   111,    -1,    33,    -1,    96,    97,    98,    99,   100,
      -1,   102,   103,   104,    -1,   198,   107,    -1,   128,   129,
     203,   131,    -1,   206,   207,   208,   209,   210,   211,    -1,
     121,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,   201,
      70,    71,    72,    -1,   206,   207,   208,   209,   210,   211,
      -1,    -1,    -1,     8,    -1,    10,    11,    -1,    13,    14,
     198,   199,    -1,    -1,    80,    -1,    -1,    -1,   206,   207,
     208,   209,   210,   211,    -1,    -1,    -1,    -1,    33,    -1,
      96,    97,    -1,    -1,   198,   199,    -1,   197,    -1,    -1,
      -1,   107,   206,   207,   208,   209,   210,   211,    -1,    -1,
      -1,   198,   199,    -1,    -1,    -1,    -1,    -1,    -1,   206,
     207,   208,   209,   210,   211,    70,    71,    72,    -1,   135,
     136,    -1,    -1,    -1,    -1,   198,   199,    -1,    -1,    -1,
      -1,   147,    -1,   206,   207,   208,   209,   210,   211,     8,
      -1,    10,    11,    -1,    13,    14,     8,    -1,    10,    11,
     166,    13,    14,    -1,    -1,    -1,   172,    -1,    -1,    -1,
       8,    -1,    10,    11,    33,    13,    14,    -1,   198,   199,
      -1,    33,    -1,    -1,    -1,    -1,   206,   207,   208,   209,
     210,   211,    -1,    -1,    -1,    33,    -1,    -1,    -1,   205,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    -1,    -1,   222,    -1,    70,    71,
      72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    -1,    -1,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   198,   199,    -1,    -1,    -1,    -1,    -1,
      -1,   206,   207,   208,   209,   210,   211,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    73,    -1,    75,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,   198,
      52,    53,    54,    55,    56,    57,   198,   206,   207,   208,
     209,   210,   211,    -1,   206,   207,   208,   209,   210,   211,
     198,    73,    -1,    78,    79,    -1,    81,    -1,   206,   207,
     208,   209,   210,   211,    -1,    90,    91,    92,    93,    94,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   156,
      -1,   106,    -1,   108,    -1,   110,    -1,    -1,    -1,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,
     177,    -1,    -1,    -1,    -1,     8,     9,   132,   133,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   142,   143,    -1,
      -1,   198,    -1,    -1,    -1,    -1,   151,    -1,   153,    -1,
     207,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    -1,     8,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    -1,    75,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   204,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,   156,    52,    53,    54,    55,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   177,    73,    -1,    -1,    -1,    -1,
      -1,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   207,   156,   157,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    73,   198,    -1,    76,
      77,    -1,    -1,    -1,     9,    -1,   207,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    -1,    -1,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    73,    52,    53,    54,
      55,    56,    57,    -1,     8,     9,   204,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   156,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,     8,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      -1,   198,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     207,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,   198,   199,   200,    -1,    -1,    -1,    -1,     9,    -1,
     207,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    -1,    -1,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      73,    52,    53,    54,    55,    56,    57,    -1,    -1,     9,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,   198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   207,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,     8,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    73,    -1,   198,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,   207,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    73,   198,   199,   200,    -1,    -1,
      -1,    -1,     9,    -1,   207,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   204,     9,    -1,   156,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     9,    -1,    -1,    -1,    40,    41,    42,    43,    44,
      45,    46,    47,    -1,    -1,    50,    73,    52,    53,    54,
      55,    56,    57,   203,    -1,    -1,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    -1,    -1,    -1,    -1,    80,    81,    82,    -1,    -1,
      -1,    -1,    87,    -1,    -1,    73,    -1,    -1,    76,    77,
     199,    96,    97,    98,    99,   100,    -1,   102,   103,   104,
      -1,    -1,   107,    -1,    -1,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    81,    82,    -1,
      -1,   166,   199,    87,    -1,    -1,    -1,   172,   156,    -1,
      -1,    -1,    96,    97,    98,    99,   100,    -1,   102,   103,
     104,    -1,    -1,   107,    -1,    -1,    -1,   111,    -1,    -1,
      -1,    -1,   197,    -1,    -1,    -1,    -1,   121,    -1,    -1,
     205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    81,
      82,   135,   136,    -1,    -1,    87,    -1,   222,    -1,    -1,
     144,   145,   146,   147,    96,    97,    98,    99,   100,    -1,
     102,   103,   104,    -1,    -1,   107,    -1,    -1,    -1,   111,
      80,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   121,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    98,    99,
      -1,    -1,   102,   135,   136,    -1,    -1,   107,    -1,    -1,
      -1,   111,    -1,   197,    -1,   147,    -1,    -1,    -1,    -1,
      -1,   205,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
      -1,   131,    -1,    -1,   166,   135,   136,    -1,   222,    -1,
     172,    -1,    -1,    -1,   144,   145,   146,   147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    -1,   197,   166,    87,    -1,    -1,
      -1,    -1,   172,   205,    -1,    80,    96,    97,    -1,    99,
     100,    -1,   102,   103,   104,    -1,    -1,   107,    -1,    -1,
     222,    96,    97,    98,    99,    -1,    -1,   102,    -1,    -1,
      -1,   121,   107,    -1,    -1,   205,   111,    78,    79,    -1,
      81,    -1,    -1,    -1,    -1,   135,   136,    88,    -1,    90,
      91,    92,   222,    94,    -1,    -1,    -1,   147,    80,    -1,
     135,   136,    -1,    -1,    -1,   106,    -1,   108,    -1,   144,
     145,   146,   147,    -1,    96,    97,   166,    99,   100,    -1,
     102,    -1,   172,   124,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   166,   133,    -1,    -1,    -1,    -1,   172,    -1,    -1,
      -1,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,    -1,   135,   136,   205,    -1,    -1,    -1,    -1,
      -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,    -1,
     205,    -1,   222,    -1,    -1,    -1,    -1,    -1,    -1,    81,
      82,    -1,    -1,    -1,   166,    87,    -1,   222,    -1,    -1,
     172,    -1,    -1,    -1,    96,    97,    98,    99,   100,    -1,
     102,   103,   104,    -1,    -1,   107,    -1,    -1,    -1,   111,
      -1,    -1,    -1,    -1,    -1,    81,    82,    -1,    -1,   121,
      -1,    87,    -1,   205,    -1,    -1,   128,   129,    -1,   131,
      96,    97,    98,    99,   100,    -1,   102,   103,   104,    -1,
     222,   107,   144,   145,   146,   111,    -1,    -1,    -1,    -1,
      -1,    81,    82,    -1,    -1,   121,    -1,    87,    -1,    -1,
      -1,    -1,   128,   129,    -1,   131,    96,    97,    98,    99,
     100,    -1,   102,   103,   104,    -1,    -1,   107,    -1,    -1,
     146,   111,    -1,    81,    82,    -1,    -1,    -1,    -1,    87,
      -1,   121,    -1,    -1,    -1,   197,    -1,    -1,    96,    97,
      98,    99,   100,   205,   102,   103,   104,    -1,    -1,   107,
      -1,    81,    82,   111,   144,   145,   146,    87,    -1,    -1,
     222,    -1,    -1,   121,    -1,    -1,    96,    97,    98,    99,
     100,   197,   102,   103,   104,    -1,    -1,   107,    -1,   205,
      -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,   146,    -1,
      -1,   121,    -1,    -1,    -1,    -1,   222,    -1,    -1,    -1,
      -1,    -1,    96,    97,    98,    99,    -1,   197,   102,    -1,
      -1,    -1,    -1,   107,    -1,   205,    -1,   111,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   222,    -1,   128,   129,    -1,   131,    -1,   197,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   205,    -1,    -1,
     144,   145,   146,    -1,    80,    81,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,   222,    -1,    -1,   197,    -1,    -1,
      96,    97,    98,    99,   100,   205,   102,   103,   104,    -1,
      -1,   107,    -1,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,   222,    -1,    -1,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,
     136,   205,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,
     146,   147,    -1,    -1,    -1,    80,    81,    82,   222,    -1,
      -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    96,    97,    98,    99,   100,   172,   102,   103,   104,
      -1,    -1,   107,    -1,    -1,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,
      -1,   197,    -1,    -1,    -1,    -1,    -1,    80,    81,    82,
     135,   136,    -1,    -1,    87,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,    96,    97,    98,    99,   100,    -1,   102,
     103,   104,    -1,    -1,   107,    -1,    -1,    -1,   111,    -1,
      -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   121,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   135,   136,    81,    82,    -1,    -1,    -1,    -1,
      87,    -1,   197,    -1,   147,    -1,    -1,    -1,    -1,    96,
      97,    98,    99,   100,    -1,   102,   103,   104,    -1,    -1,
     107,    -1,    -1,   166,   111,    -1,    -1,    -1,    -1,   172,
      81,    82,    -1,    -1,   121,    -1,    87,    -1,    -1,    -1,
      -1,   128,   129,    -1,   131,    96,    97,    98,    99,   100,
      -1,   102,   103,   104,   197,    -1,   107,   144,   145,   146,
     111,    -1,    -1,    -1,    -1,    -1,    81,    82,    -1,    -1,
     121,    -1,    87,    -1,    -1,    -1,    -1,   128,   129,    -1,
     131,    96,    97,    98,    99,   100,    -1,   102,   103,   104,
      -1,    -1,   107,    -1,    -1,   146,   111,    -1,    -1,    -1,
      -1,    -1,    81,    82,    -1,    -1,   121,    -1,    87,    -1,
     197,    -1,    -1,   128,   129,    -1,   131,    96,    97,    98,
      99,   100,    -1,   102,   103,   104,    -1,    -1,   107,    -1,
      -1,    -1,   111,    81,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,   121,    -1,    -1,    -1,   197,    -1,    96,    97,
      98,    99,   100,    -1,   102,   103,   104,    -1,    -1,   107,
      -1,    -1,    -1,   111,    -1,   144,   145,   146,    -1,    81,
      82,    -1,    -1,   121,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,   197,    -1,    96,    97,    98,    99,   100,    80,
     102,   103,   104,    -1,    -1,   107,    -1,    -1,   146,   111,
      -1,    -1,    -1,    -1,    -1,    96,    97,    98,    99,   121,
      -1,   102,    -1,    -1,    -1,    -1,   107,    -1,   197,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,    -1,
     131,    80,    -1,    -1,   135,   136,    -1,    -1,    87,   197,
      80,    -1,    -1,   144,   145,   146,   147,    96,    97,    -1,
      99,   100,    -1,   102,   103,   104,    96,    97,   107,    99,
     100,    -1,   102,    80,    -1,   166,    -1,   107,    -1,    -1,
      -1,   172,   121,    -1,    -1,   197,    -1,    -1,    -1,    96,
      97,    98,    99,    -1,    -1,   102,   135,   136,    -1,    -1,
     107,    -1,    -1,    -1,   111,   135,   136,    -1,   147,    -1,
      -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,   135,   136,
      -1,    -1,    -1,   172,    -1,    -1,   166,   144,   145,   146,
     147,    -1,   172,    -1,    -1,    -1,    -1,    -1,    78,    79,
      -1,    81,    -1,    -1,    78,    79,    -1,    81,    -1,   166,
      90,    91,    92,    -1,    94,   172,    90,    91,    92,    93,
      94,    95,    -1,    -1,    -1,    -1,   106,    -1,   108,    -1,
      -1,    -1,   106,    -1,   108,    -1,   110,    -1,    -1,    -1,
     114,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   133,    -1,     9,    -1,    -1,    -1,   133,
      -1,    -1,   142,   143,    -1,    -1,    -1,    -1,   142,   143,
      -1,   151,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,     9,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,   143,    -1,    -1,    -1,    -1,    -1,
     149,    -1,   151,    -1,   153,    -1,    -1,    -1,    -1,    73,
      -1,    -1,    -1,    -1,    -1,   164,    -1,   166,    -1,   168,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,   178,
      -1,   180,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    96,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
      -1,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,   146
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     5,     6,     7,     8,     9,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      73,    75,    76,    77,   156,   177,   198,   207,   224,   248,
     249,   253,   254,   255,   256,   262,   265,   266,   267,   268,
     269,   278,   296,   297,   298,   299,   302,   318,   371,   372,
     373,   418,   419,   421,   543,   546,   587,   589,   599,   600,
       8,    10,    11,    13,    14,    33,    70,    71,    72,   198,
     206,   207,   208,   209,   210,   211,   226,   227,   228,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   246,     8,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    74,    75,    76,
     155,   177,   203,   221,   246,   248,   249,   284,   286,   287,
     289,   290,   291,   292,   293,   294,   295,   306,   325,   326,
     328,   329,   336,   337,   345,   346,   352,   353,   358,   359,
     376,   377,   380,   381,   384,   385,   400,   402,   406,   409,
     412,   426,   427,   434,   435,   440,   441,   444,   445,   448,
     449,   452,   453,   456,   457,   460,   461,   464,   465,   468,
     469,   472,   473,   476,   477,   480,   481,   484,   485,   488,
     489,   492,   493,   496,   497,   505,   506,   509,   510,   513,
     514,   515,   516,   519,   520,   521,   522,   523,   524,   525,
     528,   531,   532,   533,   540,   542,   579,   580,   581,   586,
     587,   595,   596,   599,   604,   605,   296,   316,   317,   318,
     198,   132,   544,   138,   171,   198,   222,   422,   423,   178,
     196,   267,   265,   269,   270,     0,   221,   250,   251,   267,
     249,   249,   316,   249,   249,   301,   304,   198,   200,   268,
     297,    76,   249,   298,   323,   373,   248,   298,   322,   324,
     249,   267,   299,   198,   198,   230,   230,   198,   230,   198,
     198,   198,   246,   254,   259,   265,   275,    11,    12,    13,
      14,   198,   200,   202,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,   220,   245,   230,   232,   207,   212,
     213,   208,   209,    15,    16,    17,    18,   214,   215,    19,
      20,   206,   216,   217,    21,    22,   218,   205,   219,   243,
     247,   219,   198,   198,   198,    76,   177,   284,   198,     8,
     221,   221,   221,   246,    49,    51,    66,   198,   307,   308,
     309,    78,    79,    81,    90,    91,    92,    93,    94,    95,
     106,   108,   110,   114,   124,   133,   142,   143,   151,   153,
      78,    79,   106,   151,   541,   108,   179,   184,   197,   606,
     204,   288,   221,   267,   290,   284,   327,   294,   203,   349,
     327,   294,   294,   294,   327,   401,   327,   294,   294,   294,
     327,   327,   327,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   327,   294,   349,   327,   327,   327,   291,   327,
       8,   325,   586,     8,   203,   278,   318,   198,   102,   124,
     198,   424,   425,     8,   571,   572,   205,   222,   423,   590,
     601,   199,   265,   269,   205,   221,   220,   300,   303,     8,
     203,   278,   287,   248,   305,     8,   199,   249,   271,   272,
     273,   274,    36,   201,   207,   244,   270,   132,   267,   157,
     322,   420,   267,   588,   229,   244,   275,   275,   244,   275,
     275,   199,   259,   198,   200,   269,   276,   277,   259,   199,
       8,   278,   229,   246,     8,   278,   244,   232,   232,   232,
     233,   233,   234,   234,   235,   235,   235,   235,   236,   236,
     237,   238,   239,   240,   241,   246,   244,   316,   219,    76,
     284,   285,   326,   246,   246,   246,   133,    63,   221,   246,
     248,   221,   221,   198,   226,   307,   309,    79,   106,   330,
     347,   147,   534,   536,   537,   354,   222,   198,   222,   517,
     222,   115,   116,   117,   118,   526,   198,   222,   529,   124,
     338,   498,   222,   222,   360,    78,   118,   134,   142,   164,
     165,   403,   143,   428,    78,   124,   436,   222,   541,   222,
     597,   222,   582,   198,   222,   289,    76,   327,   350,   351,
     327,   198,   203,     8,   225,   263,   264,   203,     8,     9,
      10,   319,   320,   321,   198,   374,     8,   578,   198,   198,
     200,   573,   199,   205,   423,   591,   198,   251,   252,   287,
     305,   203,   204,   257,   258,   259,   203,   248,   287,   198,
     267,   269,   276,   199,   205,   199,   205,   244,   270,   201,
     201,    36,   201,   207,   244,   222,   287,   199,   205,   199,
     199,   205,   205,   205,   199,   271,   276,   201,   207,   244,
     277,   198,   200,   203,   232,   199,   201,   219,   284,   285,
     199,   199,   199,   198,   221,   246,   221,   221,   246,   226,
     199,   219,   511,   124,   507,    87,    96,    97,    99,   100,
     102,   103,   104,   107,   121,   205,   222,   331,   332,   552,
     553,   555,   559,   561,   563,   577,    80,    98,   205,   222,
     348,   553,   555,   557,   561,   198,   124,   170,   205,   222,
     535,   147,   205,   222,   537,    80,   105,   205,   222,   355,
     356,   553,   555,     8,   158,   222,   518,   152,   527,   530,
     222,   378,    80,    81,    82,   111,   197,   205,   222,   339,
     340,   553,   555,   557,   561,   567,   608,   109,   112,   113,
     147,   168,   205,   222,   499,   500,   502,   552,   553,   555,
     559,   563,   128,   129,   131,   205,   222,   361,   362,   366,
     368,   553,   557,   561,   563,   567,   106,   458,    80,   135,
     138,   139,   388,   413,   414,   415,   502,   563,   386,   143,
     454,   134,   134,    80,   136,   166,   172,   205,   222,   388,
     390,   397,   398,   404,   405,   502,   553,   555,   563,    78,
     124,   462,   144,   145,   205,   222,   429,   430,   552,   553,
     555,   559,   561,   106,   442,   146,   205,   222,   437,   438,
     553,   555,   557,   567,   205,   222,   563,    61,   109,   158,
     181,   182,   183,   195,   205,   222,   598,   583,   226,   204,
      88,    76,   204,   351,   327,   229,   263,   220,   204,   205,
     263,   199,   205,   198,     8,    21,    22,   119,   120,   206,
     207,   208,   209,   216,   217,   549,   125,   126,   127,   130,
     205,   222,   363,   364,   366,   368,   375,   199,   205,   571,
       8,   569,   570,   575,   200,   222,   572,   102,   148,   149,
     150,   205,   222,   592,     8,   603,   203,   244,   279,   287,
     257,   204,   258,   219,   221,   260,   261,   267,   257,    58,
     273,     8,   201,   244,   244,   201,   201,   244,   275,     8,
     275,   199,   199,   201,   201,   199,   271,   201,   207,   244,
     200,   202,   279,   280,   281,   282,   283,   243,   284,   284,
     284,   246,   199,   246,   221,   221,   246,   199,   246,   221,
     219,   200,   226,   310,   311,   205,   222,   332,   512,   552,
     553,   555,   557,   559,   561,   563,   382,   205,   222,   332,
     340,   508,   552,   553,   555,   557,   559,   561,   563,   335,
     554,   556,   560,   198,   198,   334,   198,   198,   198,   331,
     558,   348,   159,   160,   535,   198,   537,   357,   355,   199,
     198,   222,   222,     8,   568,   205,   222,   339,   362,   379,
     198,   198,   198,   198,   339,   198,   198,   198,   499,   367,
     369,   198,   361,   494,    80,   205,   222,   332,   405,   459,
     502,   552,   553,   555,   559,   561,   563,   198,   416,   417,
     205,   222,   414,   167,   205,   222,   387,   388,   390,   395,
     563,    78,   124,   470,    80,   205,   222,   405,   429,   455,
     502,   563,    80,   388,   390,   407,   408,   502,   563,    80,
     388,   390,   410,   411,   502,   563,   198,   198,   198,   404,
     106,   466,   205,   222,   430,   437,   463,   559,   561,   198,
     198,   429,   124,   446,   205,   222,   362,   437,   443,   563,
     198,   437,   563,   222,   198,   198,   198,   198,   598,   109,
     185,   186,   187,   195,   205,   222,   584,   199,   607,   222,
     327,   199,   204,   205,   247,   204,   264,   204,   205,   199,
     320,   229,   219,   365,   198,   375,   545,     8,   199,   573,
     199,   205,   219,   246,   576,   574,   198,   198,   198,   198,
     592,   199,   205,   280,   204,   247,   205,   221,   219,   204,
     201,   201,   199,   199,   199,   199,   201,   201,   247,     8,
     278,   204,   205,   279,   220,   283,     4,   199,   284,   199,
     199,   246,   199,   246,   221,   284,   199,   199,   246,   219,
       8,   198,   199,   205,   219,   512,   205,   222,   362,   383,
     508,   508,   198,   198,   198,   198,    87,    99,   101,   549,
     198,   333,    78,   108,   124,   133,   153,   564,   566,    91,
     122,   123,   176,   198,   199,   219,   198,   246,   199,   205,
     379,   246,    89,   174,   175,   344,   246,   226,   501,   148,
     149,   150,   504,   246,   198,   198,   246,    80,   205,   222,
     405,   495,   502,   508,   459,   389,   198,   198,   414,   198,
     387,   106,   474,    80,   205,   222,   405,   463,   471,   502,
     563,   455,   205,   222,   408,   205,   222,   411,   163,   392,
     393,   399,   140,   124,   478,   205,   222,   430,   443,   467,
     559,   561,   463,   431,   432,   450,   205,   222,   438,   447,
     508,   443,    83,   222,   246,   246,   192,   193,   207,   244,
     244,   198,   198,   198,   584,   205,   221,   204,   204,   199,
     254,   550,   198,   246,   222,   570,   246,   219,   201,   576,
     549,     8,   593,   594,   593,   593,   602,     8,   204,   205,
     261,   247,   201,   204,   279,   281,   284,   221,   284,   284,
     199,   284,   199,   199,   246,   284,   284,   199,   200,   226,
     312,   313,   201,   230,   311,   312,   383,   568,   568,   568,
     568,   199,   199,   199,   562,   568,   246,   118,   134,   164,
     165,   246,   219,   199,   199,   199,   199,   568,   222,     8,
     538,   539,   568,   199,     8,   199,   205,   219,   219,     1,
      83,    84,    85,    86,    87,   343,   199,   199,   609,   246,
     503,   199,   568,   568,   199,   495,   246,   569,   569,   396,
     124,   482,    80,   205,   222,   405,   467,   475,   502,   471,
     408,   411,   205,   569,   137,   138,   139,   140,   161,   162,
     394,   568,   219,   486,   205,   222,   430,   447,   479,   467,
     246,   246,   205,   222,   383,   438,   451,   447,   199,   205,
     199,   199,   199,   199,   199,   199,   199,   244,   244,   188,
     189,   585,     8,   205,   219,   568,   199,   246,   201,   219,
     200,   199,   205,   199,   199,   222,   204,   279,   284,   284,
     284,   199,   284,     8,   198,   205,   219,   226,   199,   199,
     219,   199,   199,   199,   199,   219,   199,   199,   134,   134,
     199,   565,   199,   208,   209,   199,   205,   199,   342,   199,
     205,   205,   199,   219,   219,   370,   370,   199,   199,   199,
     568,   490,    80,   205,   222,   405,   479,   483,   502,   475,
     199,   219,   199,   173,   205,   222,   430,   451,   487,   479,
     219,   433,   199,   451,   439,   199,   199,   205,   199,   199,
     254,   547,   199,   593,   218,   244,   594,   284,   201,   246,
     313,   226,   314,   198,   314,   569,   246,   233,   233,   538,
     246,   341,     8,   569,   246,   199,   199,   199,    80,   205,
     222,   405,   487,   491,   502,   483,   391,   199,   487,   246,
     199,   246,   190,   191,   246,   199,     8,   201,   226,   199,
     205,   219,   230,   199,   199,   199,   199,   246,   199,   199,
     491,   569,   199,   199,   201,   198,   226,     8,   315,   199,
     199,   199,   548,   246,   199,   205,   154,   551,   199,     8,
     198,   222,     8,   198,   220,   229,   243,   199,   199,   199
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   223,   224,   224,   224,   224,   225,   226,   226,   227,
     227,   227,   227,   228,   228,   228,   228,   228,   228,   228,
     228,   228,   228,   228,   228,   229,   229,   229,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   231,   231,   231,
     231,   231,   231,   232,   232,   233,   233,   233,   233,   234,
     234,   234,   235,   235,   235,   236,   236,   236,   236,   236,
     237,   237,   237,   238,   238,   239,   239,   240,   240,   241,
     241,   242,   242,   243,   243,   244,   244,   245,   245,   245,
     245,   245,   245,   245,   245,   245,   245,   245,   246,   246,
     247,   248,   248,   248,   248,   248,   248,   249,   249,   249,
     249,   249,   249,   249,   249,   250,   250,   251,   252,   251,
     253,   253,   253,   253,   253,   254,   254,   254,   254,   254,
     254,   254,   254,   254,   254,   254,   254,   254,   254,   254,
     255,   255,   255,   255,   255,   255,   256,   256,   257,   257,
     258,   258,   259,   259,   259,   259,   260,   260,   261,   261,
     261,   262,   262,   262,   262,   262,   262,   262,   262,   263,
     263,   264,   264,   265,   265,   265,   265,   266,   267,   267,
     268,   268,   268,   268,   268,   268,   268,   268,   268,   268,
     268,   268,   268,   268,   269,   269,   269,   269,   270,   270,
     271,   271,   272,   272,   273,   273,   273,   274,   274,   275,
     275,   276,   276,   276,   277,   277,   277,   277,   277,   277,
     277,   277,   277,   277,   277,   278,   279,   279,   279,   280,
     280,   280,   280,   281,   282,   282,   283,   283,   283,   284,
     284,   284,   284,   284,   284,   284,   284,   284,   284,   285,
     285,   286,   286,   286,   287,   288,   287,   289,   289,   290,
     290,   290,   290,   291,   291,   292,   292,   292,   293,   293,
     293,   294,   294,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   294,   295,   295,   295,   295,   295,   296,   296,
     297,   297,   297,   297,   297,   298,   298,   300,   299,   301,
     299,   303,   302,   304,   302,   305,   305,   306,   306,   307,
     307,   307,   307,   307,   308,   308,   309,   309,   310,   310,
     310,   311,   311,   312,   312,   312,   313,   313,   314,   314,
     315,   315,   316,   316,   317,   317,   318,   319,   319,   320,
     320,   320,   321,   321,   321,   322,   322,   323,   324,   324,
     325,   325,   325,   325,   325,   325,   325,   325,   325,   325,
     325,   325,   325,   325,   325,   325,   325,   325,   325,   325,
     325,   325,   325,   325,   325,   325,   325,   325,   325,   325,
     325,   325,   325,   326,   326,   326,   326,   326,   326,   326,
     326,   326,   327,   328,   329,   330,   330,   330,   331,   331,
     331,   331,   331,   331,   331,   333,   332,   334,   332,   332,
     335,   332,   336,   337,   338,   338,   338,   339,   339,   339,
     339,   339,   339,   340,   340,   340,   341,   340,   342,   340,
     340,   340,   343,   343,   343,   343,   343,   343,   344,   344,
     344,   345,   346,   347,   347,   347,   348,   348,   348,   348,
     348,   349,   350,   350,   350,   351,   352,   353,   354,   354,
     354,   355,   355,   355,   355,   357,   356,   358,   359,   360,
     360,   360,   361,   361,   361,   361,   361,   361,   362,   362,
     362,   363,   363,   365,   364,   367,   366,   369,   368,   370,
     370,   371,   372,   372,   373,   374,   374,   374,   375,   375,
     375,   375,   375,   376,   377,   378,   378,   378,   379,   379,
     380,   381,   382,   382,   382,   383,   383,   384,   385,   386,
     386,   386,   387,   387,   387,   387,   389,   388,   391,   390,
     392,   390,   393,   393,   393,   394,   394,   394,   394,   394,
     394,   396,   395,   397,   399,   398,   401,   400,   402,   403,
     403,   403,   404,   404,   404,   404,   404,   404,   405,   405,
     405,   405,   406,   407,   407,   407,   408,   408,   408,   408,
     408,   409,   410,   410,   410,   411,   411,   411,   411,   411,
     412,   413,   413,   413,   414,   414,   414,   414,   414,   416,
     415,   417,   415,   418,   418,   419,   420,   421,   421,   422,
     422,   422,   424,   423,   425,   423,   426,   427,   428,   428,
     428,   429,   429,   429,   429,   429,   429,   431,   430,   432,
     430,   433,   433,   434,   435,   436,   436,   436,   437,   437,
     437,   437,   437,   438,   439,   438,   440,   441,   442,   442,
     442,   443,   443,   443,   444,   445,   446,   446,   446,   447,
     447,   448,   449,   450,   450,   450,   451,   451,   452,   453,
     454,   454,   454,   455,   455,   455,   455,   455,   456,   457,
     458,   458,   458,   459,   459,   459,   459,   459,   459,   459,
     459,   459,   459,   460,   461,   462,   462,   462,   463,   463,
     463,   463,   464,   465,   466,   466,   466,   467,   467,   467,
     467,   468,   469,   470,   470,   470,   471,   471,   471,   471,
     471,   472,   473,   474,   474,   474,   475,   475,   475,   475,
     476,   477,   478,   478,   478,   479,   479,   480,   481,   482,
     482,   482,   483,   483,   483,   483,   484,   485,   486,   486,
     486,   487,   487,   488,   489,   490,   490,   490,   491,   491,
     491,   491,   492,   493,   494,   494,   494,   495,   495,   495,
     495,   496,   497,   498,   498,   498,   499,   499,   499,   499,
     499,   499,   499,   501,   500,   500,   500,   500,   503,   502,
     504,   504,   504,   505,   506,   507,   507,   507,   508,   508,
     508,   508,   508,   508,   508,   508,   508,   509,   510,   511,
     511,   511,   512,   512,   512,   512,   512,   512,   512,   512,
     513,   514,   515,   516,   516,   516,   517,   518,   519,   520,
     521,   522,   523,   524,   525,   526,   526,   526,   526,   526,
     527,   527,   528,   528,   530,   529,   531,   531,   532,   533,
     533,   534,   534,   534,   535,   535,   536,   536,   536,   537,
     538,   538,   539,   539,   539,   540,   540,   540,   541,   541,
     541,   541,   542,   544,   545,   543,   547,   548,   546,   549,
     549,   549,   549,   549,   549,   549,   549,   549,   549,   549,
     550,   550,   551,   551,   551,   552,   552,   552,   554,   553,
     556,   555,   558,   557,   560,   559,   562,   561,   564,   563,
     565,   563,   566,   566,   566,   566,   566,   566,   566,   566,
     566,   567,   568,   568,   569,   569,   570,   570,   571,   571,
     572,   572,   574,   573,   575,   573,   576,   576,   576,   576,
     576,   577,   577,   577,   577,   578,   578,   579,   579,   580,
     582,   581,   583,   583,   583,   584,   584,   584,   584,   584,
     585,   585,   585,   585,   586,   586,   586,   586,   588,   587,
     587,   590,   589,   591,   591,   591,   592,   592,   592,   592,
     593,   593,   594,   594,   594,   595,   596,   597,   597,   597,
     598,   598,   598,   598,   598,   598,   598,   598,   598,   598,
     599,   601,   602,   600,   603,   603,   604,   604,   605,   606,
     607,   606,   608,   609,   608
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     2,     2,     1,     1,     2,     1,
       1,     1,     3,     1,     4,     4,     4,     3,     3,     3,
       3,     2,     2,     6,     7,     0,     1,     3,     1,     2,
       2,     2,     2,     4,     6,     6,     6,     1,     1,     1,
       1,     1,     1,     1,     4,     1,     3,     3,     3,     1,
       3,     3,     1,     3,     3,     1,     3,     3,     3,     3,
       1,     3,     3,     1,     3,     1,     3,     1,     3,     1,
       3,     1,     3,     1,     5,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     1,
       2,     1,     2,     1,     2,     1,     3,     1,     0,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     4,     6,     6,     3,     3,     1,     1,     1,     2,
       3,     2,     1,     2,     1,     2,     1,     3,     1,     3,
       2,     5,     6,     6,     6,     7,     7,     3,     3,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     3,     4,     4,     5,     5,     6,     6,     4,
       5,     4,     3,     4,     1,     2,     2,     3,     1,     2,
       1,     3,     1,     3,     2,     1,     2,     1,     3,     1,
       2,     1,     1,     2,     3,     2,     3,     3,     4,     3,
       4,     2,     3,     3,     4,     1,     1,     3,     4,     1,
       2,     3,     4,     2,     1,     2,     3,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     4,     3,     2,     0,     4,     1,     2,     1,
       1,     1,     1,     1,     2,     5,     7,     5,     5,     7,
       1,     6,     7,     7,     7,     8,     8,     8,     9,     6,
       7,     7,     8,     3,     2,     2,     2,     3,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     0,
       3,     0,     5,     0,     4,     1,     2,     2,     3,     3,
       5,     7,     9,    11,     1,     2,     1,     1,     0,     1,
       3,     7,     4,     0,     1,     3,     7,     4,     1,     3,
       1,     3,     0,     1,     1,     2,     6,     1,     3,     0,
       1,     4,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     4,     0,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     5,     0,     5,     1,
       0,     5,     2,     4,     0,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     4,     5,     0,     8,     0,     7,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       2,     2,     4,     0,     2,     3,     1,     1,     1,     1,
       1,     3,     1,     2,     3,     3,     2,     4,     0,     2,
       3,     1,     1,     1,     1,     0,     5,     2,     4,     0,
       2,     3,     1,     1,     1,     1,     1,     1,     4,     1,
       1,     1,     1,     0,     5,     0,     6,     0,     6,     0,
       2,     2,     1,     2,     5,     0,     2,     3,     4,     1,
       1,     1,     1,     2,     5,     0,     2,     3,     1,     1,
       2,     6,     0,     2,     3,     1,     1,     2,     5,     0,
       2,     3,     1,     1,     1,     1,     0,     5,     0,     8,
       0,     5,     0,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     6,     0,     5,     0,     3,     4,     0,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     6,     1,     2,     3,     1,     1,     1,     1,
       1,     6,     1,     2,     3,     1,     1,     1,     1,     1,
       5,     1,     2,     3,     1,     1,     1,     1,     1,     0,
       5,     0,     5,     3,     1,     2,     2,     5,     3,     1,
       2,     3,     0,     5,     0,     5,     2,     4,     0,     2,
       3,     1,     1,     1,     1,     1,     1,     0,     6,     0,
       5,     0,     2,     2,     4,     0,     2,     3,     1,     1,
       1,     1,     1,     4,     0,     7,     2,     5,     0,     2,
       3,     1,     1,     1,     2,     6,     0,     2,     3,     1,
       1,     2,     7,     0,     2,     3,     1,     1,     2,     5,
       0,     2,     3,     1,     1,     1,     1,     1,     2,     5,
       0,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     5,     0,     2,     3,     1,     1,
       1,     1,     2,     6,     0,     2,     3,     1,     1,     1,
       1,     2,     6,     0,     2,     3,     1,     1,     1,     1,
       1,     2,     7,     0,     2,     3,     1,     1,     1,     1,
       2,     7,     0,     2,     3,     1,     1,     2,     8,     0,
       2,     3,     1,     1,     1,     1,     2,     8,     0,     2,
       3,     1,     1,     2,     9,     0,     2,     3,     1,     1,
       1,     1,     2,     6,     0,     2,     3,     1,     1,     1,
       1,     2,     4,     0,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     0,     5,     1,     1,     4,     0,     7,
       1,     1,     1,     2,     5,     0,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     5,     0,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     2,     3,     4,     5,     3,     4,     3,     3,
       2,     3,     3,     2,     5,     0,     1,     1,     1,     1,
       0,     1,     3,     4,     0,     4,     2,     1,     4,     7,
       4,     0,     2,     3,     1,     1,     1,     2,     3,     6,
       1,     3,     1,     3,     3,     4,     5,     6,     1,     1,
       1,     1,     3,     0,     0,     7,     0,     0,    14,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     0,     6,     7,     4,     4,     4,     0,     5,
       0,     5,     0,     5,     0,     5,     0,     7,     0,     5,
       0,     7,     1,     1,     1,     2,     3,     3,     2,     1,
       1,     4,     1,     3,     1,     3,     1,     2,     1,     3,
       1,     2,     0,     5,     0,     4,     3,     2,     1,     2,
       1,     4,     4,     4,     4,     1,     3,     1,     1,     3,
       0,     5,     0,     2,     3,     4,     4,     4,     1,     1,
       1,     1,     3,     3,     1,     1,     1,     1,     0,     4,
       2,     0,     5,     0,     2,     3,     4,     4,     4,     6,
       1,     3,     1,     5,     4,     6,     4,     0,     2,     3,
       4,     4,     4,     4,     4,     1,     1,     1,     4,     4,
       1,     0,     0,     8,     1,     3,     2,     2,     3,     4,
       0,     7,     4,     0,     7
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 550 "parser.y" /* yacc.c:1646  */
    { /* to avoid warnings */ }
#line 3852 "parser.c" /* yacc.c:1646  */
    break;

  case 3:
#line 551 "parser.y" /* yacc.c:1646  */
    { pastree_expr = (yyvsp[0].expr); }
#line 3858 "parser.c" /* yacc.c:1646  */
    break;

  case 4:
#line 552 "parser.y" /* yacc.c:1646  */
    { pastree_stmt = (yyvsp[0].stmt); }
#line 3864 "parser.c" /* yacc.c:1646  */
    break;

  case 5:
#line 553 "parser.y" /* yacc.c:1646  */
    { pastree_stmt = (yyvsp[0].stmt); }
#line 3870 "parser.c" /* yacc.c:1646  */
    break;

  case 6:
#line 571 "parser.y" /* yacc.c:1646  */
    {
      symbol s = Symbol((yyvsp[0].name));
      if (checkDecls)
      {
        if ( symtab_get(stab, s, LABELNAME) )  /* NOT a type name */
          parse_error(-1, "enum symbol '%s' is already in use.", (yyvsp[0].name));
        symtab_put(stab, s, LABELNAME);
      }
      (yyval.symb) = s;
    }
#line 3885 "parser.c" /* yacc.c:1646  */
    break;

  case 7:
#line 592 "parser.y" /* yacc.c:1646  */
    {
      (yyval.string) = strdup((yyvsp[0].name));
    }
#line 3893 "parser.c" /* yacc.c:1646  */
    break;

  case 8:
#line 596 "parser.y" /* yacc.c:1646  */
    {
      /* Or we could leave it as is (as a SpaceList) */
      if (((yyvsp[-1].string) = realloc((yyvsp[-1].string), strlen((yyvsp[-1].string)) + strlen((yyvsp[0].name)))) == NULL)
        parse_error(-1, "string out of memory\n");
      strcpy(((yyvsp[-1].string))+(strlen((yyvsp[-1].string))-1),((yyvsp[0].name))+1);  /* Catenate on the '"' */
      (yyval.string) = (yyvsp[-1].string);
    }
#line 3905 "parser.c" /* yacc.c:1646  */
    break;

  case 9:
#line 619 "parser.y" /* yacc.c:1646  */
    {
      symbol  id = Symbol((yyvsp[0].name));
      stentry e;
      bool    chflag = false;

      if (checkDecls)
      {
        check_uknown_var((yyvsp[0].name));
        /* The parser constructs the original AST; this is the only
         * place it doesn't (actually there is one more place, when replacing
         * the "main" function): threadprivate variables are replaced on the
         * fly by pointers. This makes the job of later stages much smoother,
         * but the produced AST is semantically incorrect.
         */
        if ((e = symtab_get(stab, id, IDNAME)) != NULL) /* could be enum name */
          if (istp(e) && threadmode)
            chflag = true;
      }
      (yyval.expr) = chflag ? Parenthesis(Deref(Identifier(id)))
                  : Identifier(id);
    }
#line 3931 "parser.c" /* yacc.c:1646  */
    break;

  case 10:
#line 641 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = Constant( strdup((yyvsp[0].name)) );
    }
#line 3939 "parser.c" /* yacc.c:1646  */
    break;

  case 11:
#line 645 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = String((yyvsp[0].string));
    }
#line 3947 "parser.c" /* yacc.c:1646  */
    break;

  case 12:
#line 649 "parser.y" /* yacc.c:1646  */
    {
      if ((yyvsp[-1].expr)->type == IDENT || (yyvsp[-1].expr)->type == CONSTVAL || (yyvsp[-1].expr)->type == STRING)
        (yyval.expr) = (yyvsp[-1].expr);   /* simplify */
      else
        (yyval.expr) = Parenthesis((yyvsp[-1].expr));
    }
#line 3958 "parser.c" /* yacc.c:1646  */
    break;

  case 13:
#line 660 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 3966 "parser.c" /* yacc.c:1646  */
    break;

  case 14:
#line 664 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = ArrayIndex((yyvsp[-3].expr), (yyvsp[-1].expr));
    }
#line 3974 "parser.c" /* yacc.c:1646  */
    break;

  case 15:
#line 674 "parser.y" /* yacc.c:1646  */
    {
      /* Catch calls to "main()" (unlikely but possible) */
      (yyval.expr) = strcmp((yyvsp[-3].name), "main") ?
             FunctionCall(IdentName((yyvsp[-3].name)), (yyvsp[-1].expr)) :
             FunctionCall(IdentName(MAIN_NEWNAME), (yyvsp[-1].expr));
    }
#line 3985 "parser.c" /* yacc.c:1646  */
    break;

  case 16:
#line 681 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = FunctionCall((yyvsp[-3].expr), (yyvsp[-1].expr));
    }
#line 3993 "parser.c" /* yacc.c:1646  */
    break;

  case 17:
#line 685 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = DotField((yyvsp[-2].expr), Symbol((yyvsp[0].name)));
    }
#line 4001 "parser.c" /* yacc.c:1646  */
    break;

  case 18:
#line 689 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = PtrField((yyvsp[-2].expr), Symbol((yyvsp[0].name)));
    }
#line 4009 "parser.c" /* yacc.c:1646  */
    break;

  case 19:
#line 698 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = DotField((yyvsp[-2].expr), (yyvsp[0].symb));
    }
#line 4017 "parser.c" /* yacc.c:1646  */
    break;

  case 20:
#line 702 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = PtrField((yyvsp[-2].expr), (yyvsp[0].symb));
    }
#line 4025 "parser.c" /* yacc.c:1646  */
    break;

  case 21:
#line 706 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = PostOperator((yyvsp[-1].expr), UOP_inc);
    }
#line 4033 "parser.c" /* yacc.c:1646  */
    break;

  case 22:
#line 710 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = PostOperator((yyvsp[-1].expr), UOP_dec);
    }
#line 4041 "parser.c" /* yacc.c:1646  */
    break;

  case 23:
#line 714 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CastedExpr((yyvsp[-4].decl), BracedInitializer((yyvsp[-1].expr)));
    }
#line 4049 "parser.c" /* yacc.c:1646  */
    break;

  case 24:
#line 718 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CastedExpr((yyvsp[-5].decl), BracedInitializer((yyvsp[-2].expr)));
    }
#line 4057 "parser.c" /* yacc.c:1646  */
    break;

  case 25:
#line 726 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = NULL;
    }
#line 4065 "parser.c" /* yacc.c:1646  */
    break;

  case 26:
#line 730 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4073 "parser.c" /* yacc.c:1646  */
    break;

  case 27:
#line 734 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4081 "parser.c" /* yacc.c:1646  */
    break;

  case 28:
#line 742 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4089 "parser.c" /* yacc.c:1646  */
    break;

  case 29:
#line 746 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = PreOperator((yyvsp[0].expr), UOP_inc);
    }
#line 4097 "parser.c" /* yacc.c:1646  */
    break;

  case 30:
#line 750 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = PreOperator((yyvsp[0].expr), UOP_dec);
    }
#line 4105 "parser.c" /* yacc.c:1646  */
    break;

  case 31:
#line 754 "parser.y" /* yacc.c:1646  */
    {
      if ((yyvsp[-1].type) == -1)
        (yyval.expr) = (yyvsp[0].expr);                    /* simplify */
      else
        (yyval.expr) = UnaryOperator((yyvsp[-1].type), (yyvsp[0].expr));
    }
#line 4116 "parser.c" /* yacc.c:1646  */
    break;

  case 32:
#line 761 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = Sizeof((yyvsp[0].expr));
    }
#line 4124 "parser.c" /* yacc.c:1646  */
    break;

  case 33:
#line 765 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = Sizeoftype((yyvsp[-1].decl));
    }
#line 4132 "parser.c" /* yacc.c:1646  */
    break;

  case 34:
#line 774 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = FunctionCall(IdentName("__builtin_va_arg"),
                        CommaList((yyvsp[-3].expr), TypeTrick((yyvsp[-1].decl))));
    }
#line 4141 "parser.c" /* yacc.c:1646  */
    break;

  case 35:
#line 779 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = FunctionCall(IdentName("__builtin_offsetof"),
                        CommaList(TypeTrick((yyvsp[-3].decl)), IdentName((yyvsp[-1].name))));
    }
#line 4150 "parser.c" /* yacc.c:1646  */
    break;

  case 36:
#line 784 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = FunctionCall(IdentName("__builtin_types_compatible_p"),
                        CommaList(TypeTrick((yyvsp[-3].decl)), TypeTrick((yyvsp[-1].decl))));
    }
#line 4159 "parser.c" /* yacc.c:1646  */
    break;

  case 37:
#line 793 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = UOP_addr;
    }
#line 4167 "parser.c" /* yacc.c:1646  */
    break;

  case 38:
#line 797 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = UOP_star;
    }
#line 4175 "parser.c" /* yacc.c:1646  */
    break;

  case 39:
#line 801 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = -1;         /* Ingore this one */
    }
#line 4183 "parser.c" /* yacc.c:1646  */
    break;

  case 40:
#line 805 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = UOP_neg;
    }
#line 4191 "parser.c" /* yacc.c:1646  */
    break;

  case 41:
#line 809 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = UOP_bnot;
    }
#line 4199 "parser.c" /* yacc.c:1646  */
    break;

  case 42:
#line 813 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = UOP_lnot;
    }
#line 4207 "parser.c" /* yacc.c:1646  */
    break;

  case 43:
#line 821 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4215 "parser.c" /* yacc.c:1646  */
    break;

  case 44:
#line 825 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CastedExpr((yyvsp[-2].decl), (yyvsp[0].expr));
    }
#line 4223 "parser.c" /* yacc.c:1646  */
    break;

  case 45:
#line 833 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4231 "parser.c" /* yacc.c:1646  */
    break;

  case 46:
#line 837 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_mul, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4239 "parser.c" /* yacc.c:1646  */
    break;

  case 47:
#line 841 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_div, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4247 "parser.c" /* yacc.c:1646  */
    break;

  case 48:
#line 845 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_mod, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4255 "parser.c" /* yacc.c:1646  */
    break;

  case 49:
#line 853 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4263 "parser.c" /* yacc.c:1646  */
    break;

  case 50:
#line 857 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_add, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4271 "parser.c" /* yacc.c:1646  */
    break;

  case 51:
#line 861 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_sub, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4279 "parser.c" /* yacc.c:1646  */
    break;

  case 52:
#line 869 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4287 "parser.c" /* yacc.c:1646  */
    break;

  case 53:
#line 873 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_shl, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4295 "parser.c" /* yacc.c:1646  */
    break;

  case 54:
#line 877 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_shr, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4303 "parser.c" /* yacc.c:1646  */
    break;

  case 55:
#line 885 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4311 "parser.c" /* yacc.c:1646  */
    break;

  case 56:
#line 889 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_lt, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4319 "parser.c" /* yacc.c:1646  */
    break;

  case 57:
#line 893 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_gt, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4327 "parser.c" /* yacc.c:1646  */
    break;

  case 58:
#line 897 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_leq, (yyvsp[-2].expr), (yyvsp[0].expr));
     }
#line 4335 "parser.c" /* yacc.c:1646  */
    break;

  case 59:
#line 901 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_geq, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4343 "parser.c" /* yacc.c:1646  */
    break;

  case 60:
#line 909 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4351 "parser.c" /* yacc.c:1646  */
    break;

  case 61:
#line 913 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_eqeq, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4359 "parser.c" /* yacc.c:1646  */
    break;

  case 62:
#line 917 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_neq, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4367 "parser.c" /* yacc.c:1646  */
    break;

  case 63:
#line 925 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4375 "parser.c" /* yacc.c:1646  */
    break;

  case 64:
#line 929 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_band, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4383 "parser.c" /* yacc.c:1646  */
    break;

  case 65:
#line 937 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4391 "parser.c" /* yacc.c:1646  */
    break;

  case 66:
#line 941 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_xor, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4399 "parser.c" /* yacc.c:1646  */
    break;

  case 67:
#line 949 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4407 "parser.c" /* yacc.c:1646  */
    break;

  case 68:
#line 953 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_bor, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4415 "parser.c" /* yacc.c:1646  */
    break;

  case 69:
#line 961 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4423 "parser.c" /* yacc.c:1646  */
    break;

  case 70:
#line 965 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_land, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4431 "parser.c" /* yacc.c:1646  */
    break;

  case 71:
#line 973 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4439 "parser.c" /* yacc.c:1646  */
    break;

  case 72:
#line 977 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BinaryOperator(BOP_lor, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4447 "parser.c" /* yacc.c:1646  */
    break;

  case 73:
#line 985 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4455 "parser.c" /* yacc.c:1646  */
    break;

  case 74:
#line 989 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = ConditionalExpr((yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4463 "parser.c" /* yacc.c:1646  */
    break;

  case 75:
#line 997 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4471 "parser.c" /* yacc.c:1646  */
    break;

  case 76:
#line 1001 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = Assignment((yyvsp[-2].expr), (yyvsp[-1].type), (yyvsp[0].expr));
    }
#line 4479 "parser.c" /* yacc.c:1646  */
    break;

  case 77:
#line 1009 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_eq;  /* Need fix here! */
    }
#line 4487 "parser.c" /* yacc.c:1646  */
    break;

  case 78:
#line 1013 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_mul;
    }
#line 4495 "parser.c" /* yacc.c:1646  */
    break;

  case 79:
#line 1017 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_div;
    }
#line 4503 "parser.c" /* yacc.c:1646  */
    break;

  case 80:
#line 1021 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_mod;
    }
#line 4511 "parser.c" /* yacc.c:1646  */
    break;

  case 81:
#line 1025 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_add;
    }
#line 4519 "parser.c" /* yacc.c:1646  */
    break;

  case 82:
#line 1029 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_sub;
    }
#line 4527 "parser.c" /* yacc.c:1646  */
    break;

  case 83:
#line 1033 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_shl;
    }
#line 4535 "parser.c" /* yacc.c:1646  */
    break;

  case 84:
#line 1037 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_shr;
    }
#line 4543 "parser.c" /* yacc.c:1646  */
    break;

  case 85:
#line 1041 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_and;
    }
#line 4551 "parser.c" /* yacc.c:1646  */
    break;

  case 86:
#line 1045 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_xor;
    }
#line 4559 "parser.c" /* yacc.c:1646  */
    break;

  case 87:
#line 1049 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = ASS_or;
    }
#line 4567 "parser.c" /* yacc.c:1646  */
    break;

  case 88:
#line 1057 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4575 "parser.c" /* yacc.c:1646  */
    break;

  case 89:
#line 1061 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4583 "parser.c" /* yacc.c:1646  */
    break;

  case 90:
#line 1069 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4591 "parser.c" /* yacc.c:1646  */
    break;

  case 91:
#line 1083 "parser.y" /* yacc.c:1646  */
    {
      /* There is a special case which wrongly uses this rule:
       *   typedef xxx already_known_user_type.
       * In this case the already_known_user_type (T) is re-defined,
       * and because T is known, it is not considered as a declarator,
       * but a "typedef_name", and is part of the specifier.
       * We fix it here.
       */
      if (isTypedef && (yyvsp[-1].spec)->type == SPECLIST)
        (yyval.stmt) = Declaration((yyvsp[-1].spec), fix_known_typename((yyvsp[-1].spec)));
      else
        (yyval.stmt) = Declaration((yyvsp[-1].spec), NULL);
      isTypedef = 0;
    }
#line 4610 "parser.c" /* yacc.c:1646  */
    break;

  case 92:
#line 1098 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Declaration((yyvsp[-2].spec), (yyvsp[-1].decl));
      if (checkDecls) add_declaration_links((yyvsp[-2].spec), (yyvsp[-1].decl));
      isTypedef = 0;

    }
#line 4621 "parser.c" /* yacc.c:1646  */
    break;

  case 93:
#line 1105 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpStmt(OmpConstruct(DCTHREADPRIVATE, (yyvsp[0].odir), NULL));
    }
#line 4629 "parser.c" /* yacc.c:1646  */
    break;

  case 94:
#line 1110 "parser.y" /* yacc.c:1646  */
    {
      //$$ = OmpStmt(OmpConstruct(DCTHREADPRIVATE, $1, NULL)); TODO
    }
#line 4637 "parser.c" /* yacc.c:1646  */
    break;

  case 95:
#line 1114 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
    }
#line 4645 "parser.c" /* yacc.c:1646  */
    break;

  case 96:
#line 1118 "parser.y" /* yacc.c:1646  */
    {
      //$$ = OmpStmt(OmpConstruct(DCTHREADPRIVATE, $1, NULL)); TODO
    }
#line 4653 "parser.c" /* yacc.c:1646  */
    break;

  case 97:
#line 1126 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 4661 "parser.c" /* yacc.c:1646  */
    break;

  case 98:
#line 1130 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 4669 "parser.c" /* yacc.c:1646  */
    break;

  case 99:
#line 1134 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 4677 "parser.c" /* yacc.c:1646  */
    break;

  case 100:
#line 1138 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 4685 "parser.c" /* yacc.c:1646  */
    break;

  case 101:
#line 1142 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 4693 "parser.c" /* yacc.c:1646  */
    break;

  case 102:
#line 1146 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 4701 "parser.c" /* yacc.c:1646  */
    break;

  case 103:
#line 1150 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 4709 "parser.c" /* yacc.c:1646  */
    break;

  case 104:
#line 1154 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 4717 "parser.c" /* yacc.c:1646  */
    break;

  case 105:
#line 1162 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 4725 "parser.c" /* yacc.c:1646  */
    break;

  case 106:
#line 1166 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = DeclList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 4733 "parser.c" /* yacc.c:1646  */
    break;

  case 107:
#line 1180 "parser.y" /* yacc.c:1646  */
    {
      astdecl s = decl_getidentifier((yyvsp[0].decl));
      int     declkind = decl_getkind((yyvsp[0].decl));
      stentry e;

      if (!isTypedef && declkind == DFUNC && strcmp(s->u.id->name, "main") == 0)
        s->u.id = Symbol(MAIN_NEWNAME);       /* Catch main()'s declaration */
      if (checkDecls)
      {
        e = symtab_put(stab, s->u.id, (isTypedef) ? TYPENAME :
                                       (declkind == DFUNC) ? FUNCNAME : IDNAME);
        e->isarray = (declkind == DARRAY);
      }
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 4753 "parser.c" /* yacc.c:1646  */
    break;

  case 108:
#line 1196 "parser.y" /* yacc.c:1646  */
    {
      astdecl s = decl_getidentifier((yyvsp[-1].decl));
      int     declkind = decl_getkind((yyvsp[-1].decl));
      stentry e;

      if (!isTypedef && declkind == DFUNC && strcmp(s->u.id->name, "main") == 0)
        s->u.id = Symbol(MAIN_NEWNAME);         /* Catch main()'s declaration */
      if (checkDecls)
      {
        e = symtab_put(stab, s->u.id, (isTypedef) ? TYPENAME :
                                       (declkind == DFUNC) ? FUNCNAME : IDNAME);
        e->isarray = (declkind == DARRAY);
      }
    }
#line 4772 "parser.c" /* yacc.c:1646  */
    break;

  case 109:
#line 1211 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = InitDecl((yyvsp[-3].decl), (yyvsp[0].expr));
    }
#line 4780 "parser.c" /* yacc.c:1646  */
    break;

  case 110:
#line 1219 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = StClassSpec(SPEC_typedef);    /* Just a string */
      isTypedef = 1;
    }
#line 4789 "parser.c" /* yacc.c:1646  */
    break;

  case 111:
#line 1224 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = StClassSpec(SPEC_extern);
    }
#line 4797 "parser.c" /* yacc.c:1646  */
    break;

  case 112:
#line 1228 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = StClassSpec(SPEC_static);
    }
#line 4805 "parser.c" /* yacc.c:1646  */
    break;

  case 113:
#line 1232 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = StClassSpec(SPEC_auto);
    }
#line 4813 "parser.c" /* yacc.c:1646  */
    break;

  case 114:
#line 1236 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = StClassSpec(SPEC_register);
    }
#line 4821 "parser.c" /* yacc.c:1646  */
    break;

  case 115:
#line 1244 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_void);
    }
#line 4829 "parser.c" /* yacc.c:1646  */
    break;

  case 116:
#line 1248 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_char);
    }
#line 4837 "parser.c" /* yacc.c:1646  */
    break;

  case 117:
#line 1252 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_short);
    }
#line 4845 "parser.c" /* yacc.c:1646  */
    break;

  case 118:
#line 1256 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_int);
    }
#line 4853 "parser.c" /* yacc.c:1646  */
    break;

  case 119:
#line 1260 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_long);
    }
#line 4861 "parser.c" /* yacc.c:1646  */
    break;

  case 120:
#line 1264 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_float);
    }
#line 4869 "parser.c" /* yacc.c:1646  */
    break;

  case 121:
#line 1268 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_double);
    }
#line 4877 "parser.c" /* yacc.c:1646  */
    break;

  case 122:
#line 1272 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_signed);
    }
#line 4885 "parser.c" /* yacc.c:1646  */
    break;

  case 123:
#line 1276 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_unsigned);
    }
#line 4893 "parser.c" /* yacc.c:1646  */
    break;

  case 124:
#line 1280 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_ubool);
    }
#line 4901 "parser.c" /* yacc.c:1646  */
    break;

  case 125:
#line 1284 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_ucomplex);
    }
#line 4909 "parser.c" /* yacc.c:1646  */
    break;

  case 126:
#line 1288 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_uimaginary);
    }
#line 4917 "parser.c" /* yacc.c:1646  */
    break;

  case 127:
#line 1292 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 4925 "parser.c" /* yacc.c:1646  */
    break;

  case 128:
#line 1296 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 4933 "parser.c" /* yacc.c:1646  */
    break;

  case 129:
#line 1300 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Usertype((yyvsp[0].symb));
    }
#line 4941 "parser.c" /* yacc.c:1646  */
    break;

  case 130:
#line 1309 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = SUdecl((yyvsp[-4].type), NULL, (yyvsp[-1].decl), (yyvsp[-3].spec));
    }
#line 4949 "parser.c" /* yacc.c:1646  */
    break;

  case 131:
#line 1313 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = SUdecl((yyvsp[-3].type), NULL, NULL, (yyvsp[-2].spec));
    }
#line 4957 "parser.c" /* yacc.c:1646  */
    break;

  case 132:
#line 1317 "parser.y" /* yacc.c:1646  */
    {
      symbol s = Symbol((yyvsp[-3].name));
      /* Well, struct & union names have their own name space, and
       * their own scopes. I.e. they can be re-declare in nested
       * scopes. We don't do any kind of duplicate checks.
       */
      if (checkDecls)
        symtab_put(stab, s, SUNAME);
      (yyval.spec) = SUdecl((yyvsp[-5].type), s, (yyvsp[-1].decl), (yyvsp[-4].spec));
    }
#line 4972 "parser.c" /* yacc.c:1646  */
    break;

  case 133:
#line 1332 "parser.y" /* yacc.c:1646  */
    {
      symbol s = (yyvsp[-3].symb);
      if (checkDecls)
        symtab_put(stab, s, SUNAME);
      (yyval.spec) = SUdecl((yyvsp[-5].type), s, (yyvsp[-1].decl), (yyvsp[-4].spec));
    }
#line 4983 "parser.c" /* yacc.c:1646  */
    break;

  case 134:
#line 1339 "parser.y" /* yacc.c:1646  */
    {
      symbol s = Symbol((yyvsp[0].name));
      if (checkDecls)
        symtab_put(stab, s, SUNAME);
      (yyval.spec) = SUdecl((yyvsp[-2].type), s, NULL, (yyvsp[-1].spec));
    }
#line 4994 "parser.c" /* yacc.c:1646  */
    break;

  case 135:
#line 1346 "parser.y" /* yacc.c:1646  */
    {
      symbol s = (yyvsp[0].symb);
      if (checkDecls)
        symtab_put(stab, s, SUNAME);
      (yyval.spec) = SUdecl((yyvsp[-2].type), s, NULL, (yyvsp[-1].spec));
    }
#line 5005 "parser.c" /* yacc.c:1646  */
    break;

  case 136:
#line 1357 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = SPEC_struct;
    }
#line 5013 "parser.c" /* yacc.c:1646  */
    break;

  case 137:
#line 1361 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = SPEC_union;
    }
#line 5021 "parser.c" /* yacc.c:1646  */
    break;

  case 138:
#line 1369 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 5029 "parser.c" /* yacc.c:1646  */
    break;

  case 139:
#line 1373 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = StructfieldList((yyvsp[-1].decl), (yyvsp[0].decl));
    }
#line 5037 "parser.c" /* yacc.c:1646  */
    break;

  case 140:
#line 1381 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = StructfieldDecl((yyvsp[-2].spec), (yyvsp[-1].decl));
    }
#line 5045 "parser.c" /* yacc.c:1646  */
    break;

  case 141:
#line 1385 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = StructfieldDecl((yyvsp[-1].spec), NULL);
    }
#line 5053 "parser.c" /* yacc.c:1646  */
    break;

  case 142:
#line 1393 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 5061 "parser.c" /* yacc.c:1646  */
    break;

  case 143:
#line 1397 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5069 "parser.c" /* yacc.c:1646  */
    break;

  case 144:
#line 1401 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 5077 "parser.c" /* yacc.c:1646  */
    break;

  case 145:
#line 1405 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5085 "parser.c" /* yacc.c:1646  */
    break;

  case 146:
#line 1413 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 5093 "parser.c" /* yacc.c:1646  */
    break;

  case 147:
#line 1417 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = DeclList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 5101 "parser.c" /* yacc.c:1646  */
    break;

  case 148:
#line 1425 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 5109 "parser.c" /* yacc.c:1646  */
    break;

  case 149:
#line 1429 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = BitDecl((yyvsp[-2].decl), (yyvsp[0].expr));
    }
#line 5117 "parser.c" /* yacc.c:1646  */
    break;

  case 150:
#line 1433 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = BitDecl(NULL, (yyvsp[0].expr));
    }
#line 5125 "parser.c" /* yacc.c:1646  */
    break;

  case 151:
#line 1441 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Enumdecl(NULL, (yyvsp[-1].spec), (yyvsp[-3].spec));
    }
#line 5133 "parser.c" /* yacc.c:1646  */
    break;

  case 152:
#line 1445 "parser.y" /* yacc.c:1646  */
    {
      symbol s = Symbol((yyvsp[-3].name));

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", (yyvsp[-3].name));
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-1].spec), (yyvsp[-4].spec));
    }
#line 5149 "parser.c" /* yacc.c:1646  */
    break;

  case 153:
#line 1458 "parser.y" /* yacc.c:1646  */
    {
      symbol s = (yyvsp[-3].symb);

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", s->name);
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-1].spec), (yyvsp[-4].spec));
    }
#line 5165 "parser.c" /* yacc.c:1646  */
    break;

  case 154:
#line 1470 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Enumdecl(NULL, (yyvsp[-2].spec), (yyvsp[-4].spec));
    }
#line 5173 "parser.c" /* yacc.c:1646  */
    break;

  case 155:
#line 1474 "parser.y" /* yacc.c:1646  */
    {
      symbol s = Symbol((yyvsp[-4].name));

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", (yyvsp[-4].name));
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-2].spec), (yyvsp[-5].spec));
    }
#line 5189 "parser.c" /* yacc.c:1646  */
    break;

  case 156:
#line 1486 "parser.y" /* yacc.c:1646  */
    {
      symbol s = (yyvsp[-4].symb);

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", s->name);
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-2].spec), (yyvsp[-5].spec));
    }
#line 5205 "parser.c" /* yacc.c:1646  */
    break;

  case 157:
#line 1498 "parser.y" /* yacc.c:1646  */
    {
      /*
      if (symtab_get(stab, s, ENUMNAME))
        parse_error(-1, "enum name '%s' is unknown.", $2);
      */
      (yyval.spec) = Enumdecl(Symbol((yyvsp[0].name)), NULL, (yyvsp[-1].spec));
    }
#line 5217 "parser.c" /* yacc.c:1646  */
    break;

  case 158:
#line 1506 "parser.y" /* yacc.c:1646  */
    {
      /*
      if (symtab_get(stab, s, ENUMNAME))
        parse_error(-1, "enum name '%s' is unknown.", $2);
      */
      (yyval.spec) = Enumdecl((yyvsp[0].symb), NULL, (yyvsp[-1].spec));
    }
#line 5229 "parser.c" /* yacc.c:1646  */
    break;

  case 159:
#line 1518 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 5237 "parser.c" /* yacc.c:1646  */
    break;

  case 160:
#line 1522 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Enumbodylist((yyvsp[-2].spec), (yyvsp[0].spec));
    }
#line 5245 "parser.c" /* yacc.c:1646  */
    break;

  case 161:
#line 1530 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Enumerator((yyvsp[0].symb), NULL);
    }
#line 5253 "parser.c" /* yacc.c:1646  */
    break;

  case 162:
#line 1534 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Enumerator((yyvsp[-2].symb), (yyvsp[0].expr));
    }
#line 5261 "parser.c" /* yacc.c:1646  */
    break;

  case 163:
#line 1542 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_const);
    }
#line 5269 "parser.c" /* yacc.c:1646  */
    break;

  case 164:
#line 1546 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_restrict);
    }
#line 5277 "parser.c" /* yacc.c:1646  */
    break;

  case 165:
#line 1550 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_volatile);
    }
#line 5285 "parser.c" /* yacc.c:1646  */
    break;

  case 166:
#line 1554 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 5293 "parser.c" /* yacc.c:1646  */
    break;

  case 167:
#line 1562 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Declspec(SPEC_inline);
    }
#line 5301 "parser.c" /* yacc.c:1646  */
    break;

  case 168:
#line 1570 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = Declarator(NULL, (yyvsp[0].decl));
    }
#line 5309 "parser.c" /* yacc.c:1646  */
    break;

  case 169:
#line 1574 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = Declarator((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 5317 "parser.c" /* yacc.c:1646  */
    break;

  case 170:
#line 1587 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 5325 "parser.c" /* yacc.c:1646  */
    break;

  case 171:
#line 1591 "parser.y" /* yacc.c:1646  */
    {
      /* Try to simplify a bit: (ident) -> ident */
      if ((yyvsp[-1].decl)->spec == NULL && (yyvsp[-1].decl)->decl->type == DIDENT)
        (yyval.decl) = (yyvsp[-1].decl)->decl;
      else
        (yyval.decl) = ParenDecl((yyvsp[-1].decl));
    }
#line 5337 "parser.c" /* yacc.c:1646  */
    break;

  case 172:
#line 1599 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-2].decl), NULL, NULL);
    }
#line 5345 "parser.c" /* yacc.c:1646  */
    break;

  case 173:
#line 1603 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), (yyvsp[-1].spec), NULL);
    }
#line 5353 "parser.c" /* yacc.c:1646  */
    break;

  case 174:
#line 1607 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), NULL, (yyvsp[-1].expr));
    }
#line 5361 "parser.c" /* yacc.c:1646  */
    break;

  case 175:
#line 1611 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-4].decl), (yyvsp[-2].spec), (yyvsp[-1].expr));
    }
#line 5369 "parser.c" /* yacc.c:1646  */
    break;

  case 176:
#line 1615 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-4].decl), StClassSpec(SPEC_static), (yyvsp[-1].expr));
    }
#line 5377 "parser.c" /* yacc.c:1646  */
    break;

  case 177:
#line 1619 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-5].decl), Speclist_right( StClassSpec(SPEC_static), (yyvsp[-2].spec) ), (yyvsp[-1].expr));
    }
#line 5385 "parser.c" /* yacc.c:1646  */
    break;

  case 178:
#line 1623 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-5].decl), Speclist_left( (yyvsp[-3].spec), StClassSpec(SPEC_static) ), (yyvsp[-1].expr));
    }
#line 5393 "parser.c" /* yacc.c:1646  */
    break;

  case 179:
#line 1627 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), Declspec(SPEC_star), NULL);
    }
#line 5401 "parser.c" /* yacc.c:1646  */
    break;

  case 180:
#line 1631 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-4].decl), Speclist_left( (yyvsp[-2].spec), Declspec(SPEC_star) ), NULL);
    }
#line 5409 "parser.c" /* yacc.c:1646  */
    break;

  case 181:
#line 1635 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl((yyvsp[-3].decl), (yyvsp[-1].decl));
    }
#line 5417 "parser.c" /* yacc.c:1646  */
    break;

  case 182:
#line 1639 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl((yyvsp[-2].decl), NULL);
    }
#line 5425 "parser.c" /* yacc.c:1646  */
    break;

  case 183:
#line 1643 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl((yyvsp[-3].decl), (yyvsp[-1].decl));
    }
#line 5433 "parser.c" /* yacc.c:1646  */
    break;

  case 184:
#line 1651 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Pointer();
    }
#line 5441 "parser.c" /* yacc.c:1646  */
    break;

  case 185:
#line 1655 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right(Pointer(), (yyvsp[0].spec));
    }
#line 5449 "parser.c" /* yacc.c:1646  */
    break;

  case 186:
#line 1659 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right(Pointer(), (yyvsp[0].spec));
    }
#line 5457 "parser.c" /* yacc.c:1646  */
    break;

  case 187:
#line 1663 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right( Pointer(), Speclist_left((yyvsp[-1].spec), (yyvsp[0].spec)) );
    }
#line 5465 "parser.c" /* yacc.c:1646  */
    break;

  case 188:
#line 1671 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 5473 "parser.c" /* yacc.c:1646  */
    break;

  case 189:
#line 1675 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_left((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5481 "parser.c" /* yacc.c:1646  */
    break;

  case 190:
#line 1683 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 5489 "parser.c" /* yacc.c:1646  */
    break;

  case 191:
#line 1687 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ParamList((yyvsp[-2].decl), Ellipsis());
    }
#line 5497 "parser.c" /* yacc.c:1646  */
    break;

  case 192:
#line 1695 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 5505 "parser.c" /* yacc.c:1646  */
    break;

  case 193:
#line 1699 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ParamList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 5513 "parser.c" /* yacc.c:1646  */
    break;

  case 194:
#line 1707 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ParamDecl((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 5521 "parser.c" /* yacc.c:1646  */
    break;

  case 195:
#line 1711 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ParamDecl((yyvsp[0].spec), NULL);
    }
#line 5529 "parser.c" /* yacc.c:1646  */
    break;

  case 196:
#line 1715 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ParamDecl((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 5537 "parser.c" /* yacc.c:1646  */
    break;

  case 197:
#line 1723 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 5545 "parser.c" /* yacc.c:1646  */
    break;

  case 198:
#line 1727 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 5553 "parser.c" /* yacc.c:1646  */
    break;

  case 199:
#line 1735 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = Casttypename((yyvsp[0].spec), NULL);
    }
#line 5561 "parser.c" /* yacc.c:1646  */
    break;

  case 200:
#line 1739 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = Casttypename((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 5569 "parser.c" /* yacc.c:1646  */
    break;

  case 201:
#line 1747 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = AbstractDeclarator((yyvsp[0].spec), NULL);
    }
#line 5577 "parser.c" /* yacc.c:1646  */
    break;

  case 202:
#line 1751 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = AbstractDeclarator(NULL, (yyvsp[0].decl));
    }
#line 5585 "parser.c" /* yacc.c:1646  */
    break;

  case 203:
#line 1755 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = AbstractDeclarator((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 5593 "parser.c" /* yacc.c:1646  */
    break;

  case 204:
#line 1763 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ParenDecl((yyvsp[-1].decl));
    }
#line 5601 "parser.c" /* yacc.c:1646  */
    break;

  case 205:
#line 1767 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl(NULL, NULL, NULL);
    }
#line 5609 "parser.c" /* yacc.c:1646  */
    break;

  case 206:
#line 1771 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-2].decl), NULL, NULL);
    }
#line 5617 "parser.c" /* yacc.c:1646  */
    break;

  case 207:
#line 1775 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl(NULL, NULL, (yyvsp[-1].expr));
    }
#line 5625 "parser.c" /* yacc.c:1646  */
    break;

  case 208:
#line 1779 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), NULL, (yyvsp[-1].expr));
    }
#line 5633 "parser.c" /* yacc.c:1646  */
    break;

  case 209:
#line 1783 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl(NULL, Declspec(SPEC_star), NULL);
    }
#line 5641 "parser.c" /* yacc.c:1646  */
    break;

  case 210:
#line 1787 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), Declspec(SPEC_star), NULL);
    }
#line 5649 "parser.c" /* yacc.c:1646  */
    break;

  case 211:
#line 1791 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl(NULL, NULL);
    }
#line 5657 "parser.c" /* yacc.c:1646  */
    break;

  case 212:
#line 1795 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl((yyvsp[-2].decl), NULL);
    }
#line 5665 "parser.c" /* yacc.c:1646  */
    break;

  case 213:
#line 1799 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl(NULL, (yyvsp[-1].decl));
    }
#line 5673 "parser.c" /* yacc.c:1646  */
    break;

  case 214:
#line 1803 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = FuncDecl((yyvsp[-3].decl), (yyvsp[-1].decl));
    }
#line 5681 "parser.c" /* yacc.c:1646  */
    break;

  case 215:
#line 1811 "parser.y" /* yacc.c:1646  */
    {
      (yyval.symb) = Symbol((yyvsp[0].name));
    }
#line 5689 "parser.c" /* yacc.c:1646  */
    break;

  case 216:
#line 1819 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 5697 "parser.c" /* yacc.c:1646  */
    break;

  case 217:
#line 1823 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BracedInitializer((yyvsp[-1].expr));
    }
#line 5705 "parser.c" /* yacc.c:1646  */
    break;

  case 218:
#line 1827 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = BracedInitializer((yyvsp[-2].expr));
    }
#line 5713 "parser.c" /* yacc.c:1646  */
    break;

  case 219:
#line 1835 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 5721 "parser.c" /* yacc.c:1646  */
    break;

  case 220:
#line 1839 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = Designated((yyvsp[-1].expr), (yyvsp[0].expr));
    }
#line 5729 "parser.c" /* yacc.c:1646  */
    break;

  case 221:
#line 1843 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 5737 "parser.c" /* yacc.c:1646  */
    break;

  case 222:
#line 1847 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = CommaList((yyvsp[-3].expr), Designated((yyvsp[-1].expr), (yyvsp[0].expr)));
    }
#line 5745 "parser.c" /* yacc.c:1646  */
    break;

  case 223:
#line 1855 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[-1].expr);
    }
#line 5753 "parser.c" /* yacc.c:1646  */
    break;

  case 224:
#line 1863 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 5761 "parser.c" /* yacc.c:1646  */
    break;

  case 225:
#line 1867 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = SpaceList((yyvsp[-1].expr), (yyvsp[0].expr));
    }
#line 5769 "parser.c" /* yacc.c:1646  */
    break;

  case 226:
#line 1875 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = IdxDesignator((yyvsp[-1].expr));
    }
#line 5777 "parser.c" /* yacc.c:1646  */
    break;

  case 227:
#line 1879 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = DotDesignator( Symbol((yyvsp[0].name)) );
    }
#line 5785 "parser.c" /* yacc.c:1646  */
    break;

  case 228:
#line 1883 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = DotDesignator((yyvsp[0].symb));
    }
#line 5793 "parser.c" /* yacc.c:1646  */
    break;

  case 229:
#line 1897 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5801 "parser.c" /* yacc.c:1646  */
    break;

  case 230:
#line 1901 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5809 "parser.c" /* yacc.c:1646  */
    break;

  case 231:
#line 1905 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5817 "parser.c" /* yacc.c:1646  */
    break;

  case 232:
#line 1909 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5825 "parser.c" /* yacc.c:1646  */
    break;

  case 233:
#line 1913 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5833 "parser.c" /* yacc.c:1646  */
    break;

  case 234:
#line 1917 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5841 "parser.c" /* yacc.c:1646  */
    break;

  case 235:
#line 1921 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5849 "parser.c" /* yacc.c:1646  */
    break;

  case 236:
#line 1925 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
      (yyval.stmt)->l = (yyvsp[0].ocon)->l;
    }
#line 5858 "parser.c" /* yacc.c:1646  */
    break;

  case 237:
#line 1930 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
        (yyval.stmt)->l = (yyvsp[0].xcon)->l;
      #else
        if ((yyvsp[0].xcon)->type==OX_DCTAG){
          parse_warning("tag construct ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.stmt) = (yyvsp[0].xcon)->body;
        } else {
          (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
          (yyval.stmt)->l = (yyvsp[0].xcon)->l;
        }
      #endif
    }
#line 5878 "parser.c" /* yacc.c:1646  */
    break;

  case 238:
#line 1946 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Verbatim(strdup((yyvsp[0].name)));
    }
#line 5886 "parser.c" /* yacc.c:1646  */
    break;

  case 239:
#line 1954 "parser.y" /* yacc.c:1646  */
    { 
      (yyval.stmt) = (yyvsp[0].stmt); 
    }
#line 5894 "parser.c" /* yacc.c:1646  */
    break;

  case 240:
#line 1958 "parser.y" /* yacc.c:1646  */
    {       
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
      (yyval.stmt)->l = (yyvsp[0].ocon)->l;
    }
#line 5903 "parser.c" /* yacc.c:1646  */
    break;

  case 241:
#line 1968 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Labeled( Symbol((yyvsp[-3].name)), (yyvsp[0].stmt) );
    }
#line 5911 "parser.c" /* yacc.c:1646  */
    break;

  case 242:
#line 1972 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Case((yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 5919 "parser.c" /* yacc.c:1646  */
    break;

  case 243:
#line 1976 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Default((yyvsp[0].stmt));
    }
#line 5927 "parser.c" /* yacc.c:1646  */
    break;

  case 244:
#line 1984 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Compound(NULL);
    }
#line 5935 "parser.c" /* yacc.c:1646  */
    break;

  case 245:
#line 1987 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = sc_original_line()-1; scope_start(stab); }
#line 5941 "parser.c" /* yacc.c:1646  */
    break;

  case 246:
#line 1989 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Compound((yyvsp[-1].stmt));
      scope_end(stab);
      (yyval.stmt)->l = (yyvsp[-2].type);     /* Remember 1st line */
    }
#line 5951 "parser.c" /* yacc.c:1646  */
    break;

  case 247:
#line 1999 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5959 "parser.c" /* yacc.c:1646  */
    break;

  case 248:
#line 2003 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));
      (yyval.stmt)->l = (yyvsp[-1].stmt)->l;
    }
#line 5968 "parser.c" /* yacc.c:1646  */
    break;

  case 249:
#line 2012 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5976 "parser.c" /* yacc.c:1646  */
    break;

  case 250:
#line 2016 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 5984 "parser.c" /* yacc.c:1646  */
    break;

  case 251:
#line 2020 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
      (yyval.stmt)->l = (yyvsp[0].ocon)->l;
    }
#line 5993 "parser.c" /* yacc.c:1646  */
    break;

  case 252:
#line 2025 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
      (yyval.stmt)->l = (yyvsp[0].xcon)->l;
    }
#line 6002 "parser.c" /* yacc.c:1646  */
    break;

  case 253:
#line 2034 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Expression(NULL);
    }
#line 6010 "parser.c" /* yacc.c:1646  */
    break;

  case 254:
#line 2038 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Expression((yyvsp[-1].expr));
      (yyval.stmt)->l = (yyvsp[-1].expr)->l;
    }
#line 6019 "parser.c" /* yacc.c:1646  */
    break;

  case 255:
#line 2047 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = If((yyvsp[-2].expr), (yyvsp[0].stmt), NULL);
    }
#line 6027 "parser.c" /* yacc.c:1646  */
    break;

  case 256:
#line 2051 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = If((yyvsp[-4].expr), (yyvsp[-2].stmt), (yyvsp[0].stmt));
    }
#line 6035 "parser.c" /* yacc.c:1646  */
    break;

  case 257:
#line 2055 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Switch((yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6043 "parser.c" /* yacc.c:1646  */
    break;

  case 258:
#line 2064 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = While((yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6051 "parser.c" /* yacc.c:1646  */
    break;

  case 259:
#line 2068 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Do((yyvsp[-5].stmt), (yyvsp[-2].expr));
    }
#line 6059 "parser.c" /* yacc.c:1646  */
    break;

  case 261:
#line 2076 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(NULL, NULL, NULL, (yyvsp[0].stmt));
    }
#line 6067 "parser.c" /* yacc.c:1646  */
    break;

  case 262:
#line 2080 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(Expression((yyvsp[-4].expr)), NULL, NULL, (yyvsp[0].stmt));
    }
#line 6075 "parser.c" /* yacc.c:1646  */
    break;

  case 263:
#line 2084 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(NULL, (yyvsp[-3].expr), NULL, (yyvsp[0].stmt));
    }
#line 6083 "parser.c" /* yacc.c:1646  */
    break;

  case 264:
#line 2088 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(NULL, NULL, (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6091 "parser.c" /* yacc.c:1646  */
    break;

  case 265:
#line 2092 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(Expression((yyvsp[-5].expr)), (yyvsp[-3].expr), NULL, (yyvsp[0].stmt));
    }
#line 6099 "parser.c" /* yacc.c:1646  */
    break;

  case 266:
#line 2096 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(Expression((yyvsp[-5].expr)), NULL, (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6107 "parser.c" /* yacc.c:1646  */
    break;

  case 267:
#line 2100 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(NULL, (yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6115 "parser.c" /* yacc.c:1646  */
    break;

  case 268:
#line 2104 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For(Expression((yyvsp[-6].expr)), (yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6123 "parser.c" /* yacc.c:1646  */
    break;

  case 269:
#line 2108 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For((yyvsp[-3].stmt), NULL, NULL, (yyvsp[0].stmt));
    }
#line 6131 "parser.c" /* yacc.c:1646  */
    break;

  case 270:
#line 2112 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For((yyvsp[-4].stmt), (yyvsp[-3].expr), NULL, (yyvsp[0].stmt));
    }
#line 6139 "parser.c" /* yacc.c:1646  */
    break;

  case 271:
#line 2116 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For((yyvsp[-4].stmt), NULL, (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6147 "parser.c" /* yacc.c:1646  */
    break;

  case 272:
#line 2120 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = For((yyvsp[-5].stmt), (yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6155 "parser.c" /* yacc.c:1646  */
    break;

  case 273:
#line 2128 "parser.y" /* yacc.c:1646  */
    {
      /* We don't keep track of labels -- we leave it to the native compiler */
      (yyval.stmt) = Goto( Symbol((yyvsp[-1].name)) );
    }
#line 6164 "parser.c" /* yacc.c:1646  */
    break;

  case 274:
#line 2133 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Continue();
    }
#line 6172 "parser.c" /* yacc.c:1646  */
    break;

  case 275:
#line 2137 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Break();
    }
#line 6180 "parser.c" /* yacc.c:1646  */
    break;

  case 276:
#line 2141 "parser.y" /* yacc.c:1646  */
    {
      //TODO: simple hack, not 100% correct, does not cover goto
      if (errorOnReturn)
        parse_error(1, "return statement not allowed in an outlined region\n");
      (yyval.stmt) = Return(NULL);
    }
#line 6191 "parser.c" /* yacc.c:1646  */
    break;

  case 277:
#line 2148 "parser.y" /* yacc.c:1646  */
    {
      //TODO: simple hack, not 100% correct, does not cover goto
      if (errorOnReturn)
        parse_error(1, "return statement not allowed in an outlined region\n");
      (yyval.stmt) = Return((yyvsp[-1].expr));
    }
#line 6202 "parser.c" /* yacc.c:1646  */
    break;

  case 278:
#line 2165 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = pastree = (yyvsp[0].stmt);
    }
#line 6210 "parser.c" /* yacc.c:1646  */
    break;

  case 279:
#line 2169 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = pastree = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));
    }
#line 6218 "parser.c" /* yacc.c:1646  */
    break;

  case 280:
#line 2177 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6226 "parser.c" /* yacc.c:1646  */
    break;

  case 281:
#line 2181 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6234 "parser.c" /* yacc.c:1646  */
    break;

  case 282:
#line 2188 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
    }
#line 6242 "parser.c" /* yacc.c:1646  */
    break;

  case 283:
#line 2192 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
    }
#line 6250 "parser.c" /* yacc.c:1646  */
    break;

  case 284:
#line 2196 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Verbatim(strdup((yyvsp[0].name)));
    }
#line 6258 "parser.c" /* yacc.c:1646  */
    break;

  case 285:
#line 2207 "parser.y" /* yacc.c:1646  */
    { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6264 "parser.c" /* yacc.c:1646  */
    break;

  case 286:
#line 2208 "parser.y" /* yacc.c:1646  */
    { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6270 "parser.c" /* yacc.c:1646  */
    break;

  case 287:
#line 2213 "parser.y" /* yacc.c:1646  */
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = (yyvsp[-1].spec);
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      ast_declare_function_params((yyvsp[0].decl));
    }
#line 6293 "parser.c" /* yacc.c:1646  */
    break;

  case 288:
#line 2232 "parser.y" /* yacc.c:1646  */
    {
      scope_end(stab);
      check_for_main_and_declare((yyvsp[-3].spec), (yyvsp[-2].decl));
      (yyval.stmt) = FuncDef((yyvsp[-3].spec), (yyvsp[-2].decl), NULL, (yyvsp[0].stmt));
      symtab_get(stab, decl_getidentifier_symbol((yyvsp[-2].decl)), FUNCNAME)->funcdef = (yyval.stmt);
    }
#line 6304 "parser.c" /* yacc.c:1646  */
    break;

  case 289:
#line 2239 "parser.y" /* yacc.c:1646  */
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = NULL;
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      ast_declare_function_params((yyvsp[0].decl));
    }
#line 6327 "parser.c" /* yacc.c:1646  */
    break;

  case 290:
#line 2258 "parser.y" /* yacc.c:1646  */
    {
      astspec s = Declspec(SPEC_int);  /* return type defaults to "int" */
      stentry f;
      
      scope_end(stab);
      check_for_main_and_declare(s, (yyvsp[-2].decl));
      (yyval.stmt) = FuncDef(s, (yyvsp[-2].decl), NULL, (yyvsp[0].stmt));
      
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[-2].decl)), FUNCNAME);
      if (!f->spec) f->spec = s;
      f->funcdef = (yyval.stmt);
    }
#line 6344 "parser.c" /* yacc.c:1646  */
    break;

  case 291:
#line 2274 "parser.y" /* yacc.c:1646  */
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = (yyvsp[-1].spec);
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      /* Notice here that the function parameters are declared through
       * the declaration_list and we need to do nothing else!
       */
    }
#line 6369 "parser.c" /* yacc.c:1646  */
    break;

  case 292:
#line 2295 "parser.y" /* yacc.c:1646  */
    {
      scope_end(stab);
      check_for_main_and_declare((yyvsp[-4].spec), (yyvsp[-3].decl));
      (yyval.stmt) = FuncDef((yyvsp[-4].spec), (yyvsp[-3].decl), (yyvsp[-1].stmt), (yyvsp[0].stmt));
      symtab_get(stab, decl_getidentifier_symbol((yyvsp[-3].decl)), FUNCNAME)->funcdef = (yyval.stmt);
    }
#line 6380 "parser.c" /* yacc.c:1646  */
    break;

  case 293:
#line 2302 "parser.y" /* yacc.c:1646  */
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = NULL;
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      /* Notice here that the function parameters are declared through
       * the declaration_list and we need to do nothing else!
       */
    }
#line 6405 "parser.c" /* yacc.c:1646  */
    break;

  case 294:
#line 2323 "parser.y" /* yacc.c:1646  */
    {
      astspec s = Declspec(SPEC_int);  /* return type defaults to "int" */
      stentry f;

      scope_end(stab);
      check_for_main_and_declare(s, (yyvsp[-3].decl));
      (yyval.stmt) = FuncDef(s, (yyvsp[-3].decl), (yyvsp[-1].stmt), (yyvsp[0].stmt));
      
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[-3].decl)), FUNCNAME);
      if (!f->spec) f->spec = s;
      f->funcdef = (yyval.stmt);
    }
#line 6422 "parser.c" /* yacc.c:1646  */
    break;

  case 295:
#line 2340 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6430 "parser.c" /* yacc.c:1646  */
    break;

  case 296:
#line 2344 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));         /* Same as block list */
    }
#line 6438 "parser.c" /* yacc.c:1646  */
    break;

  case 297:
#line 2364 "parser.y" /* yacc.c:1646  */
    {
      ((yyval.stmt) = (yyvsp[0].stmt))->u.assem->qualifiers = NULL;
    }
#line 6446 "parser.c" /* yacc.c:1646  */
    break;

  case 298:
#line 2368 "parser.y" /* yacc.c:1646  */
    {
      ((yyval.stmt) = (yyvsp[0].stmt))->u.assem->qualifiers = (yyvsp[-1].spec);
    }
#line 6454 "parser.c" /* yacc.c:1646  */
    break;

  case 299:
#line 2375 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = BasicAsm(NULL, (yyvsp[-1].string));
    }
#line 6462 "parser.c" /* yacc.c:1646  */
    break;

  case 300:
#line 2379 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = XtendAsm(NULL, (yyvsp[-3].string), (yyvsp[-1].asmo), NULL, NULL);
    }
#line 6470 "parser.c" /* yacc.c:1646  */
    break;

  case 301:
#line 2383 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = XtendAsm(NULL, (yyvsp[-5].string), (yyvsp[-3].asmo), (yyvsp[-1].asmo), NULL);
    }
#line 6478 "parser.c" /* yacc.c:1646  */
    break;

  case 302:
#line 2387 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = XtendAsm(NULL, (yyvsp[-7].string), (yyvsp[-5].asmo), (yyvsp[-3].asmo), (yyvsp[-1].expr));
    }
#line 6486 "parser.c" /* yacc.c:1646  */
    break;

  case 303:
#line 2391 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = XtendAsmGoto((yyvsp[-8].string), (yyvsp[-5].asmo), (yyvsp[-3].expr), (yyvsp[-1].expr));
    }
#line 6494 "parser.c" /* yacc.c:1646  */
    break;

  case 304:
#line 2398 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = (yyvsp[0].spec);
    }
#line 6502 "parser.c" /* yacc.c:1646  */
    break;

  case 305:
#line 2402 "parser.y" /* yacc.c:1646  */
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 6510 "parser.c" /* yacc.c:1646  */
    break;

  case 306:
#line 2408 "parser.y" /* yacc.c:1646  */
    { (yyval.spec) = Declspec(SPEC_volatile); }
#line 6516 "parser.c" /* yacc.c:1646  */
    break;

  case 307:
#line 2409 "parser.y" /* yacc.c:1646  */
    { (yyval.spec) = Declspec(SPEC_inline); }
#line 6522 "parser.c" /* yacc.c:1646  */
    break;

  case 308:
#line 2413 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = NULL;
    }
#line 6530 "parser.c" /* yacc.c:1646  */
    break;

  case 309:
#line 2417 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = (yyvsp[0].asmo);
    }
#line 6538 "parser.c" /* yacc.c:1646  */
    break;

  case 310:
#line 2421 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = XAsmOpList((yyvsp[-2].asmo), (yyvsp[0].asmo));
    }
#line 6546 "parser.c" /* yacc.c:1646  */
    break;

  case 311:
#line 2428 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = XAsmOperand(IdentName((yyvsp[-5].name)), (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 6554 "parser.c" /* yacc.c:1646  */
    break;

  case 312:
#line 2432 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = XAsmOperand(NULL, (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 6562 "parser.c" /* yacc.c:1646  */
    break;

  case 313:
#line 2438 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = NULL;
    }
#line 6570 "parser.c" /* yacc.c:1646  */
    break;

  case 314:
#line 2442 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = (yyvsp[0].asmo);
    }
#line 6578 "parser.c" /* yacc.c:1646  */
    break;

  case 315:
#line 2446 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = XAsmOpList((yyvsp[-2].asmo), (yyvsp[0].asmo));
    }
#line 6586 "parser.c" /* yacc.c:1646  */
    break;

  case 316:
#line 2453 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = XAsmOperand(IdentName((yyvsp[-5].name)), (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 6594 "parser.c" /* yacc.c:1646  */
    break;

  case 317:
#line 2457 "parser.y" /* yacc.c:1646  */
    {
      (yyval.asmo) = XAsmOperand(NULL, (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 6602 "parser.c" /* yacc.c:1646  */
    break;

  case 318:
#line 2464 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = String((yyvsp[0].string));
    }
#line 6610 "parser.c" /* yacc.c:1646  */
    break;

  case 319:
#line 2468 "parser.y" /* yacc.c:1646  */
    {
       (yyval.expr) = CommaList((yyvsp[-2].expr), String((yyvsp[0].string)));
    }
#line 6618 "parser.c" /* yacc.c:1646  */
    break;

  case 320:
#line 2475 "parser.y" /* yacc.c:1646  */
    { 
      (yyval.expr) = IdentName((yyvsp[0].name));
    }
#line 6626 "parser.c" /* yacc.c:1646  */
    break;

  case 321:
#line 2479 "parser.y" /* yacc.c:1646  */
    {
       (yyval.expr) = CommaList((yyvsp[-2].expr), IdentName((yyvsp[0].name)));
    }
#line 6634 "parser.c" /* yacc.c:1646  */
    break;

  case 322:
#line 2491 "parser.y" /* yacc.c:1646  */
    {
			(yyval.spec) = NULL;
		}
#line 6642 "parser.c" /* yacc.c:1646  */
    break;

  case 323:
#line 2495 "parser.y" /* yacc.c:1646  */
    {
			(yyval.spec) = (yyvsp[0].spec);
		}
#line 6650 "parser.c" /* yacc.c:1646  */
    break;

  case 324:
#line 2502 "parser.y" /* yacc.c:1646  */
    {
			(yyval.spec) = (yyvsp[0].spec);
		}
#line 6658 "parser.c" /* yacc.c:1646  */
    break;

  case 325:
#line 2506 "parser.y" /* yacc.c:1646  */
    {
			(yyval.spec) = Speclist_left((yyvsp[-1].spec), (yyvsp[0].spec));
		}
#line 6666 "parser.c" /* yacc.c:1646  */
    break;

  case 326:
#line 2513 "parser.y" /* yacc.c:1646  */
    {
			(yyval.spec) = AttrSpec((yyvsp[-2].string));
		}
#line 6674 "parser.c" /* yacc.c:1646  */
    break;

  case 327:
#line 2520 "parser.y" /* yacc.c:1646  */
    {
			(yyval.string) = (yyvsp[0].string);
		}
#line 6682 "parser.c" /* yacc.c:1646  */
    break;

  case 328:
#line 2524 "parser.y" /* yacc.c:1646  */
    {
			if ((yyvsp[-2].string) == NULL && (yyvsp[0].string) == NULL)
				(yyval.string) = strdup(",");
			else
			  if ((yyvsp[-2].string) == NULL)
					(yyval.string) = strdupcat(strdup(", "), (yyvsp[0].string), 1);
				else
					if ((yyvsp[0].string) == NULL)
						(yyval.string) = strdupcat((yyvsp[-2].string), strdup(", "), 1);
					else
						(yyval.string) = strdupcat((yyvsp[-2].string), strdupcat(strdup(", "), (yyvsp[0].string), 1), 1);
		}
#line 6699 "parser.c" /* yacc.c:1646  */
    break;

  case 329:
#line 2540 "parser.y" /* yacc.c:1646  */
    {
			(yyval.string) = NULL;
		}
#line 6707 "parser.c" /* yacc.c:1646  */
    break;

  case 330:
#line 2544 "parser.y" /* yacc.c:1646  */
    {
			(yyval.string) = (yyvsp[0].string);
		}
#line 6715 "parser.c" /* yacc.c:1646  */
    break;

  case 331:
#line 2548 "parser.y" /* yacc.c:1646  */
    {
			static str xp = NULL;
			
			if (xp == NULL) xp = Strnew();
			str_printf(xp, "%s(", (yyvsp[-3].string));
			if ((yyvsp[-1].expr))
				ast_expr_print(xp, (yyvsp[-1].expr));
			str_printf(xp, ")");
		  (yyval.string) = strdup(str_string(xp));
		  str_truncate(xp);
		  free((yyvsp[-3].string));
		}
#line 6732 "parser.c" /* yacc.c:1646  */
    break;

  case 332:
#line 2563 "parser.y" /* yacc.c:1646  */
    { (yyval.string) = strdup((yyvsp[0].name)); }
#line 6738 "parser.c" /* yacc.c:1646  */
    break;

  case 333:
#line 2564 "parser.y" /* yacc.c:1646  */
    { (yyval.string) = strdup((yyvsp[0].name)); }
#line 6744 "parser.c" /* yacc.c:1646  */
    break;

  case 334:
#line 2565 "parser.y" /* yacc.c:1646  */
    { (yyval.string) = strdup((yyvsp[0].name)); }
#line 6750 "parser.c" /* yacc.c:1646  */
    break;

  case 335:
#line 2585 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6758 "parser.c" /* yacc.c:1646  */
    break;

  case 336:
#line 2589 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6766 "parser.c" /* yacc.c:1646  */
    break;

  case 337:
#line 2597 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6774 "parser.c" /* yacc.c:1646  */
    break;

  case 338:
#line 2606 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 6782 "parser.c" /* yacc.c:1646  */
    break;

  case 339:
#line 2610 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = pastree = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));
    }
#line 6790 "parser.c" /* yacc.c:1646  */
    break;

  case 340:
#line 2617 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6798 "parser.c" /* yacc.c:1646  */
    break;

  case 341:
#line 2621 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6806 "parser.c" /* yacc.c:1646  */
    break;

  case 342:
#line 2625 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6814 "parser.c" /* yacc.c:1646  */
    break;

  case 343:
#line 2629 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6822 "parser.c" /* yacc.c:1646  */
    break;

  case 344:
#line 2633 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6830 "parser.c" /* yacc.c:1646  */
    break;

  case 345:
#line 2637 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6838 "parser.c" /* yacc.c:1646  */
    break;

  case 346:
#line 2641 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6846 "parser.c" /* yacc.c:1646  */
    break;

  case 347:
#line 2645 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6854 "parser.c" /* yacc.c:1646  */
    break;

  case 348:
#line 2649 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6862 "parser.c" /* yacc.c:1646  */
    break;

  case 349:
#line 2653 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6870 "parser.c" /* yacc.c:1646  */
    break;

  case 350:
#line 2658 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6878 "parser.c" /* yacc.c:1646  */
    break;

  case 351:
#line 2663 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6886 "parser.c" /* yacc.c:1646  */
    break;

  case 352:
#line 2667 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6894 "parser.c" /* yacc.c:1646  */
    break;

  case 353:
#line 2671 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6902 "parser.c" /* yacc.c:1646  */
    break;

  case 354:
#line 2675 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6910 "parser.c" /* yacc.c:1646  */
    break;

  case 355:
#line 2679 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6918 "parser.c" /* yacc.c:1646  */
    break;

  case 356:
#line 2683 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6926 "parser.c" /* yacc.c:1646  */
    break;

  case 357:
#line 2687 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6934 "parser.c" /* yacc.c:1646  */
    break;

  case 358:
#line 2691 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6942 "parser.c" /* yacc.c:1646  */
    break;

  case 359:
#line 2695 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6950 "parser.c" /* yacc.c:1646  */
    break;

  case 360:
#line 2699 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6958 "parser.c" /* yacc.c:1646  */
    break;

  case 361:
#line 2703 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6966 "parser.c" /* yacc.c:1646  */
    break;

  case 362:
#line 2707 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6974 "parser.c" /* yacc.c:1646  */
    break;

  case 363:
#line 2711 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6982 "parser.c" /* yacc.c:1646  */
    break;

  case 364:
#line 2715 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6990 "parser.c" /* yacc.c:1646  */
    break;

  case 365:
#line 2719 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 6998 "parser.c" /* yacc.c:1646  */
    break;

  case 366:
#line 2723 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7006 "parser.c" /* yacc.c:1646  */
    break;

  case 367:
#line 2727 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7014 "parser.c" /* yacc.c:1646  */
    break;

  case 368:
#line 2731 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7022 "parser.c" /* yacc.c:1646  */
    break;

  case 369:
#line 2735 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7030 "parser.c" /* yacc.c:1646  */
    break;

  case 370:
#line 2739 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7038 "parser.c" /* yacc.c:1646  */
    break;

  case 371:
#line 2743 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7046 "parser.c" /* yacc.c:1646  */
    break;

  case 372:
#line 2748 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = (yyvsp[0].ocon);
    }
#line 7054 "parser.c" /* yacc.c:1646  */
    break;

  case 373:
#line 2764 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCBARRIER, (yyvsp[0].odir), NULL);
    }
#line 7062 "parser.c" /* yacc.c:1646  */
    break;

  case 374:
#line 2768 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCFLUSH, (yyvsp[0].odir), NULL);
    }
#line 7070 "parser.c" /* yacc.c:1646  */
    break;

  case 375:
#line 2773 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTASKWAIT, (yyvsp[0].odir), NULL);
    }
#line 7078 "parser.c" /* yacc.c:1646  */
    break;

  case 376:
#line 2778 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTASKYIELD, (yyvsp[0].odir), NULL);
    }
#line 7086 "parser.c" /* yacc.c:1646  */
    break;

  case 377:
#line 2783 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCCANCEL, (yyvsp[0].odir), NULL);
    }
#line 7094 "parser.c" /* yacc.c:1646  */
    break;

  case 378:
#line 2788 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCCANCELLATIONPOINT, (yyvsp[0].odir), NULL);
    }
#line 7102 "parser.c" /* yacc.c:1646  */
    break;

  case 379:
#line 2793 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETUPD, (yyvsp[0].odir), NULL);
    }
#line 7110 "parser.c" /* yacc.c:1646  */
    break;

  case 380:
#line 2798 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGENTERDATA, (yyvsp[0].odir), NULL);
    }
#line 7118 "parser.c" /* yacc.c:1646  */
    break;

  case 381:
#line 2803 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGEXITDATA, (yyvsp[0].odir), NULL);
    }
#line 7126 "parser.c" /* yacc.c:1646  */
    break;

  case 382:
#line 2810 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = (yyvsp[0].stmt);
    }
#line 7134 "parser.c" /* yacc.c:1646  */
    break;

  case 383:
#line 2817 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCPARALLEL, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 7143 "parser.c" /* yacc.c:1646  */
    break;

  case 384:
#line 2825 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCPARALLEL, (yyvsp[-1].ocla));
    }
#line 7151 "parser.c" /* yacc.c:1646  */
    break;

  case 385:
#line 2832 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 7159 "parser.c" /* yacc.c:1646  */
    break;

  case 386:
#line 2836 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 7167 "parser.c" /* yacc.c:1646  */
    break;

  case 387:
#line 2840 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 7175 "parser.c" /* yacc.c:1646  */
    break;

  case 388:
#line 2847 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7183 "parser.c" /* yacc.c:1646  */
    break;

  case 389:
#line 2851 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7191 "parser.c" /* yacc.c:1646  */
    break;

  case 390:
#line 2855 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7199 "parser.c" /* yacc.c:1646  */
    break;

  case 391:
#line 2859 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7207 "parser.c" /* yacc.c:1646  */
    break;

  case 392:
#line 2863 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7215 "parser.c" /* yacc.c:1646  */
    break;

  case 393:
#line 2867 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7223 "parser.c" /* yacc.c:1646  */
    break;

  case 394:
#line 2871 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7231 "parser.c" /* yacc.c:1646  */
    break;

  case 395:
#line 2877 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7237 "parser.c" /* yacc.c:1646  */
    break;

  case 396:
#line 2878 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = NumthreadsClause((yyvsp[-1].expr));
    }
#line 7246 "parser.c" /* yacc.c:1646  */
    break;

  case 397:
#line 2882 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7252 "parser.c" /* yacc.c:1646  */
    break;

  case 398:
#line 2883 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCCOPYIN, (yyvsp[-1].decl));
    }
#line 7261 "parser.c" /* yacc.c:1646  */
    break;

  case 399:
#line 2889 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7269 "parser.c" /* yacc.c:1646  */
    break;

  case 400:
#line 2893 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7275 "parser.c" /* yacc.c:1646  */
    break;

  case 401:
#line 2894 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCAUTO, (yyvsp[-1].decl));
    }
#line 7284 "parser.c" /* yacc.c:1646  */
    break;

  case 402:
#line 2902 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 7292 "parser.c" /* yacc.c:1646  */
    break;

  case 403:
#line 2909 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCFOR, (yyvsp[-1].ocla));
    }
#line 7300 "parser.c" /* yacc.c:1646  */
    break;

  case 404:
#line 2916 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 7308 "parser.c" /* yacc.c:1646  */
    break;

  case 405:
#line 2920 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 7325 "parser.c" /* yacc.c:1646  */
    break;

  case 406:
#line 2933 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 7342 "parser.c" /* yacc.c:1646  */
    break;

  case 407:
#line 2949 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7350 "parser.c" /* yacc.c:1646  */
    break;

  case 408:
#line 2953 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7358 "parser.c" /* yacc.c:1646  */
    break;

  case 409:
#line 2957 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7366 "parser.c" /* yacc.c:1646  */
    break;

  case 410:
#line 2961 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7374 "parser.c" /* yacc.c:1646  */
    break;

  case 411:
#line 2965 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7382 "parser.c" /* yacc.c:1646  */
    break;

  case 412:
#line 2969 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 7390 "parser.c" /* yacc.c:1646  */
    break;

  case 413:
#line 2976 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCORDERED);
    }
#line 7398 "parser.c" /* yacc.c:1646  */
    break;

  case 414:
#line 2980 "parser.y" /* yacc.c:1646  */
    {
      int n = 0, er = 0;
      if (xar_expr_is_constant((yyvsp[-1].expr)))
      {
        n = xar_calc_int_expr((yyvsp[-1].expr), &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in ordered() clause.\n");
      (yyval.ocla) = OrderedNumClause(n);
    }
#line 7414 "parser.c" /* yacc.c:1646  */
    break;

  case 415:
#line 2992 "parser.y" /* yacc.c:1646  */
    {
      check_schedule((yyvsp[-1].type), (yyvsp[-2].type));
      (yyval.ocla) = ScheduleClause((yyvsp[-1].type), (yyvsp[-2].type), NULL);
    }
#line 7423 "parser.c" /* yacc.c:1646  */
    break;

  case 416:
#line 2997 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7429 "parser.c" /* yacc.c:1646  */
    break;

  case 417:
#line 2998 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      if ((yyvsp[-4].type) == OC_runtime)
        parse_error(1, "\"runtime\" schedules may not have a chunksize.\n");
      check_schedule((yyvsp[-4].type), (yyvsp[-5].type));
      (yyval.ocla) = ScheduleClause((yyvsp[-4].type), (yyvsp[-5].type), (yyvsp[-1].expr));
    }
#line 7441 "parser.c" /* yacc.c:1646  */
    break;

  case 418:
#line 3006 "parser.y" /* yacc.c:1646  */
    {  /* non-OpenMP schedule */
      tempsave = checkDecls;
      checkDecls = 0;   /* Because the index of the loop is usualy involved */
      sc_pause_openmp();
    }
#line 7451 "parser.c" /* yacc.c:1646  */
    break;

  case 419:
#line 3012 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      checkDecls = tempsave;
      (yyval.ocla) = ScheduleClause(OC_affinity, OCM_none, (yyvsp[-1].expr));
    }
#line 7461 "parser.c" /* yacc.c:1646  */
    break;

  case 420:
#line 3018 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7469 "parser.c" /* yacc.c:1646  */
    break;

  case 421:
#line 3022 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7477 "parser.c" /* yacc.c:1646  */
    break;

  case 422:
#line 3029 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_static;
    }
#line 7485 "parser.c" /* yacc.c:1646  */
    break;

  case 423:
#line 3033 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_dynamic;
    }
#line 7493 "parser.c" /* yacc.c:1646  */
    break;

  case 424:
#line 3037 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_guided;
    }
#line 7501 "parser.c" /* yacc.c:1646  */
    break;

  case 425:
#line 3041 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_runtime;
    }
#line 7509 "parser.c" /* yacc.c:1646  */
    break;

  case 426:
#line 3045 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_auto;
    }
#line 7517 "parser.c" /* yacc.c:1646  */
    break;

  case 427:
#line 3048 "parser.y" /* yacc.c:1646  */
    { parse_error(1, "invalid openmp schedule type.\n"); }
#line 7523 "parser.c" /* yacc.c:1646  */
    break;

  case 428:
#line 3053 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OCM_none;
    }
#line 7531 "parser.c" /* yacc.c:1646  */
    break;

  case 429:
#line 3057 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OCM_monotonic;
    }
#line 7539 "parser.c" /* yacc.c:1646  */
    break;

  case 430:
#line 3061 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OCM_nonmonotonic;
    }
#line 7547 "parser.c" /* yacc.c:1646  */
    break;

  case 431:
#line 3068 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCSECTIONS, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 7555 "parser.c" /* yacc.c:1646  */
    break;

  case 432:
#line 3075 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCSECTIONS, (yyvsp[-1].ocla));
    }
#line 7563 "parser.c" /* yacc.c:1646  */
    break;

  case 433:
#line 3082 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 7571 "parser.c" /* yacc.c:1646  */
    break;

  case 434:
#line 3086 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 7579 "parser.c" /* yacc.c:1646  */
    break;

  case 435:
#line 3090 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 7587 "parser.c" /* yacc.c:1646  */
    break;

  case 436:
#line 3097 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7595 "parser.c" /* yacc.c:1646  */
    break;

  case 437:
#line 3101 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7603 "parser.c" /* yacc.c:1646  */
    break;

  case 438:
#line 3105 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7611 "parser.c" /* yacc.c:1646  */
    break;

  case 439:
#line 3109 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7619 "parser.c" /* yacc.c:1646  */
    break;

  case 440:
#line 3113 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 7627 "parser.c" /* yacc.c:1646  */
    break;

  case 441:
#line 3120 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = Compound((yyvsp[-1].stmt));
    }
#line 7635 "parser.c" /* yacc.c:1646  */
    break;

  case 442:
#line 3127 "parser.y" /* yacc.c:1646  */
    {
      /* Make it look like it had a section pragma */
      (yyval.stmt) = OmpStmt( OmpConstruct(DCSECTION, OmpDirective(DCSECTION,NULL), (yyvsp[0].stmt)) );
    }
#line 7644 "parser.c" /* yacc.c:1646  */
    break;

  case 443:
#line 3132 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = OmpStmt( OmpConstruct(DCSECTION, (yyvsp[-1].odir), (yyvsp[0].stmt)) );
    }
#line 7652 "parser.c" /* yacc.c:1646  */
    break;

  case 444:
#line 3136 "parser.y" /* yacc.c:1646  */
    {
      (yyval.stmt) = BlockList((yyvsp[-2].stmt), OmpStmt( OmpConstruct(DCSECTION, (yyvsp[-1].odir), (yyvsp[0].stmt)) ));
    }
#line 7660 "parser.c" /* yacc.c:1646  */
    break;

  case 445:
#line 3143 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCSECTION, NULL);
    }
#line 7668 "parser.c" /* yacc.c:1646  */
    break;

  case 446:
#line 3150 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCSINGLE, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 7676 "parser.c" /* yacc.c:1646  */
    break;

  case 447:
#line 3157 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCSINGLE, (yyvsp[-1].ocla));
    }
#line 7684 "parser.c" /* yacc.c:1646  */
    break;

  case 448:
#line 3164 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 7692 "parser.c" /* yacc.c:1646  */
    break;

  case 449:
#line 3168 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 7700 "parser.c" /* yacc.c:1646  */
    break;

  case 450:
#line 3172 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 7708 "parser.c" /* yacc.c:1646  */
    break;

  case 451:
#line 3179 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7716 "parser.c" /* yacc.c:1646  */
    break;

  case 452:
#line 3183 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7724 "parser.c" /* yacc.c:1646  */
    break;

  case 453:
#line 3187 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7732 "parser.c" /* yacc.c:1646  */
    break;

  case 454:
#line 3191 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 7740 "parser.c" /* yacc.c:1646  */
    break;

  case 455:
#line 3197 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7746 "parser.c" /* yacc.c:1646  */
    break;

  case 456:
#line 3198 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCCOPYPRIVATE, (yyvsp[-1].decl));
    }
#line 7755 "parser.c" /* yacc.c:1646  */
    break;

  case 457:
#line 3207 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 7763 "parser.c" /* yacc.c:1646  */
    break;

  case 458:
#line 3215 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCSIMD, (yyvsp[-1].ocla));
    }
#line 7771 "parser.c" /* yacc.c:1646  */
    break;

  case 459:
#line 3222 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 7779 "parser.c" /* yacc.c:1646  */
    break;

  case 460:
#line 3226 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 7787 "parser.c" /* yacc.c:1646  */
    break;

  case 461:
#line 3230 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 7795 "parser.c" /* yacc.c:1646  */
    break;

  case 462:
#line 3238 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7803 "parser.c" /* yacc.c:1646  */
    break;

  case 463:
#line 3242 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7811 "parser.c" /* yacc.c:1646  */
    break;

  case 464:
#line 3246 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7819 "parser.c" /* yacc.c:1646  */
    break;

  case 465:
#line 3250 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7827 "parser.c" /* yacc.c:1646  */
    break;

  case 466:
#line 3254 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7835 "parser.c" /* yacc.c:1646  */
    break;

  case 467:
#line 3258 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7843 "parser.c" /* yacc.c:1646  */
    break;

  case 468:
#line 3266 "parser.y" /* yacc.c:1646  */
    {
      int n = 0, er = 0;
      if (xar_expr_is_constant((yyvsp[-1].expr)))
      {
        n = xar_calc_int_expr((yyvsp[-1].expr), &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in simdlen() clause.\n");
      //$$ = CollapseClause(n); //TODO SAFELEN
    }
#line 7859 "parser.c" /* yacc.c:1646  */
    break;

  case 469:
#line 3278 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7867 "parser.c" /* yacc.c:1646  */
    break;

  case 470:
#line 3282 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 7875 "parser.c" /* yacc.c:1646  */
    break;

  case 471:
#line 3290 "parser.y" /* yacc.c:1646  */
    {
      //$$ = PlainClause(OCINBRANCH); TODO ast
    }
#line 7883 "parser.c" /* yacc.c:1646  */
    break;

  case 472:
#line 3294 "parser.y" /* yacc.c:1646  */
    {
      //$$ = PlainClause(OCNOTINBRANCH); TODO ast
    }
#line 7891 "parser.c" /* yacc.c:1646  */
    break;

  case 473:
#line 3301 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7897 "parser.c" /* yacc.c:1646  */
    break;

  case 474:
#line 3302 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      //$$ = VarlistClause(OCUNIFORM, $4); TODO ast
    }
#line 7906 "parser.c" /* yacc.c:1646  */
    break;

  case 475:
#line 3310 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7912 "parser.c" /* yacc.c:1646  */
    break;

  case 476:
#line 3311 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      // TODO ast
    }
#line 7921 "parser.c" /* yacc.c:1646  */
    break;

  case 477:
#line 3319 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 7927 "parser.c" /* yacc.c:1646  */
    break;

  case 478:
#line 3320 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      // TODO ast
    }
#line 7936 "parser.c" /* yacc.c:1646  */
    break;

  case 479:
#line 3328 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = NULL;
    }
#line 7944 "parser.c" /* yacc.c:1646  */
    break;

  case 480:
#line 3332 "parser.y" /* yacc.c:1646  */
    {
      // TODO ast
    }
#line 7952 "parser.c" /* yacc.c:1646  */
    break;

  case 481:
#line 3340 "parser.y" /* yacc.c:1646  */
    {
      //$$ = OmpConstruct(DCDECLSIMD, $1, $2); TODO DCDECLSIMD or change it to stmt
    }
#line 7960 "parser.c" /* yacc.c:1646  */
    break;

  case 482:
#line 3348 "parser.y" /* yacc.c:1646  */
    {
      //TODO
    }
#line 7968 "parser.c" /* yacc.c:1646  */
    break;

  case 483:
#line 3352 "parser.y" /* yacc.c:1646  */
    {
        //TODO
    }
#line 7976 "parser.c" /* yacc.c:1646  */
    break;

  case 484:
#line 3360 "parser.y" /* yacc.c:1646  */
    {
      //$$ = OmpDirective(DCDECLSIMD, $4); TODO DCDECLSIMD
    }
#line 7984 "parser.c" /* yacc.c:1646  */
    break;

  case 485:
#line 3367 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 7992 "parser.c" /* yacc.c:1646  */
    break;

  case 486:
#line 3371 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8000 "parser.c" /* yacc.c:1646  */
    break;

  case 487:
#line 3375 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8008 "parser.c" /* yacc.c:1646  */
    break;

  case 488:
#line 3384 "parser.y" /* yacc.c:1646  */
    {
      int n = 0, er = 0;
      if (xar_expr_is_constant((yyvsp[-1].expr)))
      {
        n = xar_calc_int_expr((yyvsp[-1].expr), &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in simdlen() clause.\n");
      //$$ = CollapseClause(n); //TODO SIMDLEN
    }
#line 8024 "parser.c" /* yacc.c:1646  */
    break;

  case 489:
#line 3396 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8032 "parser.c" /* yacc.c:1646  */
    break;

  case 490:
#line 3400 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8040 "parser.c" /* yacc.c:1646  */
    break;

  case 491:
#line 3404 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8048 "parser.c" /* yacc.c:1646  */
    break;

  case 492:
#line 3408 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8056 "parser.c" /* yacc.c:1646  */
    break;

  case 493:
#line 3416 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8064 "parser.c" /* yacc.c:1646  */
    break;

  case 494:
#line 3424 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCFORSIMD, (yyvsp[-1].ocla));
    }
#line 8072 "parser.c" /* yacc.c:1646  */
    break;

  case 495:
#line 3431 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 8080 "parser.c" /* yacc.c:1646  */
    break;

  case 496:
#line 3435 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8088 "parser.c" /* yacc.c:1646  */
    break;

  case 497:
#line 3439 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8096 "parser.c" /* yacc.c:1646  */
    break;

  case 498:
#line 3446 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8104 "parser.c" /* yacc.c:1646  */
    break;

  case 499:
#line 3450 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8112 "parser.c" /* yacc.c:1646  */
    break;

  case 500:
#line 3458 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8120 "parser.c" /* yacc.c:1646  */
    break;

  case 501:
#line 3466 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 8128 "parser.c" /* yacc.c:1646  */
    break;

  case 502:
#line 3473 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 8136 "parser.c" /* yacc.c:1646  */
    break;

  case 503:
#line 3477 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8144 "parser.c" /* yacc.c:1646  */
    break;

  case 504:
#line 3481 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8152 "parser.c" /* yacc.c:1646  */
    break;

  case 505:
#line 3488 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8160 "parser.c" /* yacc.c:1646  */
    break;

  case 506:
#line 3492 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8168 "parser.c" /* yacc.c:1646  */
    break;

  case 507:
#line 3500 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETDATA, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 8177 "parser.c" /* yacc.c:1646  */
    break;

  case 508:
#line 3509 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETDATA, (yyvsp[-1].ocla));
    }
#line 8185 "parser.c" /* yacc.c:1646  */
    break;

  case 509:
#line 3516 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 8193 "parser.c" /* yacc.c:1646  */
    break;

  case 510:
#line 3520 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8201 "parser.c" /* yacc.c:1646  */
    break;

  case 511:
#line 3524 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8209 "parser.c" /* yacc.c:1646  */
    break;

  case 512:
#line 3531 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8217 "parser.c" /* yacc.c:1646  */
    break;

  case 513:
#line 3535 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.1, page 97: must be to/from/tofrom/alloc */
      if ((yyval.ocla)->subtype != OC_tofrom && (yyval.ocla)->subtype != OC_to && 
          (yyval.ocla)->subtype != OC_from   && (yyval.ocla)->subtype != OC_alloc)
        parse_error(1, "expected a map type of 'to', 'from', 'tofrom' or 'alloc'\n");
    }
#line 8229 "parser.c" /* yacc.c:1646  */
    break;

  case 514:
#line 3543 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8237 "parser.c" /* yacc.c:1646  */
    break;

  case 515:
#line 3547 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8245 "parser.c" /* yacc.c:1646  */
    break;

  case 516:
#line 3554 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8251 "parser.c" /* yacc.c:1646  */
    break;

  case 517:
#line 3555 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = DeviceClause((yyvsp[-1].expr));
    }
#line 8260 "parser.c" /* yacc.c:1646  */
    break;

  case 518:
#line 3564 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8266 "parser.c" /* yacc.c:1646  */
    break;

  case 519:
#line 3565 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = MapClause((yyvsp[-4].type), (yyvsp[-5].type), (yyvsp[-1].oxli));
    }
#line 8275 "parser.c" /* yacc.c:1646  */
    break;

  case 520:
#line 3569 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8281 "parser.c" /* yacc.c:1646  */
    break;

  case 521:
#line 3570 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = MapClause(OC_tofrom, OCM_none, (yyvsp[-1].oxli));
    }
#line 8290 "parser.c" /* yacc.c:1646  */
    break;

  case 522:
#line 3579 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OCM_none;
    }
#line 8298 "parser.c" /* yacc.c:1646  */
    break;

  case 523:
#line 3583 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OCM_always;
    }
#line 8306 "parser.c" /* yacc.c:1646  */
    break;

  case 524:
#line 3587 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OCM_always;
    }
#line 8314 "parser.c" /* yacc.c:1646  */
    break;

  case 525:
#line 3595 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_alloc;
    }
#line 8322 "parser.c" /* yacc.c:1646  */
    break;

  case 526:
#line 3599 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_to;
    }
#line 8330 "parser.c" /* yacc.c:1646  */
    break;

  case 527:
#line 3603 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_from;
    }
#line 8338 "parser.c" /* yacc.c:1646  */
    break;

  case 528:
#line 3607 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_tofrom;
    }
#line 8346 "parser.c" /* yacc.c:1646  */
    break;

  case 529:
#line 3611 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_release; 
    }
#line 8354 "parser.c" /* yacc.c:1646  */
    break;

  case 530:
#line 3615 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_delete;
    }
#line 8362 "parser.c" /* yacc.c:1646  */
    break;

  case 531:
#line 3622 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8368 "parser.c" /* yacc.c:1646  */
    break;

  case 532:
#line 3623 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCUSEDEVPTR, (yyvsp[-1].decl));
    }
#line 8377 "parser.c" /* yacc.c:1646  */
    break;

  case 533:
#line 3632 "parser.y" /* yacc.c:1646  */
    {
      /* No parameters needed */
      (yyval.ocla) = PlainClause(OCDEFAULTMAP);
    }
#line 8386 "parser.c" /* yacc.c:1646  */
    break;

  case 534:
#line 3640 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8392 "parser.c" /* yacc.c:1646  */
    break;

  case 535:
#line 3641 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCISDEVPTR, (yyvsp[-1].decl));
    }
#line 8401 "parser.c" /* yacc.c:1646  */
    break;

  case 536:
#line 3649 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = errorOnReturn;  errorOnReturn = 1; }
#line 8407 "parser.c" /* yacc.c:1646  */
    break;

  case 537:
#line 3651 "parser.y" /* yacc.c:1646  */
    {
      errorOnReturn = (yyvsp[-1].type);
      (yyval.ocon) = OmpConstruct(DCTARGET, (yyvsp[-2].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 8417 "parser.c" /* yacc.c:1646  */
    break;

  case 538:
#line 3661 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGET, (yyvsp[-1].ocla));
    }
#line 8425 "parser.c" /* yacc.c:1646  */
    break;

  case 539:
#line 3668 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 8433 "parser.c" /* yacc.c:1646  */
    break;

  case 540:
#line 3672 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8441 "parser.c" /* yacc.c:1646  */
    break;

  case 541:
#line 3676 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8449 "parser.c" /* yacc.c:1646  */
    break;

  case 542:
#line 3683 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8457 "parser.c" /* yacc.c:1646  */
    break;

  case 543:
#line 3687 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8465 "parser.c" /* yacc.c:1646  */
    break;

  case 544:
#line 3691 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8473 "parser.c" /* yacc.c:1646  */
    break;

  case 545:
#line 3695 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 8481 "parser.c" /* yacc.c:1646  */
    break;

  case 546:
#line 3699 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8489 "parser.c" /* yacc.c:1646  */
    break;

  case 547:
#line 3703 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8497 "parser.c" /* yacc.c:1646  */
    break;

  case 548:
#line 3710 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8505 "parser.c" /* yacc.c:1646  */
    break;

  case 549:
#line 3714 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.4, page 106: must be to/from/tofrom/alloc */
      if ((yyval.ocla)->subtype != OC_tofrom && (yyval.ocla)->subtype != OC_to && 
          (yyval.ocla)->subtype != OC_from   && (yyval.ocla)->subtype != OC_alloc)
        parse_error(1, "expected a map type of 'to', 'from', 'tofrom' or 'alloc'\n");
    }
#line 8517 "parser.c" /* yacc.c:1646  */
    break;

  case 550:
#line 3722 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8525 "parser.c" /* yacc.c:1646  */
    break;

  case 551:
#line 3726 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8533 "parser.c" /* yacc.c:1646  */
    break;

  case 552:
#line 3734 "parser.y" /* yacc.c:1646  */
    {
      if (xc_clauselist_get_clause((yyvsp[-1].ocla), OCMAP, 0) == NULL)
        parse_error(1, "target enter data directives must contain at least 1 "
                       "map() clause");
      (yyval.odir) = OmpDirective(DCTARGENTERDATA, (yyvsp[-1].ocla));
      __has_target = 1;
    }
#line 8545 "parser.c" /* yacc.c:1646  */
    break;

  case 553:
#line 3745 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8553 "parser.c" /* yacc.c:1646  */
    break;

  case 554:
#line 3749 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8561 "parser.c" /* yacc.c:1646  */
    break;

  case 555:
#line 3753 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8569 "parser.c" /* yacc.c:1646  */
    break;

  case 556:
#line 3760 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.2, page 99: must be to/alloc */
      if ((yyval.ocla)->subtype != OC_to && (yyval.ocla)->subtype != OC_alloc)
        parse_error(1, "expected a map type of 'to' or 'alloc'\n");
    }
#line 8580 "parser.c" /* yacc.c:1646  */
    break;

  case 557:
#line 3767 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8588 "parser.c" /* yacc.c:1646  */
    break;

  case 558:
#line 3771 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8596 "parser.c" /* yacc.c:1646  */
    break;

  case 559:
#line 3775 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8604 "parser.c" /* yacc.c:1646  */
    break;

  case 560:
#line 3779 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 8612 "parser.c" /* yacc.c:1646  */
    break;

  case 561:
#line 3786 "parser.y" /* yacc.c:1646  */
    {
      if (xc_clauselist_get_clause((yyvsp[-1].ocla), OCMAP, 0) == NULL)
        parse_error(1, "target exit data directives must contain at least 1 "
                       "map() clause");
      (yyval.odir) = OmpDirective(DCTARGEXITDATA, (yyvsp[-1].ocla));
      __has_target = 1;
    }
#line 8624 "parser.c" /* yacc.c:1646  */
    break;

  case 562:
#line 3797 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8632 "parser.c" /* yacc.c:1646  */
    break;

  case 563:
#line 3801 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8640 "parser.c" /* yacc.c:1646  */
    break;

  case 564:
#line 3805 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8648 "parser.c" /* yacc.c:1646  */
    break;

  case 565:
#line 3812 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.3, page 102: must be from/release/delete */
      if ((yyval.ocla)->subtype != OC_from && (yyval.ocla)->subtype != OC_release &&
          (yyval.ocla)->subtype != OC_delete)
        parse_error(1, "expected a map type of 'from', 'release' or 'delete'\n");
    }
#line 8660 "parser.c" /* yacc.c:1646  */
    break;

  case 566:
#line 3820 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8668 "parser.c" /* yacc.c:1646  */
    break;

  case 567:
#line 3824 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8676 "parser.c" /* yacc.c:1646  */
    break;

  case 568:
#line 3828 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8684 "parser.c" /* yacc.c:1646  */
    break;

  case 569:
#line 3832 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 8692 "parser.c" /* yacc.c:1646  */
    break;

  case 570:
#line 3840 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETUPD, (yyvsp[-1].ocla));
      __has_target = 1;
    }
#line 8701 "parser.c" /* yacc.c:1646  */
    break;

  case 571:
#line 3848 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8709 "parser.c" /* yacc.c:1646  */
    break;

  case 572:
#line 3852 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8717 "parser.c" /* yacc.c:1646  */
    break;

  case 573:
#line 3856 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8725 "parser.c" /* yacc.c:1646  */
    break;

  case 574:
#line 3863 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8733 "parser.c" /* yacc.c:1646  */
    break;

  case 575:
#line 3867 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8741 "parser.c" /* yacc.c:1646  */
    break;

  case 576:
#line 3871 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8749 "parser.c" /* yacc.c:1646  */
    break;

  case 577:
#line 3875 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8757 "parser.c" /* yacc.c:1646  */
    break;

  case 578:
#line 3879 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 8765 "parser.c" /* yacc.c:1646  */
    break;

  case 579:
#line 3885 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8771 "parser.c" /* yacc.c:1646  */
    break;

  case 580:
#line 3886 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = UpdateClause(OCTO, (yyvsp[-1].oxli));
    }
#line 8780 "parser.c" /* yacc.c:1646  */
    break;

  case 581:
#line 3890 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8786 "parser.c" /* yacc.c:1646  */
    break;

  case 582:
#line 3891 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = UpdateClause(OCFROM, (yyvsp[-1].oxli));
    }
#line 8795 "parser.c" /* yacc.c:1646  */
    break;

  case 583:
#line 3902 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCDECLTARGET, (yyvsp[-2].odir), (yyvsp[-1].stmt));
    }
#line 8803 "parser.c" /* yacc.c:1646  */
    break;

  case 584:
#line 3906 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCDECLTARGET, (yyvsp[0].odir), NULL);
    }
#line 8811 "parser.c" /* yacc.c:1646  */
    break;

  case 585:
#line 3913 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDECLTARGET, NULL);
    }
#line 8819 "parser.c" /* yacc.c:1646  */
    break;

  case 586:
#line 3920 "parser.y" /* yacc.c:1646  */
    {
      //$$ = OmpDirective(DCENDDECLTARGET, NULL); TODO DCENDDECLTARGET
    }
#line 8827 "parser.c" /* yacc.c:1646  */
    break;

  case 587:
#line 3929 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDECLTARGET, UpdateClause(OCTO, (yyvsp[-2].oxli)));
    }
#line 8835 "parser.c" /* yacc.c:1646  */
    break;

  case 588:
#line 3933 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDECLTARGET, (yyvsp[-1].ocla));
    }
#line 8843 "parser.c" /* yacc.c:1646  */
    break;

  case 589:
#line 3941 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8851 "parser.c" /* yacc.c:1646  */
    break;

  case 590:
#line 3945 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8859 "parser.c" /* yacc.c:1646  */
    break;

  case 591:
#line 3949 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8867 "parser.c" /* yacc.c:1646  */
    break;

  case 592:
#line 3956 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8873 "parser.c" /* yacc.c:1646  */
    break;

  case 593:
#line 3957 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = UpdateClause(OCTO, (yyvsp[-1].oxli));
    }
#line 8882 "parser.c" /* yacc.c:1646  */
    break;

  case 594:
#line 3962 "parser.y" /* yacc.c:1646  */
    { 
      tempsave = checkDecls;   /* No check--the directive can appear anywhere */
      checkDecls = 0; 
      sc_pause_openmp(); 
    }
#line 8892 "parser.c" /* yacc.c:1646  */
    break;

  case 595:
#line 3968 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      checkDecls = tempsave;
      (yyval.ocla) = UpdateClause(OCLINK, (yyvsp[-1].oxli));
    }
#line 8902 "parser.c" /* yacc.c:1646  */
    break;

  case 596:
#line 3980 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTEAMS, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8910 "parser.c" /* yacc.c:1646  */
    break;

  case 597:
#line 3990 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTEAMS, (yyvsp[-1].ocla));
    }
#line 8918 "parser.c" /* yacc.c:1646  */
    break;

  case 598:
#line 3997 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 8926 "parser.c" /* yacc.c:1646  */
    break;

  case 599:
#line 4001 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8934 "parser.c" /* yacc.c:1646  */
    break;

  case 600:
#line 4005 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8942 "parser.c" /* yacc.c:1646  */
    break;

  case 601:
#line 4012 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8950 "parser.c" /* yacc.c:1646  */
    break;

  case 602:
#line 4016 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8958 "parser.c" /* yacc.c:1646  */
    break;

  case 603:
#line 4020 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8966 "parser.c" /* yacc.c:1646  */
    break;

  case 604:
#line 4024 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8974 "parser.c" /* yacc.c:1646  */
    break;

  case 605:
#line 4028 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8982 "parser.c" /* yacc.c:1646  */
    break;

  case 606:
#line 4032 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 8990 "parser.c" /* yacc.c:1646  */
    break;

  case 607:
#line 4041 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 8996 "parser.c" /* yacc.c:1646  */
    break;

  case 608:
#line 4042 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = ((yyvsp[-1].expr) == NULL) ? NumteamsClause(NULL, (yyvsp[-2].expr)) : NumteamsClause((yyvsp[-2].expr), (yyvsp[-1].expr));
    }
#line 9005 "parser.c" /* yacc.c:1646  */
    break;

  case 609:
#line 4047 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 9011 "parser.c" /* yacc.c:1646  */
    break;

  case 610:
#line 4048 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = ThreadlimitClause((yyvsp[-1].expr));
    }
#line 9020 "parser.c" /* yacc.c:1646  */
    break;

  case 611:
#line 4058 "parser.y" /* yacc.c:1646  */
    { (yyval.expr) = NULL; }
#line 9026 "parser.c" /* yacc.c:1646  */
    break;

  case 612:
#line 4060 "parser.y" /* yacc.c:1646  */
    { (yyval.expr) = (yyvsp[0].expr); }
#line 9032 "parser.c" /* yacc.c:1646  */
    break;

  case 613:
#line 4066 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCDISTRIBUTE, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 9040 "parser.c" /* yacc.c:1646  */
    break;

  case 614:
#line 4074 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDISTRIBUTE, (yyvsp[-1].ocla));
    }
#line 9048 "parser.c" /* yacc.c:1646  */
    break;

  case 615:
#line 4081 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9056 "parser.c" /* yacc.c:1646  */
    break;

  case 616:
#line 4085 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9064 "parser.c" /* yacc.c:1646  */
    break;

  case 617:
#line 4089 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9072 "parser.c" /* yacc.c:1646  */
    break;

  case 618:
#line 4096 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9080 "parser.c" /* yacc.c:1646  */
    break;

  case 619:
#line 4100 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9088 "parser.c" /* yacc.c:1646  */
    break;

  case 620:
#line 4104 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9096 "parser.c" /* yacc.c:1646  */
    break;

  case 621:
#line 4108 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9104 "parser.c" /* yacc.c:1646  */
    break;

  case 622:
#line 4112 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9112 "parser.c" /* yacc.c:1646  */
    break;

  case 623:
#line 4119 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = DistScheduleClause(OC_static, OCM_none, NULL);
    }
#line 9120 "parser.c" /* yacc.c:1646  */
    break;

  case 624:
#line 4122 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 9126 "parser.c" /* yacc.c:1646  */
    break;

  case 625:
#line 4123 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = DistScheduleClause(OC_static,OCM_none,  (yyvsp[-1].expr));
    }
#line 9135 "parser.c" /* yacc.c:1646  */
    break;

  case 626:
#line 4132 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCDISTSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 9144 "parser.c" /* yacc.c:1646  */
    break;

  case 627:
#line 4141 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDISTSIMD, (yyvsp[-1].ocla));
    }
#line 9152 "parser.c" /* yacc.c:1646  */
    break;

  case 628:
#line 4148 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9160 "parser.c" /* yacc.c:1646  */
    break;

  case 629:
#line 4152 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9168 "parser.c" /* yacc.c:1646  */
    break;

  case 630:
#line 4156 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9176 "parser.c" /* yacc.c:1646  */
    break;

  case 631:
#line 4163 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9184 "parser.c" /* yacc.c:1646  */
    break;

  case 632:
#line 4167 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9192 "parser.c" /* yacc.c:1646  */
    break;

  case 633:
#line 4171 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9200 "parser.c" /* yacc.c:1646  */
    break;

  case 634:
#line 4179 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCDISTPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 9209 "parser.c" /* yacc.c:1646  */
    break;

  case 635:
#line 4188 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDISTPARFOR, (yyvsp[-1].ocla));
    }
#line 9217 "parser.c" /* yacc.c:1646  */
    break;

  case 636:
#line 4195 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9225 "parser.c" /* yacc.c:1646  */
    break;

  case 637:
#line 4199 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 9242 "parser.c" /* yacc.c:1646  */
    break;

  case 638:
#line 4212 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 9259 "parser.c" /* yacc.c:1646  */
    break;

  case 639:
#line 4228 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9267 "parser.c" /* yacc.c:1646  */
    break;

  case 640:
#line 4232 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9275 "parser.c" /* yacc.c:1646  */
    break;

  case 641:
#line 4240 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCDISTPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 9284 "parser.c" /* yacc.c:1646  */
    break;

  case 642:
#line 4249 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCDISTPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 9292 "parser.c" /* yacc.c:1646  */
    break;

  case 643:
#line 4256 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9300 "parser.c" /* yacc.c:1646  */
    break;

  case 644:
#line 4260 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9308 "parser.c" /* yacc.c:1646  */
    break;

  case 645:
#line 4264 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9316 "parser.c" /* yacc.c:1646  */
    break;

  case 646:
#line 4271 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9324 "parser.c" /* yacc.c:1646  */
    break;

  case 647:
#line 4275 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9332 "parser.c" /* yacc.c:1646  */
    break;

  case 648:
#line 4283 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMS, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 9341 "parser.c" /* yacc.c:1646  */
    break;

  case 649:
#line 4292 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMS, (yyvsp[-1].ocla));
    }
#line 9349 "parser.c" /* yacc.c:1646  */
    break;

  case 650:
#line 4299 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9357 "parser.c" /* yacc.c:1646  */
    break;

  case 651:
#line 4303 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9365 "parser.c" /* yacc.c:1646  */
    break;

  case 652:
#line 4307 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9373 "parser.c" /* yacc.c:1646  */
    break;

  case 653:
#line 4314 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9381 "parser.c" /* yacc.c:1646  */
    break;

  case 654:
#line 4318 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9389 "parser.c" /* yacc.c:1646  */
    break;

  case 655:
#line 4322 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9397 "parser.c" /* yacc.c:1646  */
    break;

  case 656:
#line 4326 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9405 "parser.c" /* yacc.c:1646  */
    break;

  case 657:
#line 4330 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 9413 "parser.c" /* yacc.c:1646  */
    break;

  case 658:
#line 4338 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETPARALLEL, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 9422 "parser.c" /* yacc.c:1646  */
    break;

  case 659:
#line 4347 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETPARALLEL, (yyvsp[-1].ocla));
    }
#line 9430 "parser.c" /* yacc.c:1646  */
    break;

  case 660:
#line 4354 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9438 "parser.c" /* yacc.c:1646  */
    break;

  case 661:
#line 4358 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9446 "parser.c" /* yacc.c:1646  */
    break;

  case 662:
#line 4362 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9454 "parser.c" /* yacc.c:1646  */
    break;

  case 663:
#line 4369 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9462 "parser.c" /* yacc.c:1646  */
    break;

  case 664:
#line 4373 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9470 "parser.c" /* yacc.c:1646  */
    break;

  case 665:
#line 4377 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9478 "parser.c" /* yacc.c:1646  */
    break;

  case 666:
#line 4381 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9486 "parser.c" /* yacc.c:1646  */
    break;

  case 667:
#line 4385 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9494 "parser.c" /* yacc.c:1646  */
    break;

  case 668:
#line 4389 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9502 "parser.c" /* yacc.c:1646  */
    break;

  case 669:
#line 4393 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9510 "parser.c" /* yacc.c:1646  */
    break;

  case 670:
#line 4397 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9518 "parser.c" /* yacc.c:1646  */
    break;

  case 671:
#line 4401 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9526 "parser.c" /* yacc.c:1646  */
    break;

  case 672:
#line 4405 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 9534 "parser.c" /* yacc.c:1646  */
    break;

  case 673:
#line 4413 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDIST, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 9542 "parser.c" /* yacc.c:1646  */
    break;

  case 674:
#line 4421 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTEAMSDIST, (yyvsp[-1].ocla));
    }
#line 9550 "parser.c" /* yacc.c:1646  */
    break;

  case 675:
#line 4428 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9558 "parser.c" /* yacc.c:1646  */
    break;

  case 676:
#line 4432 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9566 "parser.c" /* yacc.c:1646  */
    break;

  case 677:
#line 4436 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9574 "parser.c" /* yacc.c:1646  */
    break;

  case 678:
#line 4443 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9582 "parser.c" /* yacc.c:1646  */
    break;

  case 679:
#line 4447 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9590 "parser.c" /* yacc.c:1646  */
    break;

  case 680:
#line 4451 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9598 "parser.c" /* yacc.c:1646  */
    break;

  case 681:
#line 4455 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9606 "parser.c" /* yacc.c:1646  */
    break;

  case 682:
#line 4463 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDISTSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 9614 "parser.c" /* yacc.c:1646  */
    break;

  case 683:
#line 4471 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTEAMSDISTSIMD, (yyvsp[-1].ocla));
    }
#line 9622 "parser.c" /* yacc.c:1646  */
    break;

  case 684:
#line 4478 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9630 "parser.c" /* yacc.c:1646  */
    break;

  case 685:
#line 4482 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9638 "parser.c" /* yacc.c:1646  */
    break;

  case 686:
#line 4486 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9646 "parser.c" /* yacc.c:1646  */
    break;

  case 687:
#line 4493 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9654 "parser.c" /* yacc.c:1646  */
    break;

  case 688:
#line 4497 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9662 "parser.c" /* yacc.c:1646  */
    break;

  case 689:
#line 4501 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9670 "parser.c" /* yacc.c:1646  */
    break;

  case 690:
#line 4505 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9678 "parser.c" /* yacc.c:1646  */
    break;

  case 691:
#line 4513 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDIST, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 9687 "parser.c" /* yacc.c:1646  */
    break;

  case 692:
#line 4522 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDIST, (yyvsp[-1].ocla));
    }
#line 9695 "parser.c" /* yacc.c:1646  */
    break;

  case 693:
#line 4529 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9703 "parser.c" /* yacc.c:1646  */
    break;

  case 694:
#line 4533 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9711 "parser.c" /* yacc.c:1646  */
    break;

  case 695:
#line 4537 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9719 "parser.c" /* yacc.c:1646  */
    break;

  case 696:
#line 4544 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9727 "parser.c" /* yacc.c:1646  */
    break;

  case 697:
#line 4548 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9735 "parser.c" /* yacc.c:1646  */
    break;

  case 698:
#line 4552 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9743 "parser.c" /* yacc.c:1646  */
    break;

  case 699:
#line 4556 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9751 "parser.c" /* yacc.c:1646  */
    break;

  case 700:
#line 4560 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 9759 "parser.c" /* yacc.c:1646  */
    break;

  case 701:
#line 4568 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDISTSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 9768 "parser.c" /* yacc.c:1646  */
    break;

  case 702:
#line 4578 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDISTSIMD, (yyvsp[-1].ocla));
    }
#line 9776 "parser.c" /* yacc.c:1646  */
    break;

  case 703:
#line 4585 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9784 "parser.c" /* yacc.c:1646  */
    break;

  case 704:
#line 4590 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9792 "parser.c" /* yacc.c:1646  */
    break;

  case 705:
#line 4595 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9800 "parser.c" /* yacc.c:1646  */
    break;

  case 706:
#line 4602 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9808 "parser.c" /* yacc.c:1646  */
    break;

  case 707:
#line 4606 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9816 "parser.c" /* yacc.c:1646  */
    break;

  case 708:
#line 4610 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9824 "parser.c" /* yacc.c:1646  */
    break;

  case 709:
#line 4614 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 9832 "parser.c" /* yacc.c:1646  */
    break;

  case 710:
#line 4622 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDISTPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 9841 "parser.c" /* yacc.c:1646  */
    break;

  case 711:
#line 4632 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTEAMSDISTPARFOR, (yyvsp[-1].ocla));
    }
#line 9849 "parser.c" /* yacc.c:1646  */
    break;

  case 712:
#line 4639 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9857 "parser.c" /* yacc.c:1646  */
    break;

  case 713:
#line 4644 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 9874 "parser.c" /* yacc.c:1646  */
    break;

  case 714:
#line 4658 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 9891 "parser.c" /* yacc.c:1646  */
    break;

  case 715:
#line 4674 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9899 "parser.c" /* yacc.c:1646  */
    break;

  case 716:
#line 4678 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9907 "parser.c" /* yacc.c:1646  */
    break;

  case 717:
#line 4686 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDISTPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
      __has_target = 1;
    }
#line 9917 "parser.c" /* yacc.c:1646  */
    break;

  case 718:
#line 4696 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDISTPARFOR, (yyvsp[-1].ocla));
    }
#line 9925 "parser.c" /* yacc.c:1646  */
    break;

  case 719:
#line 4703 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 9933 "parser.c" /* yacc.c:1646  */
    break;

  case 720:
#line 4707 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 9950 "parser.c" /* yacc.c:1646  */
    break;

  case 721:
#line 4720 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 9967 "parser.c" /* yacc.c:1646  */
    break;

  case 722:
#line 4736 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9975 "parser.c" /* yacc.c:1646  */
    break;

  case 723:
#line 4740 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9983 "parser.c" /* yacc.c:1646  */
    break;

  case 724:
#line 4744 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9991 "parser.c" /* yacc.c:1646  */
    break;

  case 725:
#line 4748 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 9999 "parser.c" /* yacc.c:1646  */
    break;

  case 726:
#line 4756 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDISTPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10008 "parser.c" /* yacc.c:1646  */
    break;

  case 727:
#line 4765 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTEAMSDISTPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 10016 "parser.c" /* yacc.c:1646  */
    break;

  case 728:
#line 4772 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10024 "parser.c" /* yacc.c:1646  */
    break;

  case 729:
#line 4776 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10032 "parser.c" /* yacc.c:1646  */
    break;

  case 730:
#line 4780 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10040 "parser.c" /* yacc.c:1646  */
    break;

  case 731:
#line 4787 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10048 "parser.c" /* yacc.c:1646  */
    break;

  case 732:
#line 4791 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10056 "parser.c" /* yacc.c:1646  */
    break;

  case 733:
#line 4799 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDISTPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
      __has_target = 1;
    }
#line 10066 "parser.c" /* yacc.c:1646  */
    break;

  case 734:
#line 4809 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDISTPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 10074 "parser.c" /* yacc.c:1646  */
    break;

  case 735:
#line 4816 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10082 "parser.c" /* yacc.c:1646  */
    break;

  case 736:
#line 4820 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10090 "parser.c" /* yacc.c:1646  */
    break;

  case 737:
#line 4824 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10098 "parser.c" /* yacc.c:1646  */
    break;

  case 738:
#line 4831 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10106 "parser.c" /* yacc.c:1646  */
    break;

  case 739:
#line 4835 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10114 "parser.c" /* yacc.c:1646  */
    break;

  case 740:
#line 4839 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10122 "parser.c" /* yacc.c:1646  */
    break;

  case 741:
#line 4843 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 10130 "parser.c" /* yacc.c:1646  */
    break;

  case 742:
#line 4851 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTARGETPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 10139 "parser.c" /* yacc.c:1646  */
    break;

  case 743:
#line 4860 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTARGETPARFOR, (yyvsp[-1].ocla));
    }
#line 10147 "parser.c" /* yacc.c:1646  */
    break;

  case 744:
#line 4867 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10155 "parser.c" /* yacc.c:1646  */
    break;

  case 745:
#line 4871 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10172 "parser.c" /* yacc.c:1646  */
    break;

  case 746:
#line 4884 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10189 "parser.c" /* yacc.c:1646  */
    break;

  case 747:
#line 4900 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10197 "parser.c" /* yacc.c:1646  */
    break;

  case 748:
#line 4904 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
  	}
#line 10205 "parser.c" /* yacc.c:1646  */
    break;

  case 749:
#line 4908 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10213 "parser.c" /* yacc.c:1646  */
    break;

  case 750:
#line 4912 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCNOWAIT);
    }
#line 10221 "parser.c" /* yacc.c:1646  */
    break;

  case 751:
#line 4920 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTASK, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10230 "parser.c" /* yacc.c:1646  */
    break;

  case 752:
#line 4929 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTASK, (yyvsp[-1].ocla));
    }
#line 10238 "parser.c" /* yacc.c:1646  */
    break;

  case 753:
#line 4937 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10246 "parser.c" /* yacc.c:1646  */
    break;

  case 754:
#line 4941 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10254 "parser.c" /* yacc.c:1646  */
    break;

  case 755:
#line 4945 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10262 "parser.c" /* yacc.c:1646  */
    break;

  case 756:
#line 4953 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10270 "parser.c" /* yacc.c:1646  */
    break;

  case 757:
#line 4957 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10278 "parser.c" /* yacc.c:1646  */
    break;

  case 758:
#line 4961 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10286 "parser.c" /* yacc.c:1646  */
    break;

  case 759:
#line 4965 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10294 "parser.c" /* yacc.c:1646  */
    break;

  case 760:
#line 4969 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10302 "parser.c" /* yacc.c:1646  */
    break;

  case 761:
#line 4973 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10310 "parser.c" /* yacc.c:1646  */
    break;

  case 762:
#line 4977 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10318 "parser.c" /* yacc.c:1646  */
    break;

  case 763:
#line 4984 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 10324 "parser.c" /* yacc.c:1646  */
    break;

  case 764:
#line 4985 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = FinalClause((yyvsp[-1].expr));
    }
#line 10333 "parser.c" /* yacc.c:1646  */
    break;

  case 765:
#line 4990 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCUNTIED);
    }
#line 10341 "parser.c" /* yacc.c:1646  */
    break;

  case 766:
#line 4994 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCMERGEABLE);
    }
#line 10349 "parser.c" /* yacc.c:1646  */
    break;

  case 767:
#line 4999 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PriorityClause((yyvsp[-1].expr));
    }
#line 10357 "parser.c" /* yacc.c:1646  */
    break;

  case 768:
#line 5006 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 10363 "parser.c" /* yacc.c:1646  */
    break;

  case 769:
#line 5007 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = DependClause((yyvsp[-4].type), (yyvsp[-1].oxli));
    }
#line 10372 "parser.c" /* yacc.c:1646  */
    break;

  case 770:
#line 5016 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_in;
    }
#line 10380 "parser.c" /* yacc.c:1646  */
    break;

  case 771:
#line 5020 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_out;
    }
#line 10388 "parser.c" /* yacc.c:1646  */
    break;

  case 772:
#line 5024 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_inout;
    }
#line 10396 "parser.c" /* yacc.c:1646  */
    break;

  case 773:
#line 5031 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10405 "parser.c" /* yacc.c:1646  */
    break;

  case 774:
#line 5039 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCPARFOR, (yyvsp[-1].ocla));
    }
#line 10413 "parser.c" /* yacc.c:1646  */
    break;

  case 775:
#line 5046 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10421 "parser.c" /* yacc.c:1646  */
    break;

  case 776:
#line 5050 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10438 "parser.c" /* yacc.c:1646  */
    break;

  case 777:
#line 5063 "parser.y" /* yacc.c:1646  */
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with --enable-ext\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10455 "parser.c" /* yacc.c:1646  */
    break;

  case 778:
#line 5079 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10463 "parser.c" /* yacc.c:1646  */
    break;

  case 779:
#line 5083 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10471 "parser.c" /* yacc.c:1646  */
    break;

  case 780:
#line 5087 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10479 "parser.c" /* yacc.c:1646  */
    break;

  case 781:
#line 5091 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10487 "parser.c" /* yacc.c:1646  */
    break;

  case 782:
#line 5095 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10495 "parser.c" /* yacc.c:1646  */
    break;

  case 783:
#line 5099 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10503 "parser.c" /* yacc.c:1646  */
    break;

  case 784:
#line 5103 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10511 "parser.c" /* yacc.c:1646  */
    break;

  case 785:
#line 5107 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10519 "parser.c" /* yacc.c:1646  */
    break;

  case 786:
#line 5111 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10527 "parser.c" /* yacc.c:1646  */
    break;

  case 787:
#line 5118 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCPARSECTIONS, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10536 "parser.c" /* yacc.c:1646  */
    break;

  case 788:
#line 5126 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCPARSECTIONS, (yyvsp[-1].ocla));
    }
#line 10544 "parser.c" /* yacc.c:1646  */
    break;

  case 789:
#line 5133 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10552 "parser.c" /* yacc.c:1646  */
    break;

  case 790:
#line 5137 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10560 "parser.c" /* yacc.c:1646  */
    break;

  case 791:
#line 5141 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10568 "parser.c" /* yacc.c:1646  */
    break;

  case 792:
#line 5148 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10576 "parser.c" /* yacc.c:1646  */
    break;

  case 793:
#line 5152 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10584 "parser.c" /* yacc.c:1646  */
    break;

  case 794:
#line 5156 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10592 "parser.c" /* yacc.c:1646  */
    break;

  case 795:
#line 5160 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10600 "parser.c" /* yacc.c:1646  */
    break;

  case 796:
#line 5164 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10608 "parser.c" /* yacc.c:1646  */
    break;

  case 797:
#line 5168 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10616 "parser.c" /* yacc.c:1646  */
    break;

  case 798:
#line 5172 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10624 "parser.c" /* yacc.c:1646  */
    break;

  case 799:
#line 5176 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10632 "parser.c" /* yacc.c:1646  */
    break;

  case 800:
#line 5183 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCMASTER, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10640 "parser.c" /* yacc.c:1646  */
    break;

  case 801:
#line 5190 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCMASTER, NULL);
    }
#line 10648 "parser.c" /* yacc.c:1646  */
    break;

  case 802:
#line 5197 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCCRITICAL, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10656 "parser.c" /* yacc.c:1646  */
    break;

  case 803:
#line 5204 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpCriticalDirective(NULL, NULL);
    }
#line 10664 "parser.c" /* yacc.c:1646  */
    break;

  case 804:
#line 5208 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpCriticalDirective((yyvsp[-1].symb), NULL);
    }
#line 10672 "parser.c" /* yacc.c:1646  */
    break;

  case 805:
#line 5213 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpCriticalDirective((yyvsp[-2].symb), (yyvsp[-1].ocla));
    }
#line 10680 "parser.c" /* yacc.c:1646  */
    break;

  case 806:
#line 5220 "parser.y" /* yacc.c:1646  */
    {
      (yyval.symb) = Symbol((yyvsp[-1].name));
    }
#line 10688 "parser.c" /* yacc.c:1646  */
    break;

  case 807:
#line 5228 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = HintClause((yyvsp[-1].expr));
    }
#line 10696 "parser.c" /* yacc.c:1646  */
    break;

  case 808:
#line 5235 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCBARRIER, NULL);
    }
#line 10704 "parser.c" /* yacc.c:1646  */
    break;

  case 809:
#line 5243 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTASKWAIT, NULL);
    }
#line 10712 "parser.c" /* yacc.c:1646  */
    break;

  case 810:
#line 5251 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCTASKGROUP, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10720 "parser.c" /* yacc.c:1646  */
    break;

  case 811:
#line 5259 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTASKGROUP, NULL);
    }
#line 10728 "parser.c" /* yacc.c:1646  */
    break;

  case 812:
#line 5267 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCTASKYIELD, NULL);
    }
#line 10736 "parser.c" /* yacc.c:1646  */
    break;

  case 813:
#line 5274 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCATOMIC, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10744 "parser.c" /* yacc.c:1646  */
    break;

  case 814:
#line 5285 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCATOMIC, NULL);  //TODO Check how to do it since it now has 2 clauses
    }
#line 10752 "parser.c" /* yacc.c:1646  */
    break;

  case 815:
#line 5292 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10760 "parser.c" /* yacc.c:1646  */
    break;

  case 816:
#line 5296 "parser.y" /* yacc.c:1646  */
    {
      //$$ = TODO
    }
#line 10768 "parser.c" /* yacc.c:1646  */
    break;

  case 817:
#line 5300 "parser.y" /* yacc.c:1646  */
    {
      //$$ = TODO
    }
#line 10776 "parser.c" /* yacc.c:1646  */
    break;

  case 818:
#line 5304 "parser.y" /* yacc.c:1646  */
    {
      //$$ = TODO
    }
#line 10784 "parser.c" /* yacc.c:1646  */
    break;

  case 819:
#line 5308 "parser.y" /* yacc.c:1646  */
    {
      //$$ = TODO
    }
#line 10792 "parser.c" /* yacc.c:1646  */
    break;

  case 820:
#line 5316 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10800 "parser.c" /* yacc.c:1646  */
    break;

  case 821:
#line 5320 "parser.y" /* yacc.c:1646  */
    {
      //$$ = TODO
    }
#line 10808 "parser.c" /* yacc.c:1646  */
    break;

  case 822:
#line 5327 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpFlushDirective(NULL);
    }
#line 10816 "parser.c" /* yacc.c:1646  */
    break;

  case 823:
#line 5331 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpFlushDirective((yyvsp[-1].decl));
    }
#line 10824 "parser.c" /* yacc.c:1646  */
    break;

  case 824:
#line 5337 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 10830 "parser.c" /* yacc.c:1646  */
    break;

  case 825:
#line 5338 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.decl) = (yyvsp[-1].decl);
    }
#line 10839 "parser.c" /* yacc.c:1646  */
    break;

  case 826:
#line 5346 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCORDERED, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10847 "parser.c" /* yacc.c:1646  */
    break;

  case 827:
#line 5350 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocon) = OmpConstruct(DCORDERED, (yyvsp[0].odir), NULL);
    }
#line 10855 "parser.c" /* yacc.c:1646  */
    break;

  case 828:
#line 5357 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCORDERED, (yyvsp[-1].ocla));
    }
#line 10863 "parser.c" /* yacc.c:1646  */
    break;

  case 829:
#line 5364 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCORDERED, DependClause(OC_source,NULL));
    }
#line 10871 "parser.c" /* yacc.c:1646  */
    break;

  case 830:
#line 5368 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCORDERED, (yyvsp[-1].ocla));
    }
#line 10879 "parser.c" /* yacc.c:1646  */
    break;

  case 831:
#line 5376 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 10887 "parser.c" /* yacc.c:1646  */
    break;

  case 832:
#line 5380 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10895 "parser.c" /* yacc.c:1646  */
    break;

  case 833:
#line 5384 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10903 "parser.c" /* yacc.c:1646  */
    break;

  case 834:
#line 5392 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCTHREADS);
    }
#line 10911 "parser.c" /* yacc.c:1646  */
    break;

  case 835:
#line 5396 "parser.y" /* yacc.c:1646  */
    {
      //TODO
    }
#line 10919 "parser.c" /* yacc.c:1646  */
    break;

  case 836:
#line 5404 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 10927 "parser.c" /* yacc.c:1646  */
    break;

  case 837:
#line 5408 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10935 "parser.c" /* yacc.c:1646  */
    break;

  case 838:
#line 5412 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10943 "parser.c" /* yacc.c:1646  */
    break;

  case 839:
#line 5420 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = DependClause(OC_sink, NULL);
      (yyval.ocla)->u.expr = (yyvsp[-1].expr);
    }
#line 10952 "parser.c" /* yacc.c:1646  */
    break;

  case 840:
#line 5428 "parser.y" /* yacc.c:1646  */
    {
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 10960 "parser.c" /* yacc.c:1646  */
    break;

  case 841:
#line 5432 "parser.y" /* yacc.c:1646  */
    { 
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 10968 "parser.c" /* yacc.c:1646  */
    break;

  case 842:
#line 5439 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        check_uknown_var((yyvsp[0].name));
      (yyval.expr) = BinaryOperator(BOP_add, IdentName((yyvsp[0].name)), ZeroExpr());
    }
#line 10978 "parser.c" /* yacc.c:1646  */
    break;

  case 843:
#line 5445 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        check_uknown_var((yyvsp[-2].name));
      (yyval.expr) = BinaryOperator(BOP_add, IdentName((yyvsp[-2].name)), (yyvsp[0].expr));
    }
#line 10988 "parser.c" /* yacc.c:1646  */
    break;

  case 844:
#line 5451 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        check_uknown_var((yyvsp[-2].name));
      (yyval.expr) = BinaryOperator(BOP_sub, IdentName((yyvsp[-2].name)), (yyvsp[0].expr));
    }
#line 10998 "parser.c" /* yacc.c:1646  */
    break;

  case 845:
#line 5461 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCCANCEL, (yyvsp[-1].ocla));
    }
#line 11006 "parser.c" /* yacc.c:1646  */
    break;

  case 846:
#line 5465 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCCANCEL, OmpClauseList((yyvsp[-2].ocla), (yyvsp[-1].ocla)));
    }
#line 11014 "parser.c" /* yacc.c:1646  */
    break;

  case 847:
#line 5469 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCCANCEL, OmpClauseList((yyvsp[-3].ocla), (yyvsp[-1].ocla)));
    }
#line 11022 "parser.c" /* yacc.c:1646  */
    break;

  case 848:
#line 5476 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCPARALLEL);
    }
#line 11030 "parser.c" /* yacc.c:1646  */
    break;

  case 849:
#line 5480 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCSECTIONS);
    }
#line 11038 "parser.c" /* yacc.c:1646  */
    break;

  case 850:
#line 5484 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCFOR);
    }
#line 11046 "parser.c" /* yacc.c:1646  */
    break;

  case 851:
#line 5488 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = PlainClause(OCTASKGROUP);
    }
#line 11054 "parser.c" /* yacc.c:1646  */
    break;

  case 852:
#line 5496 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpDirective(DCCANCELLATIONPOINT, (yyvsp[-1].ocla));
    }
#line 11062 "parser.c" /* yacc.c:1646  */
    break;

  case 853:
#line 5502 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11068 "parser.c" /* yacc.c:1646  */
    break;

  case 854:
#line 5502 "parser.y" /* yacc.c:1646  */
    { sc_start_openmp(); }
#line 11074 "parser.c" /* yacc.c:1646  */
    break;

  case 855:
#line 5503 "parser.y" /* yacc.c:1646  */
    {
      (yyval.odir) = OmpThreadprivateDirective((yyvsp[-3].decl));
    }
#line 11082 "parser.c" /* yacc.c:1646  */
    break;

  case 856:
#line 5510 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11088 "parser.c" /* yacc.c:1646  */
    break;

  case 857:
#line 5510 "parser.y" /* yacc.c:1646  */
    { sc_start_openmp(); }
#line 11094 "parser.c" /* yacc.c:1646  */
    break;

  case 858:
#line 5511 "parser.y" /* yacc.c:1646  */
    {
      //$$ = TODO
    }
#line 11102 "parser.c" /* yacc.c:1646  */
    break;

  case 859:
#line 5518 "parser.y" /* yacc.c:1646  */
    {
      parse_error(1, "user-defined reductions are not implemented yet.\n");
      //$$ = OC_identifier TODO
      //Symbol($2);  TODO
    }
#line 11112 "parser.c" /* yacc.c:1646  */
    break;

  case 860:
#line 5525 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_plus;
    }
#line 11120 "parser.c" /* yacc.c:1646  */
    break;

  case 861:
#line 5529 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_times;
    }
#line 11128 "parser.c" /* yacc.c:1646  */
    break;

  case 862:
#line 5533 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_minus;
    }
#line 11136 "parser.c" /* yacc.c:1646  */
    break;

  case 863:
#line 5537 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_band;
    }
#line 11144 "parser.c" /* yacc.c:1646  */
    break;

  case 864:
#line 5541 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_xor;
    }
#line 11152 "parser.c" /* yacc.c:1646  */
    break;

  case 865:
#line 5545 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_bor;
    }
#line 11160 "parser.c" /* yacc.c:1646  */
    break;

  case 866:
#line 5549 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_land;
    }
#line 11168 "parser.c" /* yacc.c:1646  */
    break;

  case 867:
#line 5553 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_lor;
    }
#line 11176 "parser.c" /* yacc.c:1646  */
    break;

  case 868:
#line 5557 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_min;
    }
#line 11184 "parser.c" /* yacc.c:1646  */
    break;

  case 869:
#line 5561 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OC_max;
    }
#line 11192 "parser.c" /* yacc.c:1646  */
    break;

  case 870:
#line 5568 "parser.y" /* yacc.c:1646  */
    {
      //TODO
    }
#line 11200 "parser.c" /* yacc.c:1646  */
    break;

  case 871:
#line 5572 "parser.y" /* yacc.c:1646  */
    {
      //TODO
    }
#line 11208 "parser.c" /* yacc.c:1646  */
    break;

  case 872:
#line 5579 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = NULL;
    }
#line 11216 "parser.c" /* yacc.c:1646  */
    break;

  case 873:
#line 5583 "parser.y" /* yacc.c:1646  */
    {
        //TODO must check if identifier is omp_priv and that conditional
        //expression contains only omp_priv and omp_orig variables
    }
#line 11225 "parser.c" /* yacc.c:1646  */
    break;

  case 874:
#line 5588 "parser.y" /* yacc.c:1646  */
    {
      //TODO in argument_expression_list one of the variables must be &omp_priv
      // TODO check ox_funccall_expression
      //$$ = strcmp($1, "main") ?
      //       FunctionCall(IdentName($1), $3) :
      //       FunctionCall(IdentName(MAIN_NEWNAME), $3);
    }
#line 11237 "parser.c" /* yacc.c:1646  */
    break;

  case 875:
#line 5599 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = DefaultClause(OC_defshared);
    }
#line 11245 "parser.c" /* yacc.c:1646  */
    break;

  case 876:
#line 5603 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = DefaultClause(OC_defnone);
    }
#line 11253 "parser.c" /* yacc.c:1646  */
    break;

  case 877:
#line 5608 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = DefaultClause(OC_auto); //I'm using the existing subtype (Alexandros)
    }
#line 11261 "parser.c" /* yacc.c:1646  */
    break;

  case 878:
#line 5614 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11267 "parser.c" /* yacc.c:1646  */
    break;

  case 879:
#line 5615 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCPRIVATE, (yyvsp[-1].decl));
    }
#line 11276 "parser.c" /* yacc.c:1646  */
    break;

  case 880:
#line 5622 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11282 "parser.c" /* yacc.c:1646  */
    break;

  case 881:
#line 5623 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCFIRSTPRIVATE, (yyvsp[-1].decl));
    }
#line 11291 "parser.c" /* yacc.c:1646  */
    break;

  case 882:
#line 5630 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11297 "parser.c" /* yacc.c:1646  */
    break;

  case 883:
#line 5631 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCLASTPRIVATE, (yyvsp[-1].decl));
    }
#line 11306 "parser.c" /* yacc.c:1646  */
    break;

  case 884:
#line 5638 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11312 "parser.c" /* yacc.c:1646  */
    break;

  case 885:
#line 5639 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCSHARED, (yyvsp[-1].decl));
    }
#line 11321 "parser.c" /* yacc.c:1646  */
    break;

  case 886:
#line 5646 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11327 "parser.c" /* yacc.c:1646  */
    break;

  case 887:
#line 5648 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = ReductionClause((yyvsp[-4].type), (yyvsp[-1].oxli));
    }
#line 11336 "parser.c" /* yacc.c:1646  */
    break;

  case 888:
#line 5655 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11342 "parser.c" /* yacc.c:1646  */
    break;

  case 889:
#line 5656 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = IfClause((yyvsp[-1].expr), OCM_none);
    }
#line 11351 "parser.c" /* yacc.c:1646  */
    break;

  case 890:
#line 5661 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11357 "parser.c" /* yacc.c:1646  */
    break;

  case 891:
#line 5662 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.ocla) = IfClause((yyvsp[-1].expr), (yyvsp[-4].type));
    }
#line 11366 "parser.c" /* yacc.c:1646  */
    break;

  case 892:
#line 5669 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_parallel; }
#line 11372 "parser.c" /* yacc.c:1646  */
    break;

  case 893:
#line 5670 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_task; }
#line 11378 "parser.c" /* yacc.c:1646  */
    break;

  case 894:
#line 5671 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_target; }
#line 11384 "parser.c" /* yacc.c:1646  */
    break;

  case 895:
#line 5672 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_targetdata; }
#line 11390 "parser.c" /* yacc.c:1646  */
    break;

  case 896:
#line 5673 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_targetenterdata; }
#line 11396 "parser.c" /* yacc.c:1646  */
    break;

  case 897:
#line 5674 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_targetexitdata; }
#line 11402 "parser.c" /* yacc.c:1646  */
    break;

  case 898:
#line 5675 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_targetupdate; }
#line 11408 "parser.c" /* yacc.c:1646  */
    break;

  case 899:
#line 5676 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_cancel; }
#line 11414 "parser.c" /* yacc.c:1646  */
    break;

  case 900:
#line 5677 "parser.y" /* yacc.c:1646  */
    { (yyval.type) = OCM_simd; }
#line 11420 "parser.c" /* yacc.c:1646  */
    break;

  case 901:
#line 5682 "parser.y" /* yacc.c:1646  */
    {
      int n = 0, er = 0;
      if (xar_expr_is_constant((yyvsp[-1].expr)))
      {
        n = xar_calc_int_expr((yyvsp[-1].expr), &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in collapse() clause.\n");
      (yyval.ocla) = CollapseClause(n);
    }
#line 11436 "parser.c" /* yacc.c:1646  */
    break;

  case 902:
#line 5697 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 11447 "parser.c" /* yacc.c:1646  */
    break;

  case 903:
#line 5704 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 11458 "parser.c" /* yacc.c:1646  */
    break;

  case 904:
#line 5714 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oxli) = (yyvsp[0].oxli);
    }
#line 11466 "parser.c" /* yacc.c:1646  */
    break;

  case 905:
#line 5718 "parser.y" /* yacc.c:1646  */
    {
      ompxli l = (yyvsp[-2].oxli);
      
      for (; l->next; l = l->next) ;  /* Till the end */
      l->next = (yyvsp[0].oxli);
      (yyval.oxli) = (yyvsp[-2].oxli);
    }
#line 11478 "parser.c" /* yacc.c:1646  */
    break;

  case 906:
#line 5729 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      (yyval.oxli) = PlainXLI( Symbol((yyvsp[0].name)) );
    }
#line 11489 "parser.c" /* yacc.c:1646  */
    break;

  case 907:
#line 5736 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[-1].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[-1].name));
      (yyval.oxli) = ArraySection( Symbol((yyvsp[-1].name)), (yyvsp[0].oasd) );
    }
#line 11500 "parser.c" /* yacc.c:1646  */
    break;

  case 908:
#line 5750 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oxli) = (yyvsp[0].oxli);
    }
#line 11508 "parser.c" /* yacc.c:1646  */
    break;

  case 909:
#line 5754 "parser.y" /* yacc.c:1646  */
    {
      ompxli l = (yyvsp[-2].oxli);
      
      for (; l->next; l = l->next) ;  /* Till the end */
      l->next = (yyvsp[0].oxli);
      (yyval.oxli) = (yyvsp[-2].oxli);
    }
#line 11520 "parser.c" /* yacc.c:1646  */
    break;

  case 910:
#line 5765 "parser.y" /* yacc.c:1646  */
    {
      /* No check for known identifiers since constuct can be anywhere */
      (yyval.oxli) = PlainXLI( Symbol((yyvsp[0].name)) );
    }
#line 11529 "parser.c" /* yacc.c:1646  */
    break;

  case 911:
#line 5770 "parser.y" /* yacc.c:1646  */
    {
      /* No check for known identifiers since constuct can be anywhere */
      (yyval.oxli) = ArraySection( Symbol((yyvsp[-1].name)), (yyvsp[0].oasd) );
    }
#line 11538 "parser.c" /* yacc.c:1646  */
    break;

  case 912:
#line 5777 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11544 "parser.c" /* yacc.c:1646  */
    break;

  case 913:
#line 5778 "parser.y" /* yacc.c:1646  */
    {
      omparrdim d = (yyvsp[-4].oasd);
      
      sc_start_openmp();
      for (; d->next; d = d->next) ;  /* Till the end */
      d->next = (yyvsp[-1].oasd);
      (yyval.oasd) = (yyvsp[-4].oasd);
    }
#line 11557 "parser.c" /* yacc.c:1646  */
    break;

  case 914:
#line 5786 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 11563 "parser.c" /* yacc.c:1646  */
    break;

  case 915:
#line 5787 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      (yyval.oasd) = (yyvsp[-1].oasd);
    }
#line 11572 "parser.c" /* yacc.c:1646  */
    break;

  case 916:
#line 5795 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oasd) = OmpArrDim((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 11580 "parser.c" /* yacc.c:1646  */
    break;

  case 917:
#line 5799 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oasd) = OmpArrDim((yyvsp[-1].expr), NULL);
    }
#line 11588 "parser.c" /* yacc.c:1646  */
    break;

  case 918:
#line 5803 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oasd) = OmpArrDim((yyvsp[0].expr), OneExpr());
    }
#line 11596 "parser.c" /* yacc.c:1646  */
    break;

  case 919:
#line 5807 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oasd) = OmpArrDim(ZeroExpr(), (yyvsp[0].expr));
    }
#line 11604 "parser.c" /* yacc.c:1646  */
    break;

  case 920:
#line 5811 "parser.y" /* yacc.c:1646  */
    {
      (yyval.oasd) = OmpArrDim(ZeroExpr(), NULL);
    }
#line 11612 "parser.c" /* yacc.c:1646  */
    break;

  case 921:
#line 5819 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = ProcBindClause(OC_bindmaster);
    }
#line 11620 "parser.c" /* yacc.c:1646  */
    break;

  case 922:
#line 5823 "parser.y" /* yacc.c:1646  */
    {	
      (yyval.ocla) = ProcBindClause(OC_bindprimary);
    }
#line 11628 "parser.c" /* yacc.c:1646  */
    break;

  case 923:
#line 5827 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = ProcBindClause(OC_bindclose);
    }
#line 11636 "parser.c" /* yacc.c:1646  */
    break;

  case 924:
#line 5831 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = ProcBindClause(OC_bindspread);
    }
#line 11644 "parser.c" /* yacc.c:1646  */
    break;

  case 925:
#line 5843 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
      {
        stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
        if (e == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
        if (e->scopelevel != stab->scopelevel)
          parse_error(-1, "threadprivate directive appears at different "
                          "scope level\nfrom the one `%s' was declared.\n", (yyvsp[0].name));
        if (stab->scopelevel > 0)    /* Don't care for globals */
          if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_static) == NULL)
            parse_error(-1, "threadprivate variable `%s' does not have static "
                            "storage type.\n", (yyvsp[0].name));
        e->isthrpriv = true;   /* Mark */
      }
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 11666 "parser.c" /* yacc.c:1646  */
    break;

  case 926:
#line 5861 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls)
      {
        stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
        if (e == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
        if (e->scopelevel != stab->scopelevel)
          parse_error(-1, "threadprivate directive appears at different "
                          "scope level\nfrom the one `%s' was declared.\n", (yyvsp[0].name));
        if (stab->scopelevel > 0)    /* Don't care for globals */
          if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_static) == NULL)
            parse_error(-1, "threadprivate variable `%s' does not have static "
                            "storage type.\n", (yyvsp[0].name));
        e->isthrpriv = true;   /* Mark */
      }
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 11688 "parser.c" /* yacc.c:1646  */
    break;

  case 927:
#line 5894 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTASKSYNC, (yyvsp[0].xdir), NULL);
    }
#line 11696 "parser.c" /* yacc.c:1646  */
    break;

  case 928:
#line 5898 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTASKSCHEDULE, (yyvsp[0].xdir), NULL);
    }
#line 11704 "parser.c" /* yacc.c:1646  */
    break;

  case 929:
#line 5905 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xdir) = OmpixDirective(OX_DCTASKSYNC, NULL);
    }
#line 11712 "parser.c" /* yacc.c:1646  */
    break;

  case 930:
#line 5912 "parser.y" /* yacc.c:1646  */
    {
      scope_start(stab);
    }
#line 11720 "parser.c" /* yacc.c:1646  */
    break;

  case 931:
#line 5916 "parser.y" /* yacc.c:1646  */
    {
      scope_end(stab);
      (yyval.xdir) = OmpixDirective(OX_DCTASKSCHEDULE, (yyvsp[-1].xcla));
    }
#line 11729 "parser.c" /* yacc.c:1646  */
    break;

  case 932:
#line 5924 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = NULL;
    }
#line 11737 "parser.c" /* yacc.c:1646  */
    break;

  case 933:
#line 5928 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-1].xcla), (yyvsp[0].xcla));
    }
#line 11745 "parser.c" /* yacc.c:1646  */
    break;

  case 934:
#line 5932 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-2].xcla), (yyvsp[0].xcla));
    }
#line 11753 "parser.c" /* yacc.c:1646  */
    break;

  case 935:
#line 5939 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixStrideClause((yyvsp[-1].expr));
    }
#line 11761 "parser.c" /* yacc.c:1646  */
    break;

  case 936:
#line 5943 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixStartClause((yyvsp[-1].expr));
    }
#line 11769 "parser.c" /* yacc.c:1646  */
    break;

  case 937:
#line 5947 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixScopeClause((yyvsp[-1].type));
    }
#line 11777 "parser.c" /* yacc.c:1646  */
    break;

  case 938:
#line 5951 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCTIED);
    }
#line 11785 "parser.c" /* yacc.c:1646  */
    break;

  case 939:
#line 5955 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCUNTIED);
    }
#line 11793 "parser.c" /* yacc.c:1646  */
    break;

  case 940:
#line 5962 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OX_SCOPE_NODES;
    }
#line 11801 "parser.c" /* yacc.c:1646  */
    break;

  case 941:
#line 5966 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OX_SCOPE_WGLOBAL;
    }
#line 11809 "parser.c" /* yacc.c:1646  */
    break;

  case 942:
#line 5970 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OX_SCOPE_WGLOBAL;
    }
#line 11817 "parser.c" /* yacc.c:1646  */
    break;

  case 943:
#line 5974 "parser.y" /* yacc.c:1646  */
    {
      (yyval.type) = OX_SCOPE_WLOCAL;
    }
#line 11825 "parser.c" /* yacc.c:1646  */
    break;

  case 944:
#line 5981 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = (yyvsp[0].xcon);
    }
#line 11833 "parser.c" /* yacc.c:1646  */
    break;

  case 945:
#line 5985 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = (yyvsp[0].xcon);
    }
#line 11841 "parser.c" /* yacc.c:1646  */
    break;

  case 946:
#line 5989 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = (yyvsp[0].xcon);
    }
#line 11849 "parser.c" /* yacc.c:1646  */
    break;

  case 947:
#line 5993 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = (yyvsp[0].xcon);
    }
#line 11857 "parser.c" /* yacc.c:1646  */
    break;

  case 948:
#line 6001 "parser.y" /* yacc.c:1646  */
    {
      /* Should put the name of the callback function in the stab, too
      if (symtab_get(stab, decl_getidentifier_symbol($2->u.declaration.decl),
            FUNCNAME) == NULL)
        symtab_put(stab, decl_getidentifier_symbol($2->u.declaration.spec),
            FUNCNAME);
      */
      scope_start(stab);   /* re-declare the arguments of the task function */
      ast_declare_function_params((yyvsp[0].stmt)->u.declaration.decl);
    }
#line 11872 "parser.c" /* yacc.c:1646  */
    break;

  case 949:
#line 6012 "parser.y" /* yacc.c:1646  */
    {
      scope_end(stab);
      (yyval.xcon) = OmpixTaskdef((yyvsp[-3].xdir), (yyvsp[-2].stmt), (yyvsp[0].stmt));
      (yyval.xcon)->l = (yyvsp[-3].xdir)->l;
    }
#line 11882 "parser.c" /* yacc.c:1646  */
    break;

  case 950:
#line 6018 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixTaskdef((yyvsp[-1].xdir), (yyvsp[0].stmt), NULL);
      (yyval.xcon)->l = (yyvsp[-1].xdir)->l;
    }
#line 11891 "parser.c" /* yacc.c:1646  */
    break;

  case 951:
#line 6026 "parser.y" /* yacc.c:1646  */
    {
      scope_start(stab);
    }
#line 11899 "parser.c" /* yacc.c:1646  */
    break;

  case 952:
#line 6030 "parser.y" /* yacc.c:1646  */
    {
      scope_end(stab);
      (yyval.xdir) = OmpixDirective(OX_DCTASKDEF, (yyvsp[-1].xcla));
    }
#line 11908 "parser.c" /* yacc.c:1646  */
    break;

  case 953:
#line 6038 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = NULL;
    }
#line 11916 "parser.c" /* yacc.c:1646  */
    break;

  case 954:
#line 6042 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-1].xcla), (yyvsp[0].xcla));
    }
#line 11924 "parser.c" /* yacc.c:1646  */
    break;

  case 955:
#line 6046 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-2].xcla), (yyvsp[0].xcla));
    }
#line 11932 "parser.c" /* yacc.c:1646  */
    break;

  case 956:
#line 6053 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixVarlistClause(OX_OCIN, (yyvsp[-1].decl));
    }
#line 11940 "parser.c" /* yacc.c:1646  */
    break;

  case 957:
#line 6057 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixVarlistClause(OX_OCOUT, (yyvsp[-1].decl));
    }
#line 11948 "parser.c" /* yacc.c:1646  */
    break;

  case 958:
#line 6061 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixVarlistClause(OX_OCINOUT, (yyvsp[-1].decl));
    }
#line 11956 "parser.c" /* yacc.c:1646  */
    break;

  case 959:
#line 6065 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixReductionClause((yyvsp[-3].type), (yyvsp[-1].decl));
    }
#line 11964 "parser.c" /* yacc.c:1646  */
    break;

  case 960:
#line 6072 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 11972 "parser.c" /* yacc.c:1646  */
    break;

  case 961:
#line 6076 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = IdList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 11980 "parser.c" /* yacc.c:1646  */
    break;

  case 962:
#line 6083 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
      symtab_put(stab, Symbol((yyvsp[0].name)), IDNAME);
    }
#line 11989 "parser.c" /* yacc.c:1646  */
    break;

  case 963:
#line 6088 "parser.y" /* yacc.c:1646  */
    {
      if (checkDecls) check_uknown_var((yyvsp[-1].name));
      /* Use extern to differentiate */
      (yyval.decl) = ArrayDecl(IdentifierDecl( Symbol((yyvsp[-4].name)) ), StClassSpec(SPEC_extern),
                     IdentName((yyvsp[-1].name)));
      symtab_put(stab, Symbol((yyvsp[-4].name)), IDNAME);
    }
#line 12001 "parser.c" /* yacc.c:1646  */
    break;

  case 964:
#line 6096 "parser.y" /* yacc.c:1646  */
    {
      (yyval.decl) = ArrayDecl(IdentifierDecl( Symbol((yyvsp[-3].name)) ), NULL, (yyvsp[-1].expr));
      symtab_put(stab, Symbol((yyvsp[-3].name)), IDNAME);
    }
#line 12010 "parser.c" /* yacc.c:1646  */
    break;

  case 965:
#line 6104 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTASK, (yyvsp[-5].xdir), 
             FuncCallStmt(IdentName(strcmp((yyvsp[-4].name),"main") ? (yyvsp[-4].name) : MAIN_NEWNAME),(yyvsp[-2].expr)));
      (yyval.xcon)->l = (yyvsp[-5].xdir)->l;
    }
#line 12020 "parser.c" /* yacc.c:1646  */
    break;

  case 966:
#line 6113 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xdir) = OmpixDirective(OX_DCTASK, (yyvsp[-1].xcla));
    }
#line 12028 "parser.c" /* yacc.c:1646  */
    break;

  case 967:
#line 6120 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = NULL;
    }
#line 12036 "parser.c" /* yacc.c:1646  */
    break;

  case 968:
#line 6124 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-1].xcla), (yyvsp[0].xcla));
    }
#line 12044 "parser.c" /* yacc.c:1646  */
    break;

  case 969:
#line 6128 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-2].xcla), (yyvsp[0].xcla));
    }
#line 12052 "parser.c" /* yacc.c:1646  */
    break;

  case 970:
#line 6135 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCATALL);
    }
#line 12060 "parser.c" /* yacc.c:1646  */
    break;

  case 971:
#line 6139 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixAtnodeClause((yyvsp[-1].expr));
    }
#line 12068 "parser.c" /* yacc.c:1646  */
    break;

  case 972:
#line 6143 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCLOCAL);
    }
#line 12076 "parser.c" /* yacc.c:1646  */
    break;

  case 973:
#line 6147 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCREMOTE);
    }
#line 12084 "parser.c" /* yacc.c:1646  */
    break;

  case 974:
#line 6151 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixAtworkerClause((yyvsp[-1].expr));
    }
#line 12092 "parser.c" /* yacc.c:1646  */
    break;

  case 975:
#line 6155 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCTIED);
    }
#line 12100 "parser.c" /* yacc.c:1646  */
    break;

  case 976:
#line 6159 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCUNTIED);
    }
#line 12108 "parser.c" /* yacc.c:1646  */
    break;

  case 977:
#line 6163 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCDETACHED);
    }
#line 12116 "parser.c" /* yacc.c:1646  */
    break;

  case 978:
#line 6167 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixHintsClause((yyvsp[-1].expr));
    }
#line 12124 "parser.c" /* yacc.c:1646  */
    break;

  case 979:
#line 6171 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixIfClause((yyvsp[-1].expr));
    }
#line 12132 "parser.c" /* yacc.c:1646  */
    break;

  case 980:
#line 6179 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixConstruct(OX_DCPROCEXT, (yyvsp[0].xdir), NULL);
    }
#line 12140 "parser.c" /* yacc.c:1646  */
    break;

  case 981:
#line 6186 "parser.y" /* yacc.c:1646  */
    { sc_pause_ompix(); }
#line 12146 "parser.c" /* yacc.c:1646  */
    break;

  case 982:
#line 6186 "parser.y" /* yacc.c:1646  */
    { sc_start_ompix(); }
#line 12152 "parser.c" /* yacc.c:1646  */
    break;

  case 983:
#line 6187 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xdir) = OmpixDirective(OX_DCPROCEXT, NULL);
      (yyval.xdir)->varlist = (yyvsp[-3].decl);
    }
#line 12161 "parser.c" /* yacc.c:1646  */
    break;

  case 984:
#line 6195 "parser.y" /* yacc.c:1646  */
    {
      stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
      
      if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
        parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      if (e->scopelevel != 0)
        parse_error(-1, "procshared directive should only be used for global "
                        "variables (%s).\n", (yyvsp[0].name));
      if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_extern) == NULL)
        parse_warning("variable `%s' is not declared as extern; ignoring\n", (yyvsp[0].name));
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 12178 "parser.c" /* yacc.c:1646  */
    break;

  case 985:
#line 6208 "parser.y" /* yacc.c:1646  */
    {
      stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
      
      if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
        parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      if (e->scopelevel != 0)
        parse_error(-1, "procshared directive should only be used for global "
                        "variables (%s).\n", (yyvsp[0].name));
      if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_extern) == NULL)
        parse_warning("variable `%s' is not declared as extern; ignoring\n", (yyvsp[0].name));
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 12195 "parser.c" /* yacc.c:1646  */
    break;

  case 986:
#line 6224 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTAG, (yyvsp[-1].xdir), OmpStmt((yyvsp[0].ocon)));
    }
#line 12203 "parser.c" /* yacc.c:1646  */
    break;

  case 987:
#line 6228 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTAG, (yyvsp[-1].xdir), OmpixStmt((yyvsp[0].xcon)));
    }
#line 12211 "parser.c" /* yacc.c:1646  */
    break;

  case 988:
#line 6235 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xdir) = OmpixDirective(OX_DCTAG, (yyvsp[-1].xcla));
    }
#line 12219 "parser.c" /* yacc.c:1646  */
    break;

  case 989:
#line 6242 "parser.y" /* yacc.c:1646  */
    {
      (yyval.xcla) = OmpixClause(OX_OCTAG, NULL, String((yyvsp[-1].string)));
    }
#line 12227 "parser.c" /* yacc.c:1646  */
    break;

  case 990:
#line 6245 "parser.y" /* yacc.c:1646  */
    { sc_pause_ompix(); }
#line 12233 "parser.c" /* yacc.c:1646  */
    break;

  case 991:
#line 6246 "parser.y" /* yacc.c:1646  */
    {
      sc_start_ompix();
      symbol s = Symbol((yyvsp[-1].name));
	    if (checkDecls && symtab_get(stab, s, IDNAME) == NULL)
		    parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[-1].name));
      (yyval.xcla) = OmpixClause(OX_OCTAG, NULL, CommaList(String((yyvsp[-4].string)), Identifier(s)));
    }
#line 12245 "parser.c" /* yacc.c:1646  */
    break;

  case 992:
#line 6257 "parser.y" /* yacc.c:1646  */
    {
      (yyval.ocla) = TagClause(String((yyvsp[-1].string)));
    }
#line 12253 "parser.c" /* yacc.c:1646  */
    break;

  case 993:
#line 6260 "parser.y" /* yacc.c:1646  */
    { sc_pause_openmp(); }
#line 12259 "parser.c" /* yacc.c:1646  */
    break;

  case 994:
#line 6261 "parser.y" /* yacc.c:1646  */
    {
      sc_start_openmp();
      symbol s = Symbol((yyvsp[-1].name));
	    if (checkDecls && symtab_get(stab, s, IDNAME) == NULL)
		    parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[-1].name));
      (yyval.ocla) = TagClause(CommaList(String((yyvsp[-4].string)), Identifier(s)));
    }
#line 12271 "parser.c" /* yacc.c:1646  */
    break;


#line 12275 "parser.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 6270 "parser.y" /* yacc.c:1906  */



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                               *
 *     CODE                                                      *
 *                                                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


void yyerror(const char *s)
{
	fprintf(stderr, "(file %s, line %d, column %d):\n\t%s\n",
	                sc_original_file(), sc_original_line(), sc_column(), s);
}


/* Utility function 
 */
char *strdupcat(char *first, char *second, int freethem)
{
	char *res;
	
	if (first == NULL && second == NULL)
		return NULL;
	if (first == NULL) 
		return (freethem) ? second : strdup(second);
	if (second == NULL) 
		return (freethem) ? first : strdup(first);
	if ((res = malloc(strlen(first)+strlen(second)+1)) == NULL)
		parse_error(1, "strdupcat ran out of memory\n");
	sprintf(res, "%s%s", first, second);
	if (freethem)
	{
		free(first);
		free(second);
	}
	return res;
}


/* Check whether the identifier is known or not
 */
void check_uknown_var(char *name)
{
	symbol s = Symbol(name);
	if (symtab_get(stab, s, IDNAME) == NULL &&
			symtab_get(stab, s, LABELNAME) == NULL &&
			symtab_get(stab, s, FUNCNAME) == NULL)
		parse_error(-1, "unknown identifier `%s'.\n", name);
}



/* See the "declaration" rule: if the last element of the list
 * is a user typename, we remove it, and we return it as an
 * identifier declarator.
 * The list should have 3 elements (typedef xxx type).
 */
astdecl fix_known_typename(astspec s)
{
	astspec prev;
	astdecl d;

	if (s->type != SPECLIST || s->u.next->type != SPECLIST) return (NULL);

	for (; s->u.next->type == SPECLIST; prev = s, s = s->u.next)
		;   /* goto last list node */
	if (s->u.next->type != USERTYPE)         /* nope */
		return (NULL);

	prev->u.next = s->body;

	d = Declarator(NULL, IdentifierDecl(s->u.next->name));
	if (checkDecls)
		symtab_put(stab, s->u.next->name, TYPENAME);
	free(s);
	return (d);
}


void check_for_main_and_declare(astspec s, astdecl d)
{
	astdecl n = decl_getidentifier(d);

	assert(d->type == DECLARATOR);
	assert(d->decl->type == DFUNC);

	if (strcmp(n->u.id->name, "main") == 0)
	{
		n->u.id = Symbol(MAIN_NEWNAME);         /* Catch main()'s definition */
		hasMainfunc = 1;

		/* Now check for return type and # parameters */
		/* It d != NULL then its parameters is either (id or idlist) or
		* (paramtype or parmatypelist). If it is a list, assume the
		* standard 2 params, otherwise, we guess the single argument
		* must be the type "void" which means no params.
		* In any case, we always force main have (argc, argv[]).
		*/
		if (d->decl->u.params == NULL || d->decl->u.params->type != DLIST)
			d->decl->u.params =
					ParamList(
						ParamDecl(
							Declspec(SPEC_int),
							Declarator( NULL, IdentifierDecl( Symbol("_argc_ignored") ) )
						),
						ParamDecl(
							Declspec(SPEC_char),
							Declarator(Speclist_right( Pointer(), Pointer() ),
												IdentifierDecl( Symbol("_argv_ignored") ))
						)
					);

		mainfuncRettype = 0; /* int */
		if (s != NULL)
		{
			for (; s->type == SPECLIST && s->subtype == SPEC_Rlist; s = s->u.next)
				if (s->body->type == SPEC && s->body->subtype == SPEC_void)
				{
					s = s->body;
					break;
				};
			if (s->type == SPEC && s->subtype == SPEC_void)
				mainfuncRettype = 1; /* void */
		}
	}
	if (symtab_get(stab, n->u.id, FUNCNAME) == NULL)/* From earlier declaration */
		symtab_put(stab, n->u.id, FUNCNAME);
}


/* For each variable/typename in the given declaration, add pointers in the
 * symbol table entries back to the declaration nodes.
 */
void add_declaration_links(astspec s, astdecl d)
{
	astdecl ini = NULL;

	if (d->type == DLIST && d->subtype == DECL_decllist)
	{
		add_declaration_links(s, d->u.next);
		d = d->decl;
	}
	if (d->type == DINIT) d = (ini = d)->decl;   /* Skip the initializer */
	assert(d->type == DECLARATOR);
	if (d->decl != NULL && d->decl->type != ABSDECLARATOR)
	{
		symbol  t = decl_getidentifier_symbol(d->decl);
		stentry e = isTypedef ?
		            symtab_get(stab,t,TYPENAME) :
		            symtab_get(stab,t,(decl_getkind(d)==DFUNC) ? FUNCNAME : IDNAME);
		e->spec  = s;
		e->decl  = d;
		e->idecl = ini;
	}
}


void  check_schedule(ompclsubt_e sched, ompclmod_e mod)
{
	if (mod == OCM_none) return;
	if (mod == OCM_nonmonotonic && sched != OC_dynamic && sched != OC_guided)
		parse_error(1, "nonmonotonic modifier is only allowed in dynamic or "
		                 "guided schedules\n");
}


void parse_error(int exitvalue, char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	fprintf(stderr, "(%s, line %d)\n\t", sc_original_file(), sc_original_line());
	vfprintf(stderr, format, ap);
	va_end(ap);
	if (strcmp(sc_original_file(), "injected_code") == 0)
		fprintf(stderr, "\n>>>>>>>\n%s\n>>>>>>>\n", parsingstring);
	_exit(exitvalue);
}


void parse_warning(char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	fprintf(stderr, "[warning] ");
	vfprintf(stderr, format, ap);
	va_end(ap);
}


aststmt parse_file(char *fname, int *error)
{
	*error = 0;
	if ( (yyin = fopen(fname, "r")) == NULL )
		return (NULL);
	sc_set_filename(fname);      /* Inform the scanner */
	*error = yyparse();
	fclose(yyin);                /* No longer needed */
	return (pastree);
}


#define PARSE_STRING_SIZE 16384


astexpr parse_expression_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_EXPRESSION);

	savecD = checkDecls;
	checkDecls = 0;         /* Don't check identifiers & don't declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_expr );
}


aststmt parse_blocklist_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_BLOCKLIST);

	savecD = checkDecls;
	checkDecls = 0;         /* Don't check identifiers & don't declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_stmt );
}


aststmt parse_and_declare_blocklist_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_BLOCKLIST);

	savecD = checkDecls;
	checkDecls = 1;         /* Do check identifiers & do declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_stmt );
}


aststmt parse_transunit_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_TRANSUNIT);

	savecD = checkDecls;
	checkDecls = 0;         /* Don't check identifiers & don't declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_stmt );
}
