/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_loops.h -- utility functions related to OMP loops */

#ifndef __X_LOOPS_H__
#define __X_LOOPS_H__

#include "ast.h"

#define MAXLOOPS 96                  /* Max supported # loops in a loop nest */
#define NORMALIZEDITER "iter_"       /* The normalized iteration index name */
#define DOACCPARAMS "_doacc_params_" /* Do-across loop parameters name */

extern symbol *ompfor_get_indices(aststmt s, int orderednum);
extern void    analyze_omp_for(aststmt s,
                     symbol *var, astexpr *lb, astexpr *b, astexpr *step,
                     int *condop, int *incrop); 
extern astexpr specs2iters(astexpr l, astexpr u, astexpr s, 
                           int stepdir, int plainstep);


/* Handy macros for code generation 
 */

#define ITERCNT_SPECS \
        Speclist_right(Declspec(SPEC_unsigned), Declspec(SPEC_long))

#define CastLong(t) \
	CastedExpr(Casttypename(Declspec(SPEC_long), NULL), Parenthesis(t))

/* Generates "{ (long) ((u)-(l)), (long) s) }" */
#define LongArray2Initer(u,l,s) \
	BracedInitializer(\
	  CommaList(\
	    CastLong(\
	      Parenthesis( \
	        BinaryOperator(BOP_sub, \
	          ast_expr_copy(u), \
	          ast_expr_copy(l) \
	        )\
	      )\
	    ), \
	    CastLong(ast_expr_copy(s))\
	  )\
	)


/* Generates "{ (long) (l), (long) s, (long) iters_xx }" 
 * The step (second field) has a sign depending on the direction increment.
 */
#define LongArray3Initer(l,s,d,itid) \
	BracedInitializer(\
	    Comma3(\
	        CastLong(ast_expr_copy(l)), \
          CastLong( \
            ast_expr_copy((d) == BOP_add ? \
              (s) : UnaryOperator(UOP_neg, Parenthesis(s)))), \
	        CastLong(itid) \
	    )\
	)

#endif /* __X_LOOPS_H__ */
